/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.chain.ChainLink;
import com.github.legoatoom.connectiblechains.client.ClientInitializer;
import com.github.legoatoom.connectiblechains.client.render.entity.ChainRenderer;
import com.github.legoatoom.connectiblechains.client.render.entity.model.ChainKnotEntityModel;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.util.Helper;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5617;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.class_897;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ChainKnotEntityRenderer
extends class_897<ChainKnotEntity> {
    private final ChainKnotEntityModel<ChainKnotEntity> model;
    private final ChainRenderer chainRenderer = new ChainRenderer();

    public ChainKnotEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new ChainKnotEntityModel(context.method_32167(ClientInitializer.CHAIN_KNOT));
    }

    public ChainRenderer getChainRenderer() {
        return this.chainRenderer;
    }

    public boolean shouldRender(ChainKnotEntity entity, class_4604 frustum, double x, double y, double z) {
        if (entity.field_5985) {
            return true;
        }
        for (ChainLink link : entity.getLinks()) {
            if (link.primary != entity) continue;
            if (link.secondary instanceof class_1657) {
                return true;
            }
            if (!link.secondary.method_5727(x, y, z)) continue;
            return true;
        }
        return super.method_3933((class_1297)entity, frustum, x, y, z);
    }

    public void render(ChainKnotEntity chainKnotEntity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (chainKnotEntity.shouldRenderKnot()) {
            matrices.method_22903();
            class_243 leashOffset = chainKnotEntity.method_30951(tickDelta).method_1020(chainKnotEntity.method_30950(tickDelta));
            matrices.method_22904(leashOffset.field_1352, leashOffset.field_1351 + 0.40625, leashOffset.field_1350);
            matrices.method_22905(0.8333333f, 1.0f, 0.8333333f);
            class_4588 vertexConsumer = vertexConsumers.getBuffer(this.model.method_23500(this.getKnotTexture(chainKnotEntity.getChainItemSource())));
            this.model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            matrices.method_22909();
        }
        List<ChainLink> links = chainKnotEntity.getLinks();
        for (ChainLink link : links) {
            if (link.primary != chainKnotEntity || link.isDead()) continue;
            this.renderChainLink(link, tickDelta, matrices, vertexConsumers);
            if (!ConnectibleChains.runtimeConfig.doDebugDraw()) continue;
            this.drawDebugVector(matrices, (class_1297)chainKnotEntity, link.secondary, vertexConsumers.getBuffer((class_1921)class_1921.field_21695));
        }
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            matrices.method_22903();
            class_5250 holdingCount = class_5250.method_43477((class_7417)new class_2585("F: " + chainKnotEntity.getLinks().stream().filter(l -> l.primary == chainKnotEntity).count()));
            class_5250 heldCount = class_5250.method_43477((class_7417)new class_2585("T: " + chainKnotEntity.getLinks().stream().filter(l -> l.secondary == chainKnotEntity).count()));
            matrices.method_22904(0.0, 0.25, 0.0);
            this.method_3926((class_1297)chainKnotEntity, (class_2561)holdingCount, matrices, vertexConsumers, light);
            matrices.method_22904(0.0, 0.25, 0.0);
            this.method_3926((class_1297)chainKnotEntity, (class_2561)heldCount, matrices, vertexConsumers, light);
            matrices.method_22909();
        }
        super.method_3936((class_1297)chainKnotEntity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    private class_2960 getKnotTexture(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return new class_2960(id.method_12836(), "textures/item/" + id.method_12832() + ".png");
    }

    private class_2960 getChainTexture(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return new class_2960(id.method_12836(), "textures/block/" + id.method_12832() + ".png");
    }

    private void renderChainLink(ChainLink link, float tickDelta, class_4587 matrices, class_4597 vertexConsumerProvider) {
        ChainKnotEntity fromEntity = link.primary;
        class_1297 toEntity = link.secondary;
        matrices.method_22903();
        class_243 srcPos = fromEntity.method_19538().method_1019(fromEntity.method_29919());
        class_243 dstPos = toEntity instanceof class_1530 ? toEntity.method_19538().method_1019(toEntity.method_29919()) : toEntity.method_30951(tickDelta);
        class_243 leashOffset = fromEntity.method_29919();
        matrices.method_22904(leashOffset.field_1352, leashOffset.field_1351, leashOffset.field_1350);
        class_1792 sourceItem = link.sourceItem;
        class_1921 entityCutout = class_1921.method_23578((class_2960)this.getChainTexture(sourceItem));
        class_4588 buffer = vertexConsumerProvider.getBuffer(entityCutout);
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            buffer = vertexConsumerProvider.getBuffer(class_1921.method_23594());
        }
        class_243 offset = Helper.getChainOffset(srcPos, dstPos);
        matrices.method_22904(offset.method_10216(), 0.0, offset.method_10215());
        class_2338 blockPosOfStart = class_2338.method_49638((class_2374)fromEntity.method_5836(tickDelta));
        class_2338 blockPosOfEnd = class_2338.method_49638((class_2374)toEntity.method_5836(tickDelta));
        int blockLightLevelOfStart = fromEntity.method_37908().method_8314(class_1944.field_9282, blockPosOfStart);
        int blockLightLevelOfEnd = toEntity.method_37908().method_8314(class_1944.field_9282, blockPosOfEnd);
        int skylightLevelOfStart = fromEntity.method_37908().method_8314(class_1944.field_9284, blockPosOfStart);
        int skylightLevelOfEnd = fromEntity.method_37908().method_8314(class_1944.field_9284, blockPosOfEnd);
        class_243 startPos = srcPos.method_1031(offset.method_10216(), 0.0, offset.method_10215());
        class_243 endPos = dstPos.method_1031(-offset.method_10216(), 0.0, -offset.method_10215());
        Vector3f chainVec = new Vector3f((float)(endPos.field_1352 - startPos.field_1352), (float)(endPos.field_1351 - startPos.field_1351), (float)(endPos.field_1350 - startPos.field_1350));
        float angleY = -((float)Math.atan2(chainVec.z(), chainVec.x()));
        matrices.method_22907(new Quaternionf().rotateXYZ(0.0f, angleY, 0.0f));
        if (toEntity instanceof class_1530) {
            ChainRenderer.BakeKey key = new ChainRenderer.BakeKey(fromEntity.method_19538(), toEntity.method_19538());
            this.chainRenderer.renderBaked(buffer, matrices, key, chainVec, blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        } else {
            this.chainRenderer.render(buffer, matrices, chainVec, blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        }
        matrices.method_22909();
    }

    private void drawDebugVector(class_4587 matrices, class_1297 fromEntity, class_1297 toEntity, class_4588 buffer) {
        if (toEntity == null) {
            return;
        }
        Matrix4f modelMat = matrices.method_23760().method_23761();
        class_243 vec = toEntity.method_19538().method_1020(fromEntity.method_19538());
        class_243 normal = vec.method_1029();
        buffer.method_22918(modelMat, 0.0f, 0.0f, 0.0f).method_1336(0, 255, 0, 255).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
        buffer.method_22918(modelMat, (float)vec.field_1352, (float)vec.field_1351, (float)vec.field_1350).method_1336(255, 0, 0, 255).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
    }

    public class_2960 getTexture(ChainKnotEntity entity) {
        return this.getKnotTexture(entity.getChainItemSource());
    }
}

