/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.block.blockentity;

import com.github.mim1q.convenientdecor.block.WeatherVaneBlock;
import com.github.mim1q.convenientdecor.init.ModBlockEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5268;
import net.minecraft.class_5819;

public class WeatherVaneBlockEntity
extends class_2586 {
    private static final float BASE_MAX_VELOCITY = 0.5f;
    private static final float BASE_ACCELERATION = 0.35f;
    private float lastYaw = 0.0f;
    private float yaw = class_5819.method_43047().method_43057() * 360.0f;
    private float acceleration = 0.0f;
    private float maxVelocity = 0.0f;
    private float velocity = 0.0f;

    public WeatherVaneBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.WEATHER_VANE, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        float nextVelocity;
        int multiplier = (Integer)state.method_11654((class_2769)WeatherVaneBlock.POWER) + 1;
        if (!world.field_9236 && world.method_8510() % 20L == 0L) {
            this.updatePower((class_3218)world, state);
            this.method_5431();
            return;
        }
        class_5819 rng = world.method_8409();
        if (world.method_8510() % 20L == 0L && rng.method_43057() < 0.25f * (float)multiplier) {
            this.maxVelocity = rng.method_43057() * 0.5f * (float)multiplier;
            this.acceleration = (rng.method_43056() ? -1.0f : 1.0f) * (0.35f * rng.method_43057());
        }
        this.velocity = Math.abs(nextVelocity = this.velocity + this.acceleration * (float)multiplier) > this.maxVelocity * (float)multiplier ? this.maxVelocity * (float)multiplier * Math.signum(nextVelocity) : nextVelocity;
        this.lastYaw = this.yaw;
        this.yaw += this.velocity;
        this.acceleration *= 0.9f;
        this.velocity *= 0.95f;
    }

    public void updatePower(class_3218 world, class_2680 state) {
        int power = (Boolean)state.method_11654((class_2769)WeatherVaneBlock.FORECAST_MODE) != false ? WeatherVaneBlockEntity.getWeatherPredictionStrength(world, ((WeatherVaneBlock)state.method_26204()).timeUnit) : WeatherVaneBlockEntity.getStrengthFromWeather(world);
        int lastPower = (Integer)state.method_11654((class_2769)WeatherVaneBlock.POWER);
        world.method_8501(this.method_11016(), (class_2680)state.method_11657((class_2769)WeatherVaneBlock.POWER, (Comparable)Integer.valueOf(power)));
        if (power != lastPower) {
            world.method_8408(this.method_11016(), this.method_11010().method_26204());
            world.method_8408(this.method_11016().method_10074(), this.method_11010().method_26204());
        }
    }

    public static int getWeatherPredictionStrength(class_3218 world, int timeUnit) {
        class_5268 properties = (class_5268)world.method_8401();
        if (world.method_8419() || properties.method_155() == 0) {
            return WeatherVaneBlockEntity.getStrengthFromRemainingTime(properties.method_190(), timeUnit);
        }
        return WeatherVaneBlockEntity.getStrengthFromRemainingTime(properties.method_155(), timeUnit);
    }

    public static int getStrengthFromRemainingTime(float remainingTime, int timeUnit) {
        int timeUnits = (int)(remainingTime / (float)timeUnit) + 1;
        return class_3532.method_15340((int)(16 - timeUnits), (int)0, (int)15);
    }

    public static int getStrengthFromWeather(class_3218 world) {
        if (world.method_8546()) {
            return 15;
        }
        if (world.method_8419()) {
            return 7;
        }
        return 0;
    }

    public float getYaw(float tickDelta) {
        return this.lastYaw + tickDelta * (this.yaw - this.lastYaw);
    }
}

