/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.common.core.modconfig;

import com.corosus.coroutil.common.core.modconfig.ConfigAddQueue;
import com.corosus.coroutil.common.core.modconfig.ConfigComment;
import com.corosus.coroutil.common.core.modconfig.ConfigEntryInfo;
import com.corosus.coroutil.common.core.modconfig.ConfigMod;
import com.corosus.coroutil.common.core.modconfig.IConfigCategory;
import com.corosus.coroutil.common.core.modconfig.ModConfigData;
import com.corosus.coroutil.common.core.util.CULog;
import com.corosus.coroutil.common.core.util.OldUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CoroConfigRegistry {
    private static final CoroConfigRegistry instance = new CoroConfigRegistry();
    public List<ModConfigData> configs = new ArrayList<ModConfigData>();
    public List<ModConfigData> liveEditConfigs = new ArrayList<ModConfigData>();
    public ConcurrentHashMap<String, ModConfigData> lookupRegistryNameToConfig = new ConcurrentHashMap();
    public ConcurrentHashMap<String, ModConfigData> lookupFilePathToConfig = new ConcurrentHashMap();
    public List<ConfigAddQueue> deferredRegistryQueue = new ArrayList<ConfigAddQueue>();
    private boolean fullyLoaded = false;

    private CoroConfigRegistry() {
    }

    public static CoroConfigRegistry instance() {
        return instance;
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    public void setFullyLoaded(boolean fullyLoaded) {
        this.fullyLoaded = fullyLoaded;
    }

    public void processQueue() {
        this.setFullyLoaded(true);
        for (ConfigAddQueue configAddQueue : this.deferredRegistryQueue) {
            this.addConfigFile(configAddQueue.modID, configAddQueue.config);
        }
    }

    public void onLoadOrReload(String filename) {
        ModConfigData configData = this.lookupFilePathToConfig.get(filename);
        if (configData != null) {
            CoroConfigRegistry.dbg("Coro ConfigMod updating runtime values for file: " + filename);
            configData.updateConfigFieldValues();
            configData.configInstance.hookUpdatedValues();
        } else {
            CoroConfigRegistry.dbg("ERROR, cannot find ModConfigData reference for filename: " + filename);
        }
    }

    public void updateAllConfigsFromForge() {
        for (ModConfigData configData : this.lookupFilePathToConfig.values()) {
            CoroConfigRegistry.dbg("Coro ConfigMod updating runtime values for file: " + configData.saveFilePath);
            configData.updateConfigFieldValues();
            configData.configInstance.hookUpdatedValues();
        }
    }

    public void processHashMap(String modid, Map map) {
        for (Map.Entry pairs : map.entrySet()) {
            String name = (String)pairs.getKey();
            Object val = pairs.getValue();
            String comment = this.getComment(modid, name);
            ConfigEntryInfo info = new ConfigEntryInfo(this.lookupRegistryNameToConfig.get((Object)modid).configData.size(), name, val, comment);
            this.lookupRegistryNameToConfig.get((Object)modid).configData.add(info);
        }
    }

    public static void dbg(Object obj) {
        CULog.dbg("" + obj);
    }

    public void addConfigFile(String modID, IConfigCategory configCat) {
        this.addConfigFile(modID, configCat.getRegistryName(), configCat, true);
    }

    private void addConfigFile(String modID, String categoryName, IConfigCategory configCat, boolean liveEdit) {
        if (!this.fullyLoaded) {
            CULog.dbg("configmod - adding to queue: " + categoryName);
            this.deferredRegistryQueue.add(new ConfigAddQueue(modID, configCat));
            return;
        }
        CULog.dbg("configmod - registering config: " + categoryName);
        if (this.lookupRegistryNameToConfig.containsKey(configCat.getRegistryName())) {
            return;
        }
        ModConfigData configData = ConfigMod.instance().makeLoaderSpecificConfigData(configCat.getConfigFileName(), categoryName, configCat.getClass(), configCat);
        if (configData == null) {
            CULog.err("ERROR: makeLoaderSpecificConfigData not implemented for active loader");
            return;
        }
        this.configs.add(configData);
        if (liveEdit) {
            this.liveEditConfigs.add(configData);
        }
        this.lookupRegistryNameToConfig.put(categoryName, configData);
        this.lookupFilePathToConfig.put(configCat.getConfigFileName() + ".toml", configData);
        configData.initData();
        configData.writeConfigFile(false);
    }

    public Object getField(String configID, String name) {
        try {
            return OldUtil.getPrivateValue(this.lookupRegistryNameToConfig.get((Object)configID).configClass, instance, name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getComment(String configID, String name) {
        try {
            Field field = this.lookupRegistryNameToConfig.get((Object)configID).configClass.getDeclaredField(name);
            ConfigComment anno_comment = field.getAnnotation(ConfigComment.class);
            return anno_comment == null ? "" : anno_comment.value()[0];
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return "";
    }

    public boolean updateField(String configID, String name, Object obj) {
        return this.lookupRegistryNameToConfig.get(configID).setFieldBasedOnType(name, obj);
    }

    public void forceSaveAllFilesFromRuntimeSettings() {
        CULog.dbg("forceSaveAllFilesFromRuntimeSettings invoked");
        for (ModConfigData data : this.lookupRegistryNameToConfig.values()) {
            data.updateConfigFileWithRuntimeValues();
        }
        for (ModConfigData data : this.lookupRegistryNameToConfig.values()) {
            data.updateConfigFileWithRuntimeValues();
        }
    }

    public void forceLoadRuntimeSettingsFromFile() {
        CULog.dbg("forceLoadRuntimeSettingsFromFile invoked");
        for (ModConfigData data : this.lookupRegistryNameToConfig.values()) {
            data.writeConfigFile(false);
        }
    }
}

