/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.common.core.util;

import java.util.List;
import net.minecraft.class_243;

public class CoroUtilPhysics {
    public static boolean isInConvexShape(class_243 test, List<class_243> nodes) {
        boolean result = false;
        int i = 0;
        int j = nodes.size() - 1;
        while (i < nodes.size()) {
            class_243 vecI = nodes.get(i);
            class_243 vecJ = nodes.get(j);
            if (vecI.field_1350 > test.field_1350 != vecJ.field_1350 > test.field_1350 && test.field_1352 < (vecJ.field_1352 - vecI.field_1352) * (test.field_1350 - vecI.field_1350) / (vecJ.field_1350 - vecI.field_1350) + vecI.field_1352) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public static double getDistanceToShape(class_243 point, List<class_243> nodes) {
        float closestDist1 = 9999.0f;
        float closestDist2 = 9999.0f;
        class_243 closestPoint1 = null;
        class_243 closestPoint2 = null;
        for (int i = 0; i < 2; ++i) {
            for (class_243 pointTest : nodes) {
                double dist = pointTest.method_1022(point);
                if (dist < (double)closestDist1) {
                    closestDist1 = (float)dist;
                    closestPoint1 = pointTest;
                    continue;
                }
                if (!(dist < (double)closestDist2) || pointTest == closestPoint1) continue;
                closestDist2 = (float)dist;
                closestPoint2 = pointTest;
            }
        }
        if (closestPoint1 == null || closestPoint2 == null) {
            return -1.0;
        }
        return CoroUtilPhysics.distBetweenPointAndLine(point.field_1352, point.field_1350, closestPoint1.field_1352, closestPoint1.field_1350, closestPoint2.field_1352, closestPoint2.field_1350);
    }

    public static double distBetweenPointAndLine(double x, double y, double x1, double y1, double x2, double y2) {
        double AB = CoroUtilPhysics.distBetween(x, y, x1, y1);
        double BC = CoroUtilPhysics.distBetween(x1, y1, x2, y2);
        double AC = CoroUtilPhysics.distBetween(x, y, x2, y2);
        double s = (AB + BC + AC) / 2.0;
        double area = Math.sqrt(s * (s - AB) * (s - BC) * (s - AC));
        double AD = 2.0 * area / BC;
        return AD;
    }

    public static double distBetween(double x, double y, double x1, double y1) {
        double xx = x1 - x;
        double yy = y1 - y;
        return Math.sqrt(xx * xx + yy * yy);
    }
}

