/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.loading_utils;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;

public class ChildProcessLogger
extends Thread {
    private final InputStream is;
    private final Level logLevel;
    public ChildProcessLogger anotherChildProcessLogger;
    private static Process crashAssistantAppProcess;
    private static final String startedSuccessfullyMessage;
    private static final Logger LOGGER;

    public ChildProcessLogger(InputStream is, Level logLevel) {
        this.setDaemon(true);
        this.setName("CrashAssistantApp process logger");
        this.is = is;
        this.logLevel = logLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            reader = new BufferedReader(new InputStreamReader(this.is));
            ** try [egrp 1[TRYBLOCK] [4 : 19->91)] { 
lbl4:
            // 1 sources

            ** GOTO lbl-1000
lbl5:
            // 1 sources

            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            ChildProcessLogger.LOGGER.error("Error while reading CrashAssistantApp process stream:", (Throwable)e);
            return;
        }
        catch (InterruptedException var1_3) {
            // empty catch block
        }
        return;
lbl-1000:
        // 4 sources

        {
            while (Thread.currentThread().isInterrupted() == false) {
                var3_6 = ChildProcessLogger.class;
                // MONITORENTER : dev.kostromdan.mods.crash_assistant.loading_utils.ChildProcessLogger.class
                readerReady = reader.ready();
                if (!readerReady && !ChildProcessLogger.crashAssistantAppProcess.isAlive()) {
                    if (this.anotherChildProcessLogger.isInterrupted()) {
                        ChildProcessLogger.LOGGER.error("CrashAssistantApp failed to start with exit code " + ChildProcessLogger.crashAssistantAppProcess.exitValue() + ";  Stopping child process loggers.");
                        // MONITOREXIT : var3_6
                        return;
                    }
                    this.interrupt();
                    // MONITOREXIT : var3_6
                    return;
                }
                // MONITOREXIT : var3_6
                if (!readerReady) {
                    Thread.sleep(50L);
                    continue;
                }
                line = reader.readLine();
                if (line == null) {
                    return;
                }
                if (this.logLevel == Level.INFO) {
                    ChildProcessLogger.LOGGER.info(line);
                    if (!line.endsWith(ChildProcessLogger.startedSuccessfullyMessage)) continue;
                    ChildProcessLogger.LOGGER.info("CrashAssistantApp started successfully. Stopping child process loggers.");
                    this.anotherChildProcessLogger.interrupt();
                    return;
                }
                ChildProcessLogger.LOGGER.error(line);
            }
            return;
        }
    }

    public static void captureOutput(Process p) {
        ChildProcessLogger out;
        crashAssistantAppProcess = p;
        final ChildProcessLogger err = new ChildProcessLogger(p.getErrorStream(), Level.ERROR);
        err.anotherChildProcessLogger = out = new ChildProcessLogger(p.getInputStream(), Level.INFO);
        out.anotherChildProcessLogger = err;
        err.start();
        out.start();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                err.interrupt();
                out.interrupt();
            }
        }, 3000L);
    }

    static {
        startedSuccessfullyMessage = "CrashAssistantApp started successfully. Waiting for PID " + ProcessHandle.current().pid() + " to stop.";
        LOGGER = LogUtils.getLogger();
    }
}

