/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.loading_utils;

import dev.kostromdan.mods.crash_assistant.loading_utils.JarLocatingException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public interface LibrariesJarLocator {
    public static String getLibraryJarPath(Class cls) throws JarLocatingException, URISyntaxException {
        Path path;
        String pathString = cls.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        int jarIndex = pathString.lastIndexOf(".jar");
        if (jarIndex == -1) {
            throw new JarLocatingException("Not found '.jar' in IRI.getPath() of `" + String.valueOf(cls) + "'; path: " + pathString);
        }
        pathString = pathString.substring(0, jarIndex + 4);
        try {
            path = Paths.get(pathString, new String[0]);
        }
        catch (Exception e) {
            try {
                if (pathString.startsWith("/")) {
                    pathString = pathString.substring(1);
                }
                path = Paths.get(pathString, new String[0]);
            }
            catch (Exception e2) {
                throw new JarLocatingException("Failed converting pathString got from `" + String.valueOf(cls) + "' to Paths.get(pathString); pathString: `" + pathString + "`");
            }
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new JarLocatingException("Successfully parsed '.jar' path of `" + String.valueOf(cls) + "',but it does not exist; path: `" + String.valueOf(path) + "`; pathString: `" + pathString + "`");
        }
        return path.toAbsolutePath().toString();
    }
}

