/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.mod_list;

import dev.kostromdan.mods.crash_assistant.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.mod_list.ModListDiffStringBuilder;
import dev.kostromdan.mods.crash_assistant.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.mod_list.UpdatedPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ModListDiff {
    private final LinkedHashSet<Mod> addedMods;
    private final LinkedHashSet<Mod> removedMods;
    private final LinkedHashSet<UpdatedPair> updatedMods;

    public ModListDiff(LinkedHashSet<Mod> saved, LinkedHashSet<Mod> current) {
        this.addedMods = current.stream().filter(mod -> !saved.contains(mod)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.removedMods = saved.stream().filter(mod -> !current.contains(mod)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.updatedMods = new LinkedHashSet();
        HashMap<String, HashSet> modIdToMods = new HashMap<String, HashSet>();
        HashSet<Mod> tmpMods = new HashSet<Mod>();
        tmpMods.addAll(this.removedMods);
        tmpMods.addAll(this.addedMods);
        for (Mod mod2 : tmpMods) {
            if (mod2.getModId() == null) continue;
            modIdToMods.computeIfAbsent(mod2.getModId(), k -> new HashSet()).add(mod2);
        }
        for (Mod mod2 : (LinkedHashSet)this.removedMods.clone()) {
            if (mod2.getModId() == null) continue;
            HashSet modsWithSameModId = (HashSet)modIdToMods.get(mod2.getModId());
            modsWithSameModId.remove(mod2);
            for (Mod updatedMod : modsWithSameModId) {
                this.updatedMods.add(new UpdatedPair(mod2, updatedMod));
                this.addedMods.remove(updatedMod);
                this.removedMods.remove(mod2);
            }
        }
    }

    public LinkedHashSet<Mod> getAddedMods() {
        return this.addedMods;
    }

    public LinkedHashSet<Mod> getRemovedMods() {
        return this.removedMods;
    }

    public LinkedHashSet<UpdatedPair> getUpdatedMods() {
        return this.updatedMods;
    }

    public static ModListDiff getDiff() {
        return new ModListDiff(ModListUtils.getSavedModList(), ModListUtils.getCurrentModList());
    }

    public ModListDiffStringBuilder generateDiffMsg(boolean forMsg) {
        Function<String, String> langFunc = forMsg ? LanguageProvider::getMsgLang : LanguageProvider::get;
        ModListDiffStringBuilder sb = new ModListDiffStringBuilder();
        if (CrashAssistantConfig.getBoolean("modpack_modlist.enabled")) {
            ArrayList<String> modpackCreators = CrashAssistantConfig.getModpackCreators();
            if (modpackCreators.contains(ModListUtils.getCurrentUsername()) || modpackCreators.isEmpty()) {
                sb.append(langFunc.apply("msg.modlist_changes_latest_launch"));
                if (ModListUtils.getSavedModList().isEmpty() && CrashAssistantConfig.getBoolean("modpack_modlist.auto_update")) {
                    sb.append(langFunc.apply("msg.modlist_first_launch"), "blue");
                    return sb;
                }
            } else {
                sb.append(langFunc.apply("msg.modlist_changes_modpack"));
            }
            if (this.getAddedMods().isEmpty() && this.getRemovedMods().isEmpty()) {
                sb.append(langFunc.apply("msg.modlist_unmodified"), "blue");
            } else {
                if (!this.getAddedMods().isEmpty()) {
                    sb.append(langFunc.apply("msg.added_mods"));
                    for (Mod mod : this.getAddedMods()) {
                        sb.append(mod.getJarName(), "green");
                    }
                    sb.append("");
                }
                if (!this.getRemovedMods().isEmpty()) {
                    sb.append(langFunc.apply("msg.removed_mods"));
                    for (Mod mod : this.getRemovedMods()) {
                        sb.append(mod.getJarName(), "red");
                    }
                    sb.append("");
                }
                if (!this.getUpdatedMods().isEmpty()) {
                    sb.append(langFunc.apply("msg.updated_mods"));
                    for (UpdatedPair updatedPair : this.getUpdatedMods()) {
                        sb.append(updatedPair.getOldMod().getModId(), "blue", false);
                        sb.append(" (", false);
                        sb.append(updatedPair.getOldMod().getVersion(), "red", false);
                        sb.append(" > ", false);
                        sb.append(updatedPair.getNewMod().getVersion(), "green", false);
                        sb.append(")");
                        if (!Objects.equals(updatedPair.getOldMod().getVersion(), updatedPair.getNewMod().getVersion())) continue;
                        sb.append(updatedPair.getOldMod().getJarName(), "green", false);
                        sb.append(" > ", false);
                        sb.append(updatedPair.getNewMod().getJarName(), "red");
                    }
                }
            }
        }
        return sb;
    }
}

