/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.mod_list;

import dev.kostromdan.mods.crash_assistant.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.mod_list.ModDataParser;
import dev.kostromdan.mods.crash_assistant.mod_list.PathComparator;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModListUtils {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Path USERNAME_FILE = Paths.get("local", "crash_assistant", "username.info");
    private static final Path MODS_FOLDER = Paths.get("mods", new String[0]);
    private static final Path RESOURCEPACKS_FOLDER = Paths.get("resourcepacks", new String[0]);
    private static final Path JSON_FILE = Paths.get("config", "crash_assistant", "modlist.json");
    public static String currentUsername = "";

    public static LinkedHashSet<Mod> getCurrentModList() {
        try {
            LinkedHashSet<Mod> filenames = new LinkedHashSet<Mod>();
            if (Files.exists(MODS_FOLDER, new LinkOption[0])) {
                Files.list(MODS_FOLDER).sorted(new PathComparator()).forEach(path -> {
                    String filename = path.getFileName().toString();
                    if (Files.isRegularFile(path, new LinkOption[0]) && filename.endsWith(".jar")) {
                        filenames.add(ModDataParser.parseModData(path));
                    }
                });
            }
            if (Files.exists(RESOURCEPACKS_FOLDER, new LinkOption[0]) && CrashAssistantConfig.getBoolean("modpack_modlist.add_resourcepacks")) {
                Files.list(RESOURCEPACKS_FOLDER).sorted(new PathComparator()).forEach(path -> {
                    String filename = path.getFileName().toString();
                    if (Files.isDirectory(path, new LinkOption[0]) || filename.endsWith(".zip")) {
                        filenames.add(new Mod(filename + " (resourcepack)", null, null));
                    }
                });
            }
            return filenames;
        }
        catch (Exception e) {
            LOGGER.error("Error while getting current mod list: ", (Throwable)e);
            return new LinkedHashSet<Mod>();
        }
    }

    public static LinkedHashSet<Mod> getSavedModList() {
        try {
            if (Files.exists(JSON_FILE, new LinkOption[0])) {
                String json = new String(Files.readAllBytes(JSON_FILE));
                return (LinkedHashSet)Mod.GSON.fromJson(json, Mod.TYPE);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while getting Modlist", (Throwable)e);
        }
        return new LinkedHashSet<Mod>();
    }

    public static void saveCurrentModList() {
        try {
            try (FileWriter writer = new FileWriter(JSON_FILE.toFile());){
                String jsonOutput = Mod.GSON.toJson(ModListUtils.getCurrentModList(), Mod.TYPE);
                writer.write(jsonOutput);
            }
            LOGGER.info("Modlist saved to " + String.valueOf(JSON_FILE));
        }
        catch (Exception e) {
            LOGGER.error("Error while saving Modlist", (Throwable)e);
        }
    }

    public static String getCurrentUsername() {
        if (currentUsername.isEmpty() && Files.exists(USERNAME_FILE, new LinkOption[0])) {
            try {
                currentUsername = new String(Files.readAllBytes(USERNAME_FILE));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return currentUsername;
    }
}

