/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.platform;

import dev.kostromdan.mods.crash_assistant.config.CrashAssistantConfig;
import java.util.Objects;

public enum PlatformHelp {
    FORGE("https://discord.minecraftforge.net", "Minecraft Forge Discord", "#player-support channel"),
    NEOFORGE("https://discord.neoforged.net", "NeoForge Discord", "#user_support channel"),
    FABRIC("https://discord.gg/v6v4pMv", "Fabric Discord", "#player-support channel"),
    QUILT("https://discord.quiltmc.org/", "QuiltMC Discord", "#player-support channel"),
    UNKNOWN("https://discord.gg/moddedmc", "ModdedMC Discord", "#player-help channel");

    private final String helpLink;
    private final String helpName;
    private final String helpChannel;
    public static PlatformHelp platform;

    private PlatformHelp(String helpLink, String helpName, String helpChannel) {
        this.helpLink = helpLink;
        this.helpName = helpName;
        this.helpChannel = helpChannel;
    }

    public static boolean isLinkDefault() {
        return Objects.equals(CrashAssistantConfig.get("general.help_link"), "CHANGE_ME");
    }

    public static String getActualHelpLink() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("general.help_link");
        }
        return PlatformHelp.platform.helpLink;
    }

    public static String getActualHelpName() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("text.support_name");
        }
        return PlatformHelp.platform.helpName;
    }

    public static String getActualHelpChannel() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("text.support_place");
        }
        return PlatformHelp.platform.helpChannel;
    }

    static {
        platform = UNKNOWN;
    }
}

