/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.bell;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class AbstractBellBlockEntity
extends SmartBlockEntity {
    public static final int RING_DURATION = 74;
    public boolean isRinging;
    public int ringingTicks;
    public class_2350 ringDirection;

    public AbstractBellBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean ring(class_1937 world, class_2338 pos, class_2350 direction) {
        this.isRinging = true;
        this.ringingTicks = 0;
        this.ringDirection = direction;
        this.sendData();
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isRinging) {
            ++this.ringingTicks;
        }
        if (this.ringingTicks >= 74) {
            this.isRinging = false;
            this.ringingTicks = 0;
        }
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (!clientPacket || this.ringingTicks != 0 || !this.isRinging) {
            return;
        }
        NBTHelper.writeEnum(tag, "Ringing", this.ringDirection);
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (!clientPacket || !tag.method_10545("Ringing")) {
            return;
        }
        this.ringDirection = NBTHelper.readEnum(tag, "Ringing", class_2350.class);
        this.ringingTicks = 0;
        this.isRinging = true;
    }

    @Environment(value=EnvType.CLIENT)
    public abstract PartialModel getBellModel();
}

