/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids;

import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.StorageProvider;
import java.lang.ref.WeakReference;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public abstract class FlowSource {
    BlockFace location;

    public FlowSource(BlockFace location) {
        this.location = location;
    }

    public FluidStack provideFluid(Predicate<FluidStack> extractionPredicate) {
        Storage<FluidVariant> tank = this.provideHandler();
        if (tank == null) {
            return FluidStack.EMPTY;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            Predicate<FluidVariant> test = v -> extractionPredicate.test(new FluidStack(v, 1L));
            ResourceAmount resource = TransferUtil.extractMatching(tank, test, (long)1L, (TransactionContext)t);
            FluidStack fluidStack = resource == null ? FluidStack.EMPTY : new FluidStack((FluidVariant)resource.resource(), resource.amount());
            return fluidStack;
        }
    }

    public void keepAlive() {
    }

    public abstract boolean isEndpoint();

    public void manageSource(class_1937 world) {
    }

    public void whileFlowPresent(class_1937 world, boolean pulling) {
    }

    public Storage<FluidVariant> provideHandler() {
        return null;
    }

    public static class Blocked
    extends FlowSource {
        public Blocked(BlockFace location) {
            super(location);
        }

        @Override
        public boolean isEndpoint() {
            return false;
        }
    }

    public static class OtherPipe
    extends FlowSource {
        WeakReference<FluidTransportBehaviour> cached;

        public OtherPipe(BlockFace location) {
            super(location);
        }

        @Override
        public void manageSource(class_1937 world) {
            if (this.cached != null && this.cached.get() != null && !((FluidTransportBehaviour)this.cached.get()).blockEntity.method_11015()) {
                return;
            }
            this.cached = null;
            FluidTransportBehaviour fluidTransportBehaviour = BlockEntityBehaviour.get((class_1922)world, this.location.getConnectedPos(), FluidTransportBehaviour.TYPE);
            if (fluidTransportBehaviour != null) {
                this.cached = new WeakReference<FluidTransportBehaviour>(fluidTransportBehaviour);
            }
        }

        @Override
        public FluidStack provideFluid(Predicate<FluidStack> extractionPredicate) {
            if (this.cached == null || this.cached.get() == null) {
                return FluidStack.EMPTY;
            }
            FluidTransportBehaviour behaviour = (FluidTransportBehaviour)this.cached.get();
            FluidStack providedOutwardFluid = behaviour.getProvidedOutwardFluid(this.location.getOppositeFace());
            return extractionPredicate.test(providedOutwardFluid) ? providedOutwardFluid : FluidStack.EMPTY;
        }

        @Override
        public boolean isEndpoint() {
            return false;
        }
    }

    public static class FluidHandler
    extends FlowSource {
        StorageProvider<FluidVariant> provider = null;
        private class_1937 level = null;

        public FluidHandler(BlockFace location) {
            super(location);
        }

        @Override
        public void manageSource(class_1937 world) {
            if (world != this.level) {
                this.level = world;
                this.provider = StorageProvider.createForFluids((class_1937)world, (class_2338)this.location.getConnectedPos());
            }
        }

        @Override
        public Storage<FluidVariant> provideHandler() {
            return this.provider == null ? null : this.provider.get(this.location.getOppositeFace());
        }

        @Override
        public boolean isEndpoint() {
            return true;
        }
    }
}

