/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.potion;

import com.google.common.collect.Lists;
import com.simibubi.create.content.fluids.potion.PotionFluid;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;

public class PotionFluidHandler {
    public static Pair<FluidStack, class_1799> emptyPotion(class_1799 stack, boolean simulate) {
        FluidStack fluid = PotionFluidHandler.getFluidFromPotionItem(stack);
        if (!simulate) {
            stack.method_7934(1);
        }
        return Pair.of(fluid, new class_1799((class_1935)class_1802.field_8469));
    }

    public static FluidIngredient potionIngredient(class_1842 potion, long amount) {
        return FluidIngredient.fromFluidStack(FluidHelper.copyStackWithAmount(PotionFluidHandler.getFluidFromPotionItem(class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)potion)), amount));
    }

    public static FluidStack getFluidFromPotionItem(class_1799 stack) {
        class_1842 potion = class_1844.method_8063((class_1799)stack);
        List list = class_1844.method_8068((class_1799)stack);
        PotionFluid.BottleType bottleTypeFromItem = PotionFluidHandler.bottleTypeFromItem(stack.method_7909());
        if (potion == class_1847.field_8984) {
            return FluidStack.EMPTY;
        }
        if (potion == class_1847.field_8991 && list.isEmpty() && bottleTypeFromItem == PotionFluid.BottleType.REGULAR) {
            return new FluidStack((class_3611)class_3612.field_15910, 27000L);
        }
        FluidStack fluid = PotionFluid.withEffects(27000L, potion, list);
        class_2487 tagInfo = fluid.getTag();
        NBTHelper.writeEnum(tagInfo, "Bottle", bottleTypeFromItem);
        FluidVariant variant = FluidVariant.of((class_3611)fluid.getFluid(), (class_2487)tagInfo);
        return new FluidStack(variant, fluid.getAmount(), tagInfo);
    }

    public static FluidStack getFluidFromPotion(class_1842 potion, PotionFluid.BottleType bottleType, long amount) {
        if (potion == class_1847.field_8991 && bottleType == PotionFluid.BottleType.REGULAR) {
            return new FluidStack((class_3611)class_3612.field_15910, amount);
        }
        FluidStack fluid = PotionFluid.of(amount, potion);
        NBTHelper.writeEnum(fluid.getOrCreateTag(), "Bottle", bottleType);
        return new FluidStack(fluid.getFluid(), fluid.getAmount(), fluid.getTag());
    }

    public static PotionFluid.BottleType bottleTypeFromItem(class_1792 item) {
        if (item == class_1802.field_8150) {
            return PotionFluid.BottleType.LINGERING;
        }
        if (item == class_1802.field_8436) {
            return PotionFluid.BottleType.SPLASH;
        }
        return PotionFluid.BottleType.REGULAR;
    }

    public static class_1935 itemFromBottleType(PotionFluid.BottleType type) {
        switch (type) {
            case LINGERING: {
                return class_1802.field_8150;
            }
            case SPLASH: {
                return class_1802.field_8436;
            }
        }
        return class_1802.field_8574;
    }

    public static long getRequiredAmountForFilledBottle(class_1799 stack, FluidStack availableFluid) {
        return 27000L;
    }

    public static class_1799 fillBottle(class_1799 stack, FluidStack availableFluid) {
        class_2487 tag = availableFluid.getOrCreateTag();
        class_1799 potionStack = new class_1799(PotionFluidHandler.itemFromBottleType(NBTHelper.readEnum(tag, "Bottle", PotionFluid.BottleType.class)));
        class_1844.method_8061((class_1799)potionStack, (class_1842)class_1844.method_8057((class_2487)tag));
        class_1844.method_8056((class_1799)potionStack, (Collection)class_1844.method_8060((class_2487)tag));
        return potionStack;
    }

    @Environment(value=EnvType.CLIENT)
    public static void addPotionTooltip(FluidStack fs, List<class_2561> tooltip, float p_185182_2_) {
        PotionFluidHandler.addPotionTooltip(fs.getType(), tooltip, p_185182_2_);
    }

    @Environment(value=EnvType.CLIENT)
    public static void addPotionTooltip(FluidVariant fs, List<class_2561> tooltip, float p_185182_2_) {
        List list = class_1844.method_8066((class_2487)fs.getNbt());
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            tooltip.add((class_2561)Components.translatable("effect.none").method_27692(class_124.field_1080));
        } else {
            for (class_1293 effectinstance : list) {
                class_5250 textcomponent = Components.translatable(effectinstance.method_5586());
                class_1291 effect = effectinstance.method_5579();
                Map map = effect.method_5565();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        class_1322 attributemodifier = (class_1322)entry.getValue();
                        class_1322 attributemodifier1 = new class_1322(attributemodifier.method_6185(), effect.method_5563(effectinstance.method_5578(), attributemodifier), attributemodifier.method_6182());
                        list1.add(new class_3545((Object)((class_1320)entry.getKey()).method_26830(), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.method_5578() > 0) {
                    textcomponent.method_27693(" ").method_27693(Components.translatable("potion.potency." + effectinstance.method_5578()).getString());
                }
                if (effectinstance.method_5584() > 20) {
                    textcomponent.method_27693(" (").method_10852(class_1292.method_5577((class_1293)effectinstance, (float)p_185182_2_)).method_27693(")");
                }
                tooltip.add((class_2561)textcomponent.method_27692(effect.method_18792().method_18793()));
            }
        }
        if (!list1.isEmpty()) {
            tooltip.add(Components.immutableEmpty());
            tooltip.add((class_2561)Components.translatable("potion.whenDrank").method_27692(class_124.field_1064));
            for (class_3545 tuple : list1) {
                class_1322 attributemodifier2 = (class_1322)tuple.method_15441();
                double d0 = attributemodifier2.method_6186();
                double d1 = attributemodifier2.method_6182() != class_1322.class_1323.field_6330 && attributemodifier2.method_6182() != class_1322.class_1323.field_6331 ? attributemodifier2.method_6186() : attributemodifier2.method_6186() * 100.0;
                if (d0 > 0.0) {
                    tooltip.add((class_2561)Components.translatable("attribute.modifier.plus." + attributemodifier2.method_6182().method_6191(), class_1799.field_8029.format(d1), Components.translatable((String)tuple.method_15442())).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.add((class_2561)Components.translatable("attribute.modifier.take." + attributemodifier2.method_6182().method_6191(), class_1799.field_8029.format(d1 *= -1.0), Components.translatable((String)tuple.method_15442())).method_27692(class_124.field_1061));
            }
        }
    }
}

