/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.trains.track.TrackBlockEntityTilt;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackRenderer;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Iterator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class BezierConnection
implements Iterable<Segment> {
    public Couple<class_2338> tePositions;
    public Couple<class_243> starts;
    public Couple<class_243> axes;
    public Couple<class_243> normals;
    public Couple<Integer> smoothing;
    public boolean primary;
    public boolean hasGirder;
    protected TrackMaterial trackMaterial;
    class_243 finish1;
    class_243 finish2;
    private boolean resolved;
    private double length;
    private float[] stepLUT;
    private int segments;
    private double radius;
    private double handleLength;
    private class_238 bounds;
    private SegmentAngles[] bakedSegments;
    private GirderAngles[] bakedGirders;

    public BezierConnection(Couple<class_2338> positions, Couple<class_243> starts, Couple<class_243> axes, Couple<class_243> normals, boolean primary, boolean girder, TrackMaterial material) {
        this.tePositions = positions;
        this.starts = starts;
        this.axes = axes;
        this.normals = normals;
        this.primary = primary;
        this.hasGirder = girder;
        this.trackMaterial = material;
        this.resolved = false;
    }

    public BezierConnection secondary() {
        BezierConnection bezierConnection = new BezierConnection((Couple<class_2338>)this.tePositions.swap(), (Couple<class_243>)this.starts.swap(), (Couple<class_243>)this.axes.swap(), (Couple<class_243>)this.normals.swap(), !this.primary, this.hasGirder, this.trackMaterial);
        if (this.smoothing != null) {
            bezierConnection.smoothing = this.smoothing.swap();
        }
        return bezierConnection;
    }

    public BezierConnection clone() {
        return this.secondary().secondary();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean coupleEquals(Couple<?> a, Couple<?> b) {
        Object f;
        if (a.getFirst().equals(b.getFirst())) {
            if (a.getSecond().equals(b.getSecond())) return true;
        }
        if (!((f = a.getFirst()) instanceof class_243)) return false;
        class_243 aFirst = (class_243)f;
        Object s = a.getSecond();
        if (!(s instanceof class_243)) return false;
        class_243 aSecond = (class_243)s;
        Object f2 = b.getFirst();
        if (!(f2 instanceof class_243)) return false;
        class_243 bFirst = (class_243)f2;
        Object s2 = b.getSecond();
        if (!(s2 instanceof class_243)) return false;
        class_243 bSecond = (class_243)s2;
        if (!aFirst.method_24802((class_2374)bFirst, 1.0E-6)) return false;
        if (!aSecond.method_24802((class_2374)bSecond, 1.0E-6)) return false;
        return true;
    }

    public boolean equalsSansMaterial(BezierConnection other) {
        return this.equalsSansMaterialInner(other) || this.equalsSansMaterialInner(other.secondary());
    }

    private boolean equalsSansMaterialInner(BezierConnection other) {
        return this == other || other != null && BezierConnection.coupleEquals(this.tePositions, other.tePositions) && BezierConnection.coupleEquals(this.starts, other.starts) && BezierConnection.coupleEquals(this.axes, other.axes) && BezierConnection.coupleEquals(this.normals, other.normals) && this.hasGirder == other.hasGirder;
    }

    public BezierConnection(class_2487 compound, class_2338 localTo) {
        this(Couple.deserializeEach(compound.method_10554("Positions", 10), class_2512::method_10691).map(b -> b.method_10081((class_2382)localTo)), Couple.deserializeEach(compound.method_10554("Starts", 10), VecHelper::readNBTCompound).map(v -> v.method_1019(class_243.method_24954((class_2382)localTo))), Couple.deserializeEach(compound.method_10554("Axes", 10), VecHelper::readNBTCompound), Couple.deserializeEach(compound.method_10554("Normals", 10), VecHelper::readNBTCompound), compound.method_10577("Primary"), compound.method_10577("Girder"), TrackMaterial.deserialize(compound.method_10558("Material")));
        if (compound.method_10545("Smoothing")) {
            this.smoothing = Couple.deserializeEach(compound.method_10554("Smoothing", 10), NBTHelper::intFromCompound);
        }
    }

    public class_2487 write(class_2338 localTo) {
        Couple<class_2338> tePositions = this.tePositions.map(b -> b.method_10059((class_2382)localTo));
        Couple<class_243> starts = this.starts.map(v -> v.method_1020(class_243.method_24954((class_2382)localTo)));
        class_2487 compound = new class_2487();
        compound.method_10556("Girder", this.hasGirder);
        compound.method_10556("Primary", this.primary);
        compound.method_10566("Positions", (class_2520)tePositions.serializeEach(class_2512::method_10692));
        compound.method_10566("Starts", (class_2520)starts.serializeEach(VecHelper::writeNBTCompound));
        compound.method_10566("Axes", (class_2520)this.axes.serializeEach(VecHelper::writeNBTCompound));
        compound.method_10566("Normals", (class_2520)this.normals.serializeEach(VecHelper::writeNBTCompound));
        compound.method_10582("Material", this.getMaterial().id.toString());
        if (this.smoothing != null) {
            compound.method_10566("Smoothing", (class_2520)this.smoothing.serializeEach(NBTHelper::intToCompound));
        }
        return compound;
    }

    public BezierConnection(class_2540 buffer) {
        this(Couple.create(() -> ((class_2540)buffer).method_10811()), Couple.create(() -> VecHelper.read(buffer)), Couple.create(() -> VecHelper.read(buffer)), Couple.create(() -> VecHelper.read(buffer)), buffer.readBoolean(), buffer.readBoolean(), TrackMaterial.deserialize(buffer.method_19772()));
        if (buffer.readBoolean()) {
            this.smoothing = Couple.create(() -> ((class_2540)buffer).method_10816());
        }
    }

    public void write(class_2540 buffer) {
        this.tePositions.forEach(arg_0 -> ((class_2540)buffer).method_10807(arg_0));
        this.starts.forEach(v -> VecHelper.write(v, buffer));
        this.axes.forEach(v -> VecHelper.write(v, buffer));
        this.normals.forEach(v -> VecHelper.write(v, buffer));
        buffer.writeBoolean(this.primary);
        buffer.writeBoolean(this.hasGirder);
        buffer.method_10814(this.getMaterial().id.toString());
        buffer.writeBoolean(this.smoothing != null);
        if (this.smoothing != null) {
            this.smoothing.forEach(arg_0 -> ((class_2540)buffer).method_10804(arg_0));
        }
    }

    public class_2338 getKey() {
        return (class_2338)this.tePositions.getSecond();
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public int yOffsetAt(class_243 end) {
        if (this.smoothing == null) {
            return 0;
        }
        if (TrackBlockEntityTilt.compareHandles((class_243)this.starts.getFirst(), end)) {
            return (Integer)this.smoothing.getFirst();
        }
        if (TrackBlockEntityTilt.compareHandles((class_243)this.starts.getSecond(), end)) {
            return (Integer)this.smoothing.getSecond();
        }
        return 0;
    }

    public double getLength() {
        this.resolve();
        return this.length;
    }

    public float[] getStepLUT() {
        this.resolve();
        return this.stepLUT;
    }

    public int getSegmentCount() {
        this.resolve();
        return this.segments;
    }

    public class_243 getPosition(double t) {
        this.resolve();
        return VecHelper.bezier((class_243)this.starts.getFirst(), (class_243)this.starts.getSecond(), this.finish1, this.finish2, (float)t);
    }

    public double getRadius() {
        this.resolve();
        return this.radius;
    }

    public double getHandleLength() {
        this.resolve();
        return this.handleLength;
    }

    public float getSegmentT(int index) {
        return index == this.segments ? 1.0f : (float)index * this.stepLUT[index] / (float)this.segments;
    }

    public double incrementT(double currentT, double distance) {
        this.resolve();
        double dx = VecHelper.bezierDerivative((class_243)this.starts.getFirst(), (class_243)this.starts.getSecond(), this.finish1, this.finish2, (float)currentT).method_1033() / this.getLength();
        return currentT + distance / dx;
    }

    public class_238 getBounds() {
        this.resolve();
        return this.bounds;
    }

    public class_243 getNormal(double t) {
        this.resolve();
        class_243 end1 = (class_243)this.starts.getFirst();
        class_243 end2 = (class_243)this.starts.getSecond();
        class_243 fn1 = (class_243)this.normals.getFirst();
        class_243 fn2 = (class_243)this.normals.getSecond();
        class_243 derivative = VecHelper.bezierDerivative(end1, end2, this.finish1, this.finish2, (float)t).method_1029();
        class_243 faceNormal = fn1.equals((Object)fn2) ? fn1 : VecHelper.slerp((float)t, fn1, fn2);
        class_243 normal = faceNormal.method_1036(derivative).method_1029();
        return derivative.method_1036(normal);
    }

    private void resolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        class_243 end1 = (class_243)this.starts.getFirst();
        class_243 end2 = (class_243)this.starts.getSecond();
        class_243 axis1 = ((class_243)this.axes.getFirst()).method_1029();
        class_243 axis2 = ((class_243)this.axes.getSecond()).method_1029();
        this.determineHandles(end1, end2, axis1, axis2);
        this.finish1 = axis1.method_1021(this.handleLength).method_1019(end1);
        this.finish2 = axis2.method_1021(this.handleLength).method_1019(end2);
        int scanCount = 16;
        this.length = 0.0;
        class_243 previous = end1;
        for (int i = 0; i <= scanCount; ++i) {
            float t = (float)i / (float)scanCount;
            class_243 result = VecHelper.bezier(end1, end2, this.finish1, this.finish2, t);
            if (previous != null) {
                this.length += result.method_1022(previous);
            }
            previous = result;
        }
        this.segments = (int)(this.length * 2.0);
        this.stepLUT = new float[this.segments + 1];
        this.stepLUT[0] = 1.0f;
        float combinedDistance = 0.0f;
        this.bounds = new class_238(end1, end2);
        class_243 previous2 = end1;
        for (int i = 0; i <= this.segments; ++i) {
            float t = (float)i / (float)this.segments;
            class_243 result = VecHelper.bezier(end1, end2, this.finish1, this.finish2, t);
            this.bounds = this.bounds.method_991(new class_238(result, result));
            if (i > 0) {
                combinedDistance = (float)((double)combinedDistance + result.method_1022(previous2) / this.length);
                this.stepLUT[i] = t / combinedDistance;
            }
            previous2 = result;
        }
        this.bounds = this.bounds.method_1014(1.375);
    }

    private void determineHandles(class_243 end1, class_243 end2, class_243 axis1, class_243 axis2) {
        class_243 cross1 = axis1.method_1036(new class_243(0.0, 1.0, 0.0));
        class_243 cross2 = axis2.method_1036(new class_243(0.0, 1.0, 0.0));
        this.radius = 0.0;
        double a1 = class_3532.method_15349((double)(-axis2.field_1350), (double)(-axis2.field_1352));
        double a2 = class_3532.method_15349((double)axis1.field_1350, (double)axis1.field_1352);
        double angle = a1 - a2;
        float circle = (float)Math.PI * 2;
        if (Math.abs((double)circle - (angle = (angle + (double)circle) % (double)circle)) < Math.abs(angle)) {
            angle = (double)circle - angle;
        }
        if (class_3532.method_20390((double)angle, (double)0.0)) {
            double[] intersect = VecHelper.intersect(end1, end2, axis1, cross2, class_2350.class_2351.field_11052);
            if (intersect != null) {
                double t = Math.abs(intersect[0]);
                double u = Math.abs(intersect[1]);
                double min = Math.min(t, u);
                double max = Math.max(t, u);
                if (min > 1.2 && max / min > 1.0 && max / min < 3.0) {
                    this.handleLength = max - min;
                    return;
                }
            }
            this.handleLength = end2.method_1022(end1) / 3.0;
            return;
        }
        double n = (double)circle / angle;
        double factor = 1.3333333333333333 * Math.tan(Math.PI / (2.0 * n));
        double[] intersect = VecHelper.intersect(end1, end2, cross1, cross2, class_2350.class_2351.field_11052);
        if (intersect == null) {
            this.handleLength = end2.method_1022(end1) / 3.0;
            return;
        }
        this.radius = Math.abs(intersect[1]);
        this.handleLength = this.radius * factor;
        if (class_3532.method_20390((double)this.handleLength, (double)0.0)) {
            this.handleLength = 1.0;
        }
    }

    @Override
    public Iterator<Segment> iterator() {
        this.resolve();
        class_243 offset = class_243.method_24954((class_2382)((class_2382)this.tePositions.getFirst())).method_1021(-1.0).method_1031(0.0, 0.1875, 0.0);
        return new Bezierator(this, offset);
    }

    public void addItemsToPlayer(class_1657 player) {
        class_1661 inv = player.method_31548();
        for (int tracks = this.getTrackItemCost(); tracks > 0; tracks -= 64) {
            inv.method_7398(new class_1799((class_1935)this.getMaterial().getBlock(), Math.min(64, tracks)));
        }
        for (int girders = this.getGirderItemCost(); girders > 0; girders -= 64) {
            inv.method_7398(AllBlocks.METAL_GIRDER.asStack(Math.min(64, girders)));
        }
    }

    public int getGirderItemCost() {
        return this.hasGirder ? this.getTrackItemCost() * 2 : 0;
    }

    public int getTrackItemCost() {
        return (this.getSegmentCount() + 1) / 2;
    }

    public void spawnItems(class_1937 level) {
        if (!level.method_8450().method_8355(class_1928.field_19392)) {
            return;
        }
        class_243 origin = class_243.method_24954((class_2382)((class_2382)this.tePositions.getFirst()));
        for (Segment segment : this) {
            if (segment.index % 2 != 0 || segment.index == this.getSegmentCount()) continue;
            class_243 v = VecHelper.offsetRandomly(segment.position, level.field_9229, 0.125f).method_1019(origin);
            class_1542 entity = new class_1542(level, v.field_1352, v.field_1351, v.field_1350, this.getMaterial().asStack());
            entity.method_6988();
            level.method_8649((class_1297)entity);
            if (!this.hasGirder) continue;
            for (int i = 0; i < 2; ++i) {
                entity = new class_1542(level, v.field_1352, v.field_1351, v.field_1350, AllBlocks.METAL_GIRDER.asStack());
                entity.method_6988();
                level.method_8649((class_1297)entity);
            }
        }
    }

    public void spawnDestroyParticles(class_1937 level) {
        class_2388 data = new class_2388(class_2398.field_11217, this.getMaterial().getBlock().method_9564());
        class_2388 girderData = new class_2388(class_2398.field_11217, AllBlocks.METAL_GIRDER.getDefaultState());
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 slevel = (class_3218)level;
        class_243 origin = class_243.method_24954((class_2382)((class_2382)this.tePositions.getFirst()));
        for (Segment segment : this) {
            for (int offset : Iterate.positiveAndNegative) {
                class_243 v = segment.position.method_1019(segment.normal.method_1021((double)(0.875f * (float)offset))).method_1019(origin);
                slevel.method_14199((class_2394)data, v.field_1352, v.field_1351, v.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                if (!this.hasGirder) continue;
                slevel.method_14199((class_2394)girderData, v.field_1352, v.field_1351 - 0.5, v.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public TrackMaterial getMaterial() {
        return this.trackMaterial;
    }

    public void setMaterial(TrackMaterial material) {
        this.trackMaterial = material;
    }

    @Environment(value=EnvType.CLIENT)
    public SegmentAngles[] getBakedSegments() {
        if (this.bakedSegments != null) {
            return this.bakedSegments;
        }
        int segmentCount = this.getSegmentCount();
        this.bakedSegments = new SegmentAngles[segmentCount + 1];
        Couple<class_243> previousOffsets = null;
        for (Segment segment : this) {
            int i = segment.index;
            boolean end = i == 0 || i == segmentCount;
            SegmentAngles angles = this.bakedSegments[i] = new SegmentAngles();
            Couple<class_243> railOffsets = Couple.create(segment.position.method_1019(segment.normal.method_1021((double)0.965f)), segment.position.method_1020(segment.normal.method_1021((double)0.965f)));
            class_243 railMiddle = ((class_243)railOffsets.getFirst()).method_1019((class_243)railOffsets.getSecond()).method_1021(0.5);
            if (previousOffsets == null) {
                previousOffsets = railOffsets;
                continue;
            }
            class_243 prevMiddle = ((class_243)previousOffsets.getFirst()).method_1019((class_243)previousOffsets.getSecond()).method_1021(0.5);
            class_243 tieAngles = TrackRenderer.getModelAngles(segment.normal, railMiddle.method_1020(prevMiddle));
            angles.lightPosition = class_2338.method_49638((class_2374)railMiddle);
            angles.railTransforms = Couple.create(null, null);
            class_4587 poseStack = new class_4587();
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)poseStack).translate(prevMiddle)).rotateYRadians(tieAngles.field_1351)).rotateXRadians(tieAngles.field_1352)).rotateZRadians(tieAngles.field_1350)).translate(-0.5, -0.12890625, 0.0);
            angles.tieTransform = poseStack.method_23760();
            float scale = end ? 2.2f : 2.1f;
            for (boolean first : Iterate.trueAndFalse) {
                class_243 railI = railOffsets.get(first);
                class_243 prevI = previousOffsets.get(first);
                class_243 diff = railI.method_1020(prevI);
                class_243 anglesI = TrackRenderer.getModelAngles(segment.normal, diff);
                poseStack = new class_4587();
                ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)poseStack).translate(prevI)).rotateYRadians(anglesI.field_1351)).rotateXRadians(anglesI.field_1352)).rotateZRadians(anglesI.field_1350)).translate(0.0, -0.12890625, -0.03125)).scale(1.0f, 1.0f, (float)diff.method_1033() * scale);
                angles.railTransforms.set(first, poseStack.method_23760());
            }
            previousOffsets = railOffsets;
        }
        return this.bakedSegments;
    }

    @Environment(value=EnvType.CLIENT)
    public GirderAngles[] getBakedGirders() {
        if (this.bakedGirders != null) {
            return this.bakedGirders;
        }
        int segmentCount = this.getSegmentCount();
        this.bakedGirders = new GirderAngles[segmentCount + 1];
        Couple<Couple<class_243>> previousOffsets = null;
        for (Segment segment : this) {
            int i = segment.index;
            boolean end = i == 0 || i == segmentCount;
            GirderAngles angles = this.bakedGirders[i] = new GirderAngles();
            class_243 leftGirder = segment.position.method_1019(segment.normal.method_1021((double)0.965f));
            class_243 rightGirder = segment.position.method_1020(segment.normal.method_1021((double)0.965f));
            class_243 upNormal = segment.derivative.method_1029().method_1036(segment.normal);
            class_243 firstGirderOffset = upNormal.method_1021(-0.5);
            class_243 secondGirderOffset = upNormal.method_1021(-0.625);
            class_243 leftTop = segment.position.method_1019(segment.normal.method_1021(1.0)).method_1019(firstGirderOffset);
            class_243 rightTop = segment.position.method_1020(segment.normal.method_1021(1.0)).method_1019(firstGirderOffset);
            class_243 leftBottom = leftTop.method_1019(secondGirderOffset);
            class_243 rightBottom = rightTop.method_1019(secondGirderOffset);
            angles.lightPosition = class_2338.method_49638((class_2374)leftGirder.method_1019(rightGirder).method_1021(0.5));
            Couple<Couple<class_243>> offsets = Couple.create(Couple.create(leftTop, rightTop), Couple.create(leftBottom, rightBottom));
            if (previousOffsets == null) {
                previousOffsets = offsets;
                continue;
            }
            angles.beams = Couple.create(null, null);
            angles.beamCaps = Couple.create(Couple.create(null, null), Couple.create(null, null));
            float scale = end ? 2.3f : 2.2f;
            for (boolean first : Iterate.trueAndFalse) {
                class_243 currentBeam = ((class_243)((Couple)offsets.getFirst()).get(first)).method_1019((class_243)((Couple)offsets.getSecond()).get(first)).method_1021(0.5);
                class_243 previousBeam = ((class_243)((Couple)previousOffsets.getFirst()).get(first)).method_1019((class_243)((Couple)previousOffsets.getSecond()).get(first)).method_1021(0.5);
                class_243 beamDiff = currentBeam.method_1020(previousBeam);
                class_243 beamAngles = TrackRenderer.getModelAngles(segment.normal, beamDiff);
                class_4587 poseStack = new class_4587();
                ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)poseStack).translate(previousBeam)).rotateYRadians(beamAngles.field_1351)).rotateXRadians(beamAngles.field_1352)).rotateZRadians(beamAngles.field_1350)).translate(0.0, (double)(0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f), -0.03125)).scale(1.0f, 1.0f, (float)beamDiff.method_1033() * scale);
                angles.beams.set(first, poseStack.method_23760());
                for (boolean top : Iterate.trueAndFalse) {
                    class_243 current = offsets.get(top).get(first);
                    class_243 previous = previousOffsets.get(top).get(first);
                    class_243 diff = current.method_1020(previous);
                    class_243 capAngles = TrackRenderer.getModelAngles(segment.normal, diff);
                    poseStack = new class_4587();
                    ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)poseStack).translate(previous)).rotateYRadians(capAngles.field_1351)).rotateXRadians(capAngles.field_1352)).rotateZRadians(capAngles.field_1350)).translate(0.0, (double)(0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f), -0.03125)).rotateZ(top ? 0.0 : 0.0)).scale(1.0f, 1.0f, (float)diff.method_1033() * scale);
                    angles.beamCaps.get(top).set(first, poseStack.method_23760());
                }
            }
            previousOffsets = offsets;
        }
        return this.bakedGirders;
    }

    private static class Bezierator
    implements Iterator<Segment> {
        private final BezierConnection bc;
        private final Segment segment;
        private final class_243 end1;
        private final class_243 end2;
        private final class_243 finish1;
        private final class_243 finish2;
        private final class_243 faceNormal1;
        private final class_243 faceNormal2;

        private Bezierator(BezierConnection bc, class_243 offset) {
            bc.resolve();
            this.bc = bc;
            this.end1 = ((class_243)bc.starts.getFirst()).method_1019(offset);
            this.end2 = ((class_243)bc.starts.getSecond()).method_1019(offset);
            this.finish1 = ((class_243)bc.axes.getFirst()).method_1021(bc.handleLength).method_1019(this.end1);
            this.finish2 = ((class_243)bc.axes.getSecond()).method_1021(bc.handleLength).method_1019(this.end2);
            this.faceNormal1 = (class_243)bc.normals.getFirst();
            this.faceNormal2 = (class_243)bc.normals.getSecond();
            this.segment = new Segment();
            this.segment.index = -1;
        }

        @Override
        public boolean hasNext() {
            return this.segment.index + 1 <= this.bc.segments;
        }

        @Override
        public Segment next() {
            ++this.segment.index;
            float t = this.bc.getSegmentT(this.segment.index);
            this.segment.position = VecHelper.bezier(this.end1, this.end2, this.finish1, this.finish2, t);
            this.segment.derivative = VecHelper.bezierDerivative(this.end1, this.end2, this.finish1, this.finish2, t).method_1029();
            this.segment.faceNormal = this.faceNormal1.equals((Object)this.faceNormal2) ? this.faceNormal1 : VecHelper.slerp(t, this.faceNormal1, this.faceNormal2);
            this.segment.normal = this.segment.faceNormal.method_1036(this.segment.derivative).method_1029();
            return this.segment;
        }
    }

    public static class Segment {
        public int index;
        public class_243 position;
        public class_243 derivative;
        public class_243 faceNormal;
        public class_243 normal;
    }

    @Environment(value=EnvType.CLIENT)
    public static class SegmentAngles {
        public class_4587.class_4665 tieTransform;
        public Couple<class_4587.class_4665> railTransforms;
        public class_2338 lightPosition;
    }

    @Environment(value=EnvType.CLIENT)
    public static class GirderAngles {
        public Couple<class_4587.class_4665> beams;
        public Couple<Couple<class_4587.class_4665>> beamCaps;
        public class_2338 lightPosition;
    }
}

