/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.graph.EdgeData;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.CurvedTrackSelectionPacket;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import java.util.List;
import java.util.function.BiConsumer;
import me.pepperbell.simplenetworking.C2SPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableObject;

public class TrackTargetingBlockItem
extends class_1747 {
    private EdgePointType<?> type;

    public static <T extends class_2248> NonNullBiFunction<? super T, class_1792.class_1793, TrackTargetingBlockItem> ofType(EdgePointType<?> type) {
        return (b, p) -> new TrackTargetingBlockItem((class_2248)b, (class_1792.class_1793)p, type);
    }

    public TrackTargetingBlockItem(class_2248 pBlock, class_1792.class_1793 pProperties, EdgePointType<?> type) {
        super(pBlock, pProperties);
        this.type = type;
    }

    public class_1269 method_7884(class_1838 pContext) {
        class_1799 stack = pContext.method_8041();
        class_2338 pos = pContext.method_8037();
        class_1937 level = pContext.method_8045();
        class_2680 state = level.method_8320(pos);
        class_1657 player = pContext.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        if (player.method_5715() && stack.method_7985()) {
            if (level.field_9236) {
                return class_1269.field_5812;
            }
            player.method_7353((class_2561)Lang.translateDirect("track_target.clear", new Object[0]), true);
            stack.method_7980(null);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (class_2382)pos, 1.0f, 0.5f);
            return class_1269.field_5812;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ITrackBlock) {
            ITrackBlock track = (ITrackBlock)class_22482;
            if (level.field_9236) {
                return class_1269.field_5812;
            }
            class_243 lookAngle = player.method_5720();
            boolean front = track.getNearestTrackAxis((class_1922)level, pos, state, lookAngle).getSecond() == class_2350.class_2352.field_11056;
            EdgePointType<?> type = this.getType(stack);
            MutableObject result = new MutableObject(null);
            TrackTargetingBlockItem.withGraphLocation(level, pos, front, null, type, (overlap, location) -> result.setValue((Object)overlap));
            if (((OverlapResult)((Object)result.getValue())).feedback != null) {
                player.method_7353((class_2561)Lang.translateDirect(((OverlapResult)((Object)result.getValue())).feedback, new Object[0]).method_27692(class_124.field_1061), true);
                AllSoundEvents.DENY.play(level, null, (class_2382)pos, 0.5f, 1.0f);
                return class_1269.field_5814;
            }
            class_2487 stackTag = stack.method_7948();
            stackTag.method_10566("SelectedPos", (class_2520)class_2512.method_10692((class_2338)pos));
            stackTag.method_10556("SelectedDirection", front);
            stackTag.method_10551("Bezier");
            player.method_7353((class_2561)Lang.translateDirect("track_target.set", new Object[0]), true);
            stack.method_7980(stackTag);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (class_2382)pos, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (!stack.method_7985()) {
            player.method_7353((class_2561)Lang.translateDirect("track_target.missing", new Object[0]).method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        class_2487 tag = stack.method_7969();
        class_2487 teTag = new class_2487();
        teTag.method_10556("TargetDirection", tag.method_10577("SelectedDirection"));
        class_2338 selectedPos = class_2512.method_10691((class_2487)tag.method_10562("SelectedPos"));
        class_2338 placedPos = pos.method_10079(pContext.method_8038(), state.method_45474() ? 0 : 1);
        boolean bezier = tag.method_10545("Bezier");
        if (!selectedPos.method_19771((class_2382)placedPos, bezier ? 80.0 : 16.0)) {
            player.method_7353((class_2561)Lang.translateDirect("track_target.too_far", new Object[0]).method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        if (bezier) {
            teTag.method_10566("Bezier", (class_2520)tag.method_10562("Bezier"));
        }
        teTag.method_10566("TargetTrack", (class_2520)class_2512.method_10692((class_2338)selectedPos.method_10059((class_2382)placedPos)));
        tag.method_10566("BlockEntityTag", (class_2520)teTag);
        class_1269 useOn = super.method_7884(pContext);
        if (level.field_9236 || useOn == class_1269.field_5814) {
            return useOn;
        }
        class_1799 itemInHand = player.method_5998(pContext.method_20287());
        if (!itemInHand.method_7960()) {
            itemInHand.method_7980(null);
        }
        player.method_7353((class_2561)Lang.translateDirect("track_target.success", new Object[0]).method_27692(class_124.field_1060), true);
        if (this.type == EdgePointType.SIGNAL) {
            AllAdvancements.SIGNAL.awardTo(player);
        }
        return useOn;
    }

    public EdgePointType<?> getType(class_1799 stack) {
        return this.type;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, class_1799 stack) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        TrackBlockEntity be = selection.blockEntity();
        BezierTrackPointLocation loc = selection.loc();
        boolean front = player.method_5720().method_1026(selection.direction()) < 0.0;
        AllPackets.getChannel().sendToServer((C2SPacket)new CurvedTrackSelectionPacket(be.method_11016(), loc.curveTarget(), loc.segment(), front, player.method_31548().field_7545));
        return true;
    }

    public static void withGraphLocation(class_1937 level, class_2338 pos, boolean front, BezierTrackPointLocation targetBezier, EdgePointType<?> type, BiConsumer<OverlapResult, TrackGraphLocation> callback) {
        TrackGraphLocation location;
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            callback.accept(OverlapResult.NO_TRACK, null);
            return;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        List<class_243> trackAxes = track.getTrackAxes((class_1922)level, pos, state);
        if (targetBezier == null && trackAxes.size() > 1) {
            callback.accept(OverlapResult.JUNCTION, null);
            return;
        }
        class_2350.class_2352 targetDirection = front ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
        TrackGraphLocation trackGraphLocation = location = targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, targetDirection, targetBezier) : TrackGraphHelper.getGraphLocationAt(level, pos, targetDirection, trackAxes.get(0));
        if (location == null) {
            callback.accept(OverlapResult.NO_TRACK, null);
            return;
        }
        Couple<TrackNode> nodes = location.edge.map(location.graph::locateNode);
        TrackEdge edge = location.graph.getConnection(nodes);
        if (edge == null) {
            return;
        }
        EdgeData edgeData = edge.getEdgeData();
        double edgePosition = location.position;
        for (TrackEdgePoint edgePoint : edgeData.getPoints()) {
            double otherEdgePosition = edgePoint.getLocationOn(edge);
            double distance = Math.abs(edgePosition - otherEdgePosition);
            if (distance > 0.75 || edgePoint.canCoexistWith(type, front) && distance < 0.25) continue;
            callback.accept(OverlapResult.OCCUPIED, location);
            return;
        }
        callback.accept(OverlapResult.VALID, location);
    }

    public static enum OverlapResult {
        VALID,
        OCCUPIED("track_target.occupied"),
        JUNCTION("track_target.no_junctions"),
        NO_TRACK("track_target.invalid");

        public String feedback;

        private OverlapResult() {
        }

        private OverlapResult(String feedback) {
            this.feedback = feedback;
        }
    }
}

