/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.scrollValue;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3965;

public class ScrollValueBehaviour
extends BlockEntityBehaviour
implements ValueSettingsBehaviour {
    public static final BehaviourType<ScrollValueBehaviour> TYPE = new BehaviourType();
    ValueBoxTransform slotPositioning;
    class_243 textShift;
    int min = 0;
    protected int max = 1;
    public int value;
    public class_2561 label;
    Consumer<Integer> callback;
    Consumer<Integer> clientCallback;
    Function<Integer, String> formatter;
    private Supplier<Boolean> isActive;
    boolean needsWrench;

    public ScrollValueBehaviour(class_2561 label, SmartBlockEntity be, ValueBoxTransform slot) {
        super(be);
        this.setLabel(label);
        this.slotPositioning = slot;
        this.callback = i -> {};
        this.clientCallback = i -> {};
        this.formatter = i -> Integer.toString(i);
        this.value = 0;
        this.isActive = () -> true;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        nbt.method_10569("ScrollValue", this.value);
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        this.value = nbt.method_10550("ScrollValue");
        super.read(nbt, clientPacket);
    }

    public ScrollValueBehaviour withClientCallback(Consumer<Integer> valueCallback) {
        this.clientCallback = valueCallback;
        return this;
    }

    public ScrollValueBehaviour withCallback(Consumer<Integer> valueCallback) {
        this.callback = valueCallback;
        return this;
    }

    public ScrollValueBehaviour between(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollValueBehaviour requiresWrench() {
        this.needsWrench = true;
        return this;
    }

    public ScrollValueBehaviour withFormatter(Function<Integer, String> formatter) {
        this.formatter = formatter;
        return this;
    }

    public ScrollValueBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public void setValue(int value) {
        if ((value = class_3532.method_15340((int)value, (int)this.min, (int)this.max)) == this.value) {
            return;
        }
        this.value = value;
        this.callback.accept(value);
        this.blockEntity.method_5431();
        this.blockEntity.sendData();
    }

    public int getValue() {
        return this.value;
    }

    public String formatValue() {
        return this.formatter.apply(this.value);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Override
    public boolean isActive() {
        return this.isActive.get();
    }

    @Override
    public boolean testHit(class_243 hit) {
        class_2680 state = this.blockEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954((class_2382)this.blockEntity.method_11016()));
        return this.slotPositioning.testHit(state, localHit);
    }

    public void setLabel(class_2561 label) {
        this.label = label;
    }

    @Override
    public ValueBoxTransform getSlotPositioning() {
        return this.slotPositioning;
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        return new ValueSettingsBoard(this.label, this.max, 10, (List<class_2561>)ImmutableList.of((Object)Components.literal("Value")), new ValueSettingsFormatter(ValueSettingsBehaviour.ValueSettings::format));
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlDown) {
        if (valueSetting.equals(this.getValueSettings())) {
            return;
        }
        this.setValue(valueSetting.value());
        this.playFeedbackSound(this);
    }

    @Override
    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(0, this.value);
    }

    @Override
    public boolean onlyVisibleWithWrench() {
        return this.needsWrench;
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side) {
        if (player instanceof FakePlayer) {
            this.blockEntity.method_11010().method_26174(this.getWorld(), player, hand, new class_3965(VecHelper.getCenterOf((class_2382)this.getPos()), side, this.getPos(), true));
        }
    }

    public static class StepContext {
        public int currentValue;
        public boolean forward;
        public boolean shift;
        public boolean control;
    }
}

