/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class MechanicalCraftingRecipeBuilder {
    private final class_1792 result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private boolean acceptMirrored;
    private List<ConditionJsonProvider> recipeConditions;

    public MechanicalCraftingRecipeBuilder(class_1935 p_i48261_1_, int p_i48261_2_) {
        this.result = p_i48261_1_.method_8389();
        this.count = p_i48261_2_;
        this.acceptMirrored = true;
        this.recipeConditions = new ArrayList<ConditionJsonProvider>();
    }

    public static MechanicalCraftingRecipeBuilder shapedRecipe(class_1935 p_200470_0_) {
        return MechanicalCraftingRecipeBuilder.shapedRecipe(p_200470_0_, 1);
    }

    public static MechanicalCraftingRecipeBuilder shapedRecipe(class_1935 p_200468_0_, int p_200468_1_) {
        return new MechanicalCraftingRecipeBuilder(p_200468_0_, p_200468_1_);
    }

    public MechanicalCraftingRecipeBuilder key(Character p_200469_1_, class_6862<class_1792> p_200469_2_) {
        return this.key(p_200469_1_, class_1856.method_8106(p_200469_2_));
    }

    public MechanicalCraftingRecipeBuilder key(Character p_200462_1_, class_1935 p_200462_2_) {
        return this.key(p_200462_1_, class_1856.method_8091((class_1935[])new class_1935[]{p_200462_2_}));
    }

    public MechanicalCraftingRecipeBuilder key(Character p_200471_1_, class_1856 p_200471_2_) {
        if (this.key.containsKey(p_200471_1_)) {
            throw new IllegalArgumentException("Symbol '" + p_200471_1_ + "' is already defined!");
        }
        if (p_200471_1_.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(p_200471_1_, p_200471_2_);
        return this;
    }

    public MechanicalCraftingRecipeBuilder patternLine(String p_200472_1_) {
        if (!this.pattern.isEmpty() && p_200472_1_.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(p_200472_1_);
        return this;
    }

    public MechanicalCraftingRecipeBuilder disallowMirrored() {
        this.acceptMirrored = false;
        return this;
    }

    public void build(Consumer<class_2444> p_200464_1_) {
        this.build(p_200464_1_, RegisteredObjects.getKeyOrThrow(this.result));
    }

    public void build(Consumer<class_2444> p_200466_1_, String p_200466_2_) {
        class_2960 resourcelocation = RegisteredObjects.getKeyOrThrow(this.result);
        if (new class_2960(p_200466_2_).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + p_200466_2_ + " should remove its 'save' argument");
        }
        this.build(p_200466_1_, new class_2960(p_200466_2_));
    }

    public void build(Consumer<class_2444> p_200467_1_, class_2960 p_200467_2_) {
        this.validate(p_200467_2_);
        p_200467_1_.accept(new Result(p_200467_2_, this.result, this.count, this.pattern, this.key, this.acceptMirrored, this.recipeConditions));
    }

    private void validate(class_2960 p_200463_1_) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + p_200463_1_ + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + p_200463_1_ + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + p_200463_1_);
        }
    }

    public MechanicalCraftingRecipeBuilder whenModLoaded(String modid) {
        return this.withCondition(DefaultResourceConditions.allModsLoaded((String[])new String[]{modid}));
    }

    public MechanicalCraftingRecipeBuilder whenModMissing(String modid) {
        return this.withCondition(DefaultResourceConditions.not((ConditionJsonProvider)DefaultResourceConditions.allModsLoaded((String[])new String[]{modid})));
    }

    public MechanicalCraftingRecipeBuilder withCondition(ConditionJsonProvider condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    public class Result
    implements class_2444 {
        private final class_2960 id;
        private final class_1792 result;
        private final int count;
        private final List<String> pattern;
        private final Map<Character, class_1856> key;
        private final boolean acceptMirrored;
        private List<ConditionJsonProvider> recipeConditions;

        public Result(class_2960 p_i48271_2_, class_1792 p_i48271_3_, int p_i48271_4_, List<String> p_i48271_6_, Map<Character, class_1856> p_i48271_7_, boolean asymmetrical, List<ConditionJsonProvider> recipeConditions) {
            this.id = p_i48271_2_;
            this.result = p_i48271_3_;
            this.count = p_i48271_4_;
            this.pattern = p_i48271_6_;
            this.key = p_i48271_7_;
            this.acceptMirrored = asymmetrical;
            this.recipeConditions = recipeConditions;
        }

        public void method_10416(JsonObject p_218610_1_) {
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            p_218610_1_.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            p_218610_1_.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", RegisteredObjects.getKeyOrThrow(this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            p_218610_1_.add("result", (JsonElement)jsonObject);
            p_218610_1_.addProperty("acceptMirrored", Boolean.valueOf(this.acceptMirrored));
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray jsonArray = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)c.toJson()));
            p_218610_1_.add("conditions", (JsonElement)jsonArray);
        }

        public class_1865<?> method_17800() {
            return AllRecipeTypes.MECHANICAL_CRAFTING.getSerializer();
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

