/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockEntity;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_5250;

public class ModularAccumulatorDisplaySource
extends PercentOrProgressBarDisplaySource {
    protected class_5250 formatNumeric(DisplayLinkContext context, Float currentLevel) {
        int mode = this.getMode(context);
        if (mode == 1) {
            return super.formatNumeric(context, currentLevel);
        }
        return Util.getTextComponent(Math.round(currentLevel.floatValue()), "fe");
    }

    private int getMode(DisplayLinkContext context) {
        return context.sourceConfig().method_10550("Mode");
    }

    protected Float getProgress(DisplayLinkContext context) {
        class_2586 class_25862 = context.getSourceBlockEntity();
        if (!(class_25862 instanceof ModularAccumulatorBlockEntity)) {
            return null;
        }
        ModularAccumulatorBlockEntity te = (ModularAccumulatorBlockEntity)class_25862;
        te = te.getControllerBE();
        if (te == null) {
            return null;
        }
        float capacity = te.energyStorage.getCapacity();
        float stored = te.energyStorage.getAmount();
        if (capacity == 0.0f) {
            return Float.valueOf(0.0f);
        }
        return switch (this.getMode(context)) {
            case 0, 1 -> Float.valueOf(stored / capacity);
            case 2 -> Float.valueOf(stored);
            case 3 -> Float.valueOf(capacity);
            case 4 -> Float.valueOf(capacity - stored);
            default -> Float.valueOf(0.0f);
        };
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }

    protected boolean progressBarActive(DisplayLinkContext context) {
        return this.getMode(context) == 0;
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 120, (si, l) -> si.forOptions(List.of(class_2561.method_43471((String)"createaddition.display_source.accumulator.progress_bar"), class_2561.method_43471((String)"createaddition.display_source.accumulator.percent"), class_2561.method_43471((String)"createaddition.display_source.accumulator.current"), class_2561.method_43471((String)"createaddition.display_source.accumulator.max"), class_2561.method_43471((String)"createaddition.display_source.accumulator.remaining"))).titled(class_2561.method_43471((String)"createaddition.display_source.accumulator.display")), "Mode");
    }

    protected String getTranslationKey() {
        return "modular_accumulator";
    }
}

