/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.portable_energy_interface;

import com.mrh0.createaddition.config.Config;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionSuccessCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class PortableEnergyManager {
    private static final Map<UUID, EnergyStorageHolder> CONTRAPTIONS = new ConcurrentHashMap<UUID, EnergyStorageHolder>();
    private static int tick = 0;

    public static void tick() {
        CONTRAPTIONS.keySet().iterator().forEachRemaining(contraption -> {
            if (System.currentTimeMillis() - PortableEnergyManager.CONTRAPTIONS.get((Object)contraption).heartbeat > 5000L) {
                CONTRAPTIONS.remove(contraption);
            }
        });
    }

    public static void track(MovementContext context) {
        Contraption contraption = context.contraption;
        EnergyStorageHolder holder = CONTRAPTIONS.get(contraption.entity.method_5667());
        if (holder == null) {
            holder = new EnergyStorageHolder();
            CONTRAPTIONS.put(contraption.entity.method_5667(), holder);
        }
        holder.addEnergySource(context.blockEntityData, context.localPos);
    }

    public static void untrack(MovementContext context) {
        EnergyStorageHolder holder = CONTRAPTIONS.remove(context.contraption.entity.method_5667());
        if (holder == null) {
            return;
        }
        holder.removed = true;
    }

    @Nullable
    public static EnergyStorage get(Contraption contraption) {
        if (contraption.entity == null) {
            return null;
        }
        return CONTRAPTIONS.get(contraption.entity.method_5667());
    }

    public static class EnergyStorageHolder
    extends SnapshotParticipant<Long>
    implements EnergyStorage {
        private long energy = 0L;
        private long capacity = 0L;
        private long heartbeat;
        private boolean removed = false;
        private final long maxReceive = (Long)Config.ACCUMULATOR_MAX_INPUT.get();
        private final long maxExtract = (Long)Config.ACCUMULATOR_MAX_OUTPUT.get();
        private final Map<class_2338, EnergyData> energyHolders = new HashMap<class_2338, EnergyData>();

        public EnergyStorageHolder() {
            this.heartbeat = System.currentTimeMillis();
        }

        protected void addEnergySource(class_2487 nbt, class_2338 pos) {
            this.heartbeat = System.currentTimeMillis();
            if (!nbt.method_10545("EnergyContent")) {
                return;
            }
            if (this.energyHolders.containsKey(pos)) {
                return;
            }
            EnergyData data = new EnergyData(nbt);
            this.energy += data.energy;
            this.capacity += data.capacity;
            this.energyHolders.put(pos, data);
        }

        protected Long createSnapshot() {
            return this.energy;
        }

        protected void readSnapshot(Long snapshot) {
            this.energy = snapshot;
        }

        public long insert(long maxReceive, TransactionContext ctx) {
            if (!this.supportsInsertion()) {
                return 0L;
            }
            long energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            this.updateSnapshots(ctx);
            this.energy += energyReceived;
            TransactionSuccessCallback.onSuccess((TransactionContext)ctx, () -> {
                long energyLeft = energyReceived;
                for (EnergyData data : this.energyHolders.values()) {
                    if ((energyLeft -= data.receiveEnergy(energyLeft)) <= 0L) break;
                }
                if (energyLeft > 0L) {
                    throw new IllegalStateException("Failed to store energy.");
                }
            });
            return energyReceived;
        }

        public long extract(long maxExtract, TransactionContext ctx) {
            if (!this.supportsExtraction()) {
                return 0L;
            }
            long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
            this.updateSnapshots(ctx);
            this.energy -= energyExtracted;
            TransactionSuccessCallback.onSuccess((TransactionContext)ctx, () -> {
                long energyLeft = energyExtracted;
                for (EnergyData data : this.energyHolders.values()) {
                    if ((energyLeft -= data.extractEnergy(energyLeft)) <= 0L) break;
                }
                if (energyLeft > 0L) {
                    throw new IllegalStateException("Failed to store energy.");
                }
            });
            return energyExtracted;
        }

        public long getAmount() {
            return this.energy;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public boolean supportsExtraction() {
            return !this.removed;
        }

        public boolean supportsInsertion() {
            return !this.removed;
        }
    }

    public static class EnergyData {
        private final class_2487 nbt;
        private final long capacity;
        private long energy;

        public EnergyData(class_2487 nbt) {
            class_2487 energyContent = (class_2487)nbt.method_10580("EnergyContent");
            if (energyContent == null) {
                throw new IllegalArgumentException("EnergyContent is null");
            }
            this.nbt = nbt;
            this.capacity = nbt.method_10537("EnergyCapacity");
            this.energy = energyContent.method_10537("energy");
        }

        public long receiveEnergy(long energy) {
            long energyReceived = Math.min(this.capacity - this.energy, energy);
            if (energyReceived == 0L) {
                return 0L;
            }
            this.energy += energyReceived;
            class_2487 energyContent = (class_2487)this.nbt.method_10580("EnergyContent");
            energyContent.method_10544("energy", this.energy);
            return energyReceived;
        }

        public long extractEnergy(long energy) {
            long energyRemoved = Math.min(this.energy, energy);
            if (energyRemoved == 0L) {
                return 0L;
            }
            this.energy -= energyRemoved;
            class_2487 energyContent = (class_2487)this.nbt.method_10580("EnergyContent");
            energyContent.method_10544("energy", this.energy);
            return energyRemoved;
        }
    }
}

