/*
 * Decompiled with CFR 0.152.
 */
package elocindev.deathknights.mixin.entity.effect_logic;

import elocindev.deathknights.config.Configs;
import elocindev.deathknights.config.entries.spells.blood.MarrowrendConfig;
import elocindev.deathknights.registry.SpellRegistry;
import elocindev.deathknights.util.EffectUtils;
import elocindev.necronomicon.api.ResourceIdentifier;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class}, priority=1000)
public abstract class LivingEffectModifiersMixin {
    @Shadow
    protected float field_6253;
    @Shadow
    private long field_6226;

    @Shadow
    public abstract float method_6063();

    @Shadow
    @Nullable
    public abstract class_1309 method_6065();

    @Shadow
    public abstract float method_6032();

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Inject(method={"damage"}, at={@At(value="RETURN")}, cancellable=true)
    protected void death_knights(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1293 effectInstance;
        class_1309 entity = (class_1309)this;
        class_1309 attacker = entity.method_6065();
        MarrowrendConfig CONFIG = Configs.Spells.Blood.MARROWREND;
        if (attacker == null) {
            return;
        }
        class_2960 effectId = ResourceIdentifier.get((String)CONFIG.effect_to_apply);
        class_1291 effect = (class_1291)class_7923.field_41174.method_10223(effectId);
        if (effect == null) {
            effect = class_1294.field_5907;
        }
        if (attacker.method_6059(effect) && (effectInstance = attacker.method_6112(effect)) != null) {
            int currentAmplifier = effectInstance.method_5578();
            float chance = CONFIG.stack_reduction_chance;
            if (attacker.method_37908().method_8409().method_43057() < chance) {
                if (currentAmplifier > 0) {
                    attacker.method_6092(new class_1293(effect, CONFIG.effect_duration, currentAmplifier - 1));
                } else {
                    attacker.method_6016(effect);
                }
            }
        }
    }

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="RETURN")}, cancellable=true)
    protected void death_knights$modifyAppliedDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        class_1309 entity = (class_1309)this;
        class_1309 attacker = entity.method_6065();
        float newAmount = amount;
        if (attacker == null) {
            return;
        }
        if (EffectUtils.hasStatusEffect(attacker, SpellRegistry.ATROCIOUS_PLAGUE)) {
            newAmount = amount * (1.0f - 0.1f * (float)(EffectUtils.getStatusEffect(attacker, SpellRegistry.ATROCIOUS_PLAGUE).method_5578() + 1));
        }
        if (EffectUtils.hasStatusEffect(attacker, SpellRegistry.ENRAGED)) {
            newAmount *= 1.0f - 0.2f * (float)(EffectUtils.getStatusEffect(attacker, SpellRegistry.ENRAGED).method_5578() + 1);
        }
        cir.setReturnValue((Object)Float.valueOf(newAmount));
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), argsOnly=true)
    private float death_knights$modifyHealAmount(float amount) {
        class_1309 entity = (class_1309)this;
        if (EffectUtils.hasStatusEffect(entity, SpellRegistry.GREVIOUS_PLAGUE)) {
            amount *= 1.0f - 0.1f * (float)(EffectUtils.getStatusEffect(entity, SpellRegistry.GREVIOUS_PLAGUE).method_5578() + 1);
        }
        return amount;
    }
}

