/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.render.feature;

import com.google.common.collect.Maps;
import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.api.DoApiAPI;
import de.cristelknight.doapi.api.DoApiPlugin;
import de.cristelknight.doapi.common.item.CustomHatItem;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3882;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import net.minecraft.class_918;

public class CustomHatFeatureRenderer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    public Map<class_1792, class_583<T>> MODELS = Maps.newHashMap();
    private final class_5599 modelLoader;
    private final float yOffset;

    public CustomHatFeatureRenderer(class_3883<T, M> context, class_5599 modelSet) {
        this(context, modelSet, 0.0f);
    }

    public CustomHatFeatureRenderer(class_3883<T, M> context, class_5599 modelLoader, float yOffset) {
        super(context);
        this.yOffset = yOffset;
        this.modelLoader = modelLoader;
    }

    public class_583<T> getHatModel(T entity, class_1304 slot) {
        CustomHatItem hatItem = this.getHatItem(entity, slot);
        if (hatItem != null) {
            if (this.MODELS.isEmpty()) {
                List<DoApiAPI> apis = Util.getApis(DoApiAPI.class, "doapi", DoApiPlugin.class);
                for (DoApiAPI api : apis) {
                    api.registerHat(this.MODELS, this.modelLoader);
                }
            }
            return this.MODELS.get((Object)hatItem);
        }
        return null;
    }

    public CustomHatItem getHatItem(T entity, class_1304 slot) {
        class_1799 headSlot = entity.method_6118(slot);
        class_1792 class_17922 = headSlot.method_7909();
        if (class_17922 instanceof CustomHatItem) {
            CustomHatItem hat = (CustomHatItem)class_17922;
            if (!headSlot.method_7960()) {
                return hat;
            }
        }
        return null;
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_1304[] slots;
        for (class_1304 slot : slots = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166}) {
            class_1792 class_17922;
            class_583<T> headModel = this.getHatModel(entity, slot);
            class_1799 headSlot = entity.method_6118(slot);
            if (headModel == null || !((class_17922 = headSlot.method_7909()) instanceof CustomHatItem)) continue;
            CustomHatItem armorItem = (CustomHatItem)class_17922;
            matrices.method_22903();
            this.setupHat(matrices, slot, armorItem.getOffset().floatValue());
            class_4588 vertexConsumer = class_918.method_27952((class_4597)vertexConsumers, (class_1921)class_1921.method_25448((class_2960)this.getTexture(entity, slot)), (boolean)false, (boolean)headSlot.method_7958());
            headModel.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            matrices.method_22909();
        }
    }

    public void setupHat(class_4587 matrices, class_1304 slot, float extraYOffset) {
        if (slot.equals((Object)class_1304.field_6169)) {
            ((class_3882)this.method_17165()).method_2838().method_22703(matrices);
        }
        matrices.method_22905(1.0f, 1.0f, 1.0f);
        matrices.method_46416(0.0f, this.yOffset + extraYOffset, 0.0f);
    }

    protected class_2960 getTexture(T entity, class_1304 slot) {
        CustomHatItem customItem = this.getHatItem(entity, slot);
        if (customItem != null) {
            return customItem.getTexture();
        }
        return super.method_23194(entity);
    }
}

