/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.configs;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.configs.CritMode;
import net.mehvahdjukaar.moonlight.api.client.util.ColorUtil;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8110;

public class ClientConfigs {
    public static final ConfigSpec SPEC;
    public static final Supplier<Double> ANIMATION_INTENSITY;
    public static final Supplier<Boolean> SHOW_HEARTHS;
    public static final Supplier<SkinType> SKIN;
    public static final Supplier<Boolean> DAMAGE_NUMBERS;
    public static final Supplier<Boolean> LIT_UP_PARTICLES;
    public static final Supplier<CritMode> CRIT_MODE;
    public static final Supplier<Map<IdOrTagPredicate, Integer>> DAMAGE_TO_COLORS;
    private static final int COLOR_GENERIC = 0xFFFFFF;
    private static final int COLOR_CRIT = 0xFF0000;
    private static final int COLOR_DRAGON = 15073535;
    private static final int COLOR_WITHER = 0x666666;
    private static final int COLOR_EXPLOSION = 16759593;
    private static final int COLOR_IND_MAGIC = 8670439;
    private static final int COLOR_WATER = 1612003;
    private static final int COLOR_FREEZING = 643839;
    private static final int COLOR_TRIDENT = 65437;
    private static final int COLOR_FIRE = 0xFF7700;
    private static final int COLOR_LIGHTNING = 0xFFF200;
    private static final int COLOR_CACTUS = 1024521;
    private static final int COLOR_TRUE = 9502776;
    private static final int COLOR_WARDEN = 476496;
    private static final int COLOR_BLEED = 8456714;

    public static void init() {
    }

    public static int getDamageColor(class_2960 damageTypeId) {
        Map<IdOrTagPredicate, Integer> values = DAMAGE_TO_COLORS.get();
        Optional opt = Utils.hackyGetRegistry((class_5321)class_7924.field_42534).method_40264(class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)damageTypeId));
        if (opt.isEmpty()) {
            Dummmmmmy.LOGGER.error("Received invalid damage type: " + damageTypeId);
        } else {
            class_6880.class_6883 holder = (class_6880.class_6883)opt.get();
            for (Map.Entry<IdOrTagPredicate, Integer> e : values.entrySet()) {
                if (!e.getKey().test(holder)) continue;
                return e.getValue();
            }
        }
        return -1;
    }

    static {
        ConfigBuilder builder = ConfigBuilder.create((class_2960)Dummmmmmy.res("client"), (ConfigType)ConfigType.CLIENT);
        builder.comment("lots of cosmetic stuff in here");
        builder.push("visuals").comment("To edit the damage numbers color you'll have to edit the config file manually");
        ANIMATION_INTENSITY = builder.comment("How much the dummy swings in degrees with respect to the damage dealt. default=0.75").define("animation_intensity", 0.75, 0.0, 2.0);
        SHOW_HEARTHS = builder.comment("Show hearths instead of damage dealt? (1 hearth = two damage)").define("show_hearths", false);
        DAMAGE_NUMBERS = builder.comment("Show damage numbers on entity").define("damage_numbers", true);
        LIT_UP_PARTICLES = builder.comment("Display particles fullbright").define("full_bright_damage_numbers", true);
        CRIT_MODE = PlatHelper.getPlatform().isForge() ? builder.comment("How crits should be shown").define("crit_mode", (Enum)CritMode.COLOR_AND_MULTIPLIER) : () -> CritMode.OFF;
        SKIN = builder.comment("Skin used by the dummy").define("texture", (Enum)SkinType.DEFAULT);
        HashMap<Record, Integer> map = new HashMap<Record, Integer>();
        map.put(new IdPredicate(Dummmmmmy.TRUE_DAMAGE), 9502776);
        map.put(new IdPredicate(Dummmmmmy.CRITICAL_DAMAGE), 0xFF0000);
        map.put(new IdPredicate("generic"), 0xFFFFFF);
        map.put(new IdPredicate("trident"), 65437);
        map.put(new IdPredicate("dragon_breath"), 15073535);
        map.put(new IdPredicate("sonic_boom"), 476496);
        map.put(new IdPredicate("attributeslib:bleeding"), 8456714);
        map.put(new TagPredicate(Dummmmmmy.IS_EXPLOSION), 16759593);
        map.put(new TagPredicate(Dummmmmmy.IS_COLD), 643839);
        map.put(new TagPredicate(Dummmmmmy.IS_THORN), 1024521);
        map.put(new TagPredicate(Dummmmmmy.IS_FIRE), 0xFF7700);
        map.put(new TagPredicate(Dummmmmmy.IS_WITHER), 0x666666);
        map.put(new TagPredicate((class_6862<class_8110>)class_8103.field_42253), 0xFFF200);
        map.put(new TagPredicate((class_6862<class_8110>)class_8103.field_42251), 1612003);
        map.put(new TagPredicate((class_6862<class_8110>)class_8103.field_42248), 8670439);
        DAMAGE_TO_COLORS = builder.comment("Add here custom colors (in hex format) to associate with your damage types. This is a map from damage source ID to a color where you can add new entries for each").defineObject("damage_type_colors", () -> map, (Codec)Codec.unboundedMap(IdOrTagPredicate.CODEC, (Codec)ColorUtil.CODEC));
        builder.pop();
        SPEC = builder.buildAndRegister();
    }

    public static interface IdOrTagPredicate
    extends Predicate<class_6880<class_8110>> {
        public static final Codec<IdOrTagPredicate> CODEC = Codec.STRING.comapFlatMap(IdOrTagPredicate::read, IdOrTagPredicate::toString).stable();

        public String toString();

        public static DataResult<IdOrTagPredicate> read(String location) {
            if (location.startsWith("#")) {
                return class_2960.method_29186((String)location.substring(1)).map(TagPredicate::new);
            }
            return class_2960.method_29186((String)location).map(IdPredicate::new);
        }
    }

    public static enum SkinType {
        DEFAULT("dummy", "dummy_h"),
        ORIGINAL("dummy_1", "dummy_1"),
        DUNGEONS("dummy_3", "dummy_3_h"),
        ALTERNATIVE("dummy_2", "dummy_2_h");

        private final class_2960 texture;
        private final class_2960 shearedTexture;

        private SkinType(String name, String shearedName) {
            this.texture = new class_2960("dummmmmmy:textures/entity/" + name + ".png");
            this.shearedTexture = new class_2960("dummmmmmy:textures/entity/" + shearedName + ".png");
        }

        public class_2960 getSkin(Boolean sheared) {
            return sheared != false ? this.shearedTexture : this.texture;
        }
    }

    record IdPredicate(class_2960 resourceLocation) implements IdOrTagPredicate
    {
        public IdPredicate(String name) {
            this(new class_2960(name));
        }

        @Override
        public String toString() {
            return this.resourceLocation.toString();
        }

        @Override
        public boolean test(class_6880<class_8110> id) {
            return ((class_5321)id.method_40230().get()).method_29177().equals((Object)this.resourceLocation);
        }
    }

    record TagPredicate(class_6862<class_8110> tag) implements IdOrTagPredicate
    {
        public TagPredicate(class_2960 resourceLocation) {
            this((class_6862<class_8110>)new class_6862(class_7924.field_42534, resourceLocation));
        }

        @Override
        public String toString() {
            return "#" + this.tag.comp_327();
        }

        @Override
        public boolean test(class_6880<class_8110> holder) {
            return holder.method_40220(this.tag);
        }
    }
}

