/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.input;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.input.EmiInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;

public class EmiBind {
    public static final int MAX_BINDS = 4;
    public final String translationKey;
    public final List<ModifiedKey> defaultKeys;
    public List<ModifiedKey> boundKeys;

    public EmiBind(String translationKey, int code) {
        this(translationKey, 0, code);
    }

    public EmiBind(String translationKey, int modifiers, int code) {
        this(translationKey, ModifiedKey.of(code, modifiers));
    }

    public EmiBind(String translationKey, ModifiedKey ... defaultKeys) {
        this.translationKey = translationKey;
        this.defaultKeys = Arrays.asList(defaultKeys);
        this.boundKeys = this.defaultKeys.stream().collect(Collectors.toCollection(ArrayList::new));
        this.updateBinds();
    }

    public void updateBinds() {
        if (this.boundKeys.size() == 0) {
            this.boundKeys.add(new ModifiedKey(class_3675.field_16237, 0));
        }
        for (int i = 0; i < this.boundKeys.size() - 1; ++i) {
            if (!this.boundKeys.get(i).isUnbound()) continue;
            this.boundKeys.remove(i);
            --i;
        }
        if (!this.boundKeys.get(this.boundKeys.size() - 1).isUnbound() && this.boundKeys.size() < 4) {
            this.boundKeys.add(new ModifiedKey(class_3675.field_16237, 0));
        }
    }

    public boolean isBound() {
        return this.boundKeys.size() > 0 && !this.boundKeys.get(0).isUnbound();
    }

    public class_2561 getBindText() {
        if (!this.isBound()) {
            return EmiPort.literal("[]", class_124.field_1065);
        }
        ModifiedKey bind = this.boundKeys.get(0);
        for (ModifiedKey key : this.boundKeys) {
            if (key.key.method_1442() != class_3675.class_307.field_1672) continue;
            bind = key;
            break;
        }
        return EmiPort.literal("[", class_124.field_1065).method_10852((class_2561)bind.getKeyText(class_124.field_1065)).method_10852((class_2561)EmiPort.literal("]", class_124.field_1065));
    }

    public void setToDefault() {
        this.boundKeys = this.defaultKeys.stream().collect(Collectors.toCollection(ArrayList::new));
        this.updateBinds();
    }

    public void setBinds(ModifiedKey ... keys) {
        this.boundKeys = Stream.of(keys).collect(Collectors.toCollection(ArrayList::new));
        this.updateBinds();
    }

    public void setBind(int offset, ModifiedKey key) {
        if (offset < this.boundKeys.size() && offset >= 0) {
            this.boundKeys.set(offset, key);
        }
        this.updateBinds();
    }

    public boolean isHeld() {
        for (ModifiedKey boundKey : this.boundKeys) {
            if (EmiInput.getCurrentModifiers() != boundKey.modifiersToMatch() || boundKey.key.method_1442() != class_3675.class_307.field_1668 || boundKey.key.method_1444() == -1 || !class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)boundKey.key.method_1444())) continue;
            return true;
        }
        return false;
    }

    public boolean matchesKey(int keyCode, int scanCode) {
        for (ModifiedKey boundKey : this.boundKeys) {
            if (EmiInput.getCurrentModifiers() != boundKey.modifiersToMatch() || !(keyCode == class_3675.field_16237.method_1444() ? boundKey.key.method_1442() == class_3675.class_307.field_1671 && boundKey.key.method_1444() == scanCode : boundKey.key.method_1442() == class_3675.class_307.field_1668 && boundKey.key.method_1444() == keyCode)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesMouse(int code) {
        for (ModifiedKey boundKey : this.boundKeys) {
            if (EmiInput.getCurrentModifiers() != boundKey.modifiersToMatch() || boundKey.key.method_1442() != class_3675.class_307.field_1672 || boundKey.key.method_1444() != code) continue;
            return true;
        }
        return false;
    }

    public void setKey(List<String> keys) {
        ArrayList modifiedKeys = Lists.newArrayList();
        for (String string : keys) {
            String[] parts = string.split(" ");
            class_3675.class_306 key = class_3675.field_16237;
            int modifiers = 0;
            if (parts.length > 0) {
                key = class_3675.method_15981((String)parts[parts.length - 1]);
                for (int i = 0; i < parts.length - 1; ++i) {
                    if (parts[i].equals("ctrl") || parts[i].equals("control")) {
                        modifiers |= 1;
                        continue;
                    }
                    if (parts[i].equals("alt")) {
                        modifiers |= 2;
                        continue;
                    }
                    if (!parts[i].equals("shift")) continue;
                    modifiers |= 4;
                }
            }
            modifiedKeys.add(new ModifiedKey(key, modifiers));
        }
        this.boundKeys = modifiedKeys;
        this.updateBinds();
    }

    public record ModifiedKey(class_3675.class_306 key, int modifiers) {
        public static ModifiedKey of(int code, int modifiers) {
            return new ModifiedKey(class_3675.class_307.field_1668.method_1447(code), modifiers);
        }

        public String toName() {
            Object name = "";
            if ((this.modifiers & 1) > 0) {
                name = (String)name + "ctrl ";
            }
            if ((this.modifiers & 2) > 0) {
                name = (String)name + "alt ";
            }
            if ((this.modifiers & 4) > 0) {
                name = (String)name + "shift ";
            }
            name = (String)name + this.key.method_1441();
            return name;
        }

        public int modifiersToMatch() {
            int modifiers = this.modifiers;
            if (this.key.method_1442() == class_3675.class_307.field_1668) {
                modifiers ^= EmiInput.maskFromCode(this.key.method_1444());
            }
            return modifiers;
        }

        public boolean isUnbound() {
            return this.key == class_3675.field_16237;
        }

        public class_5250 getKeyText(class_124 formatting) {
            class_5250 text = EmiPort.literal("", formatting);
            this.appendModifiers(text, this.modifiers());
            EmiPort.append(text, this.key().method_27445());
            return text;
        }

        private void appendModifiers(class_5250 text, int modifiers) {
            if ((modifiers & 1) > 0) {
                EmiPort.append(text, (class_2561)EmiPort.translatable("key.keyboard.control"));
                EmiPort.append(text, (class_2561)EmiPort.literal(" + "));
            }
            if ((modifiers & 2) > 0) {
                EmiPort.append(text, (class_2561)EmiPort.translatable("key.keyboard.alt"));
                EmiPort.append(text, (class_2561)EmiPort.literal(" + "));
            }
            if ((modifiers & 4) > 0) {
                EmiPort.append(text, (class_2561)EmiPort.translatable("key.keyboard.shift"));
                EmiPort.append(text, (class_2561)EmiPort.literal(" + "));
            }
        }
    }
}

