/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot;

import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.server.condition.BlownUpByCreeperLootCondition;
import fzzyhmstrs.emi_loot.server.condition.KilledByWitherLootCondition;
import fzzyhmstrs.emi_loot.server.condition.MobSpawnedWithLootCondition;
import fzzyhmstrs.emi_loot.server.function.OminousBannerLootFunction;
import fzzyhmstrs.emi_loot.server.function.SetAnyDamageLootFunction;
import fzzyhmstrs.emi_loot.util.TextKey;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import me.fzzyhmstrs.fzzy_config.annotations.ConvertFrom;
import me.fzzyhmstrs.fzzy_config.annotations.IgnoreVisibility;
import me.fzzyhmstrs.fzzy_config.annotations.NonSync;
import me.fzzyhmstrs.fzzy_config.annotations.RequiresRestart;
import me.fzzyhmstrs.fzzy_config.annotations.Version;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.entry.EntryHandler;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedSet;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedAny;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedChoice;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedString;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_131;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_217;
import net.minecraft.class_2960;
import net.minecraft.class_5335;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMILoot
implements ModInitializer {
    public static String MOD_ID = "emi_loot";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"emi_loot");
    public static class_5819 emiLootRandom = new class_6575(System.currentTimeMillis());
    public static LootTableParser parser = new LootTableParser();
    public static EmiLootConfig config = (EmiLootConfig)ConfigApiJava.registerAndLoadConfig(EmiLootConfig::new, (RegisterType)RegisterType.BOTH);
    public static boolean DEBUG = EMILoot.config.debugMode;
    public static class_5342 WITHER_KILL = class_217.method_29327((String)"lootify:wither_kill", (class_5335)new KilledByWitherLootCondition.Serializer());
    public static class_5342 SPAWNS_WITH = class_217.method_29327((String)"lootify:spawns_with", (class_5335)new MobSpawnedWithLootCondition.Serializer());
    public static class_5342 CREEPER = class_217.method_29327((String)"lootify:creeper", (class_5335)new BlownUpByCreeperLootCondition.Serializer());
    public static class_5339 SET_ANY_DAMAGE = class_131.method_29323((String)"lootify:set_any_damage", (class_5335)new SetAnyDamageLootFunction.Serializer());
    public static class_5339 OMINOUS_BANNER = class_131.method_29323((String)"lootify:ominous_banner", (class_5335)new OminousBannerLootFunction.Serializer());
    public static class_1887 RANDOM = new class_1887(class_1887.class_1888.field_9091, class_1886.field_9073, class_1304.values()){

        public boolean method_25949() {
            return false;
        }

        public boolean method_25950() {
            return false;
        }
    };

    public static class_2960 identity(String path) {
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }

    public void onInitialize() {
        parser.registerServer();
    }

    @Version(version=1)
    @IgnoreVisibility
    @ConvertFrom(fileName="EmiLootConfig_v1.json")
    public static class EmiLootConfig
    extends Config {
        @RequiresRestart
        public boolean debugMode = false;
        @RequiresRestart
        private ValidatedAny<DebugMode> debugModes = new ValidatedAny((Object)new DebugMode());
        @RequiresRestart
        public boolean parseChestLoot = true;
        @RequiresRestart
        public boolean parseBlockLoot = true;
        @RequiresRestart
        public boolean parseMobLoot = true;
        @RequiresRestart
        public boolean parseGameplayLoot = true;
        @RequiresRestart
        public boolean parseArchaeologyLoot = true;
        @RequiresRestart
        public Set<String> skippedKeys = new ValidatedSet(TextKey.defaultSkips, (Entry)ValidatedString.fromList(TextKey.keys().stream().toList()));
        @NonSync
        private ValidatedAny<CompactLoot> compactLoot = new ValidatedAny((Object)new CompactLoot());
        @NonSync
        private ValidatedAny<LogUntranslatedTables> logUnstranslatedTables = new ValidatedAny((Object)new LogUntranslatedTables());
        @NonSync
        public boolean chestLootAlwaysStackSame = false;
        @NonSync
        public boolean mobLootIncludeDirectDrops = true;
        @NonSync
        private ValidatedChoice<String> conditionStyle = FabricLoader.getInstance().isModLoaded("symbols_n_stuff") ? new ValidatedChoice(List.of("default", "tooltip", "plain"), (EntryHandler)new ValidatedString(), (t, u) -> FcText.INSTANCE.translate(u + "." + t, new Object[0]), (t, u) -> FcText.INSTANCE.translate(u + "." + t, new Object[0]), ValidatedChoice.WidgetType.CYCLING) : new ValidatedChoice(List.of("tooltip", "plain", "default"), (EntryHandler)new ValidatedString(), (t, u) -> FcText.INSTANCE.translate(u + "." + t + ".sns", new Object[0]), (t, u) -> FcText.INSTANCE.translate(u + "." + t + ".sns", new Object[0]), ValidatedChoice.WidgetType.CYCLING);

        EmiLootConfig() {
            super(new class_2960(MOD_ID, "emi_loot_config"), "", "");
        }

        public boolean isTooltipStyle() {
            return Objects.equals(this.conditionStyle.get(), "tooltip") || Objects.equals(this.conditionStyle.get(), "plain");
        }

        public boolean isNotPlain() {
            return (!Objects.equals(this.conditionStyle.get(), "tooltip") || FabricLoader.getInstance().isModLoaded("symbols_n_stuff")) && !Objects.equals(this.conditionStyle.get(), "plain");
        }

        public boolean isCompact(Type type) {
            return type.compactLootSupplier.getAsBoolean();
        }

        public boolean isDebug(Type type) {
            return type.debugModeSupplier.getAsBoolean();
        }

        public boolean isLogI18n(Type type) {
            return type.logUntranslatedTablesSupplier.getAsBoolean();
        }
    }

    public static enum Type {
        BLOCK(() -> ((CompactLoot)EMILoot.config.compactLoot.get()).block, () -> ((DebugMode)EMILoot.config.debugModes.get()).block, () -> false),
        CHEST(() -> ((CompactLoot)EMILoot.config.compactLoot.get()).chest, () -> ((DebugMode)EMILoot.config.debugModes.get()).chest, () -> ((LogUntranslatedTables)EMILoot.config.logUnstranslatedTables.get()).chest),
        MOB(() -> ((CompactLoot)EMILoot.config.compactLoot.get()).mob, () -> ((DebugMode)EMILoot.config.debugModes.get()).mob, () -> false),
        GAMEPLAY(() -> ((CompactLoot)EMILoot.config.compactLoot.get()).gameplay, () -> ((DebugMode)EMILoot.config.debugModes.get()).gameplay, () -> ((LogUntranslatedTables)EMILoot.config.logUnstranslatedTables.get()).gameplay),
        ARCHAEOLOGY(() -> ((CompactLoot)EMILoot.config.compactLoot.get()).archaeology, () -> ((DebugMode)EMILoot.config.debugModes.get()).archaeology, () -> ((LogUntranslatedTables)EMILoot.config.logUnstranslatedTables.get()).archaeology);

        final BooleanSupplier compactLootSupplier;
        final BooleanSupplier debugModeSupplier;
        final BooleanSupplier logUntranslatedTablesSupplier;

        private Type(BooleanSupplier compactLootSupplier, BooleanSupplier debugModeSupplier, BooleanSupplier logUntranslatedTablesSupplier) {
            this.compactLootSupplier = compactLootSupplier;
            this.debugModeSupplier = debugModeSupplier;
            this.logUntranslatedTablesSupplier = logUntranslatedTablesSupplier;
        }
    }

    @IgnoreVisibility
    private static class LogUntranslatedTables {
        public boolean chest = FabricLoader.getInstance().isDevelopmentEnvironment();
        public boolean gameplay = FabricLoader.getInstance().isDevelopmentEnvironment();
        public boolean archaeology = FabricLoader.getInstance().isDevelopmentEnvironment();

        private LogUntranslatedTables() {
        }
    }

    @IgnoreVisibility
    private static class DebugMode {
        public boolean block = false;
        public boolean chest = false;
        public boolean mob = false;
        public boolean gameplay = false;
        public boolean archaeology = false;

        private DebugMode() {
        }
    }

    @IgnoreVisibility
    private static class CompactLoot {
        public boolean block = true;
        public boolean chest = true;
        public boolean mob = true;
        public boolean gameplay = true;
        public boolean archaeology = true;

        private CompactLoot() {
        }
    }
}

