/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fzzyhmstrs.emi_loot.EMILoot;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import org.joml.Vector3f;

public class ClientResourceData {
    public static final Object2IntMap<class_1299<?>> MOB_OFFSETS = new Object2IntOpenHashMap();
    public static final Object2FloatMap<class_1299<?>> MOB_SCALES = new Object2FloatOpenHashMap();
    public static final Map<class_1299<?>, Vector3f> MOB_ROTATIONS = new HashMap();

    public static void register() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new EntityOffsetsReloadListener());
    }

    private static class EntityOffsetsReloadListener
    implements SimpleSynchronousResourceReloadListener {
        private EntityOffsetsReloadListener() {
        }

        public class_2960 getFabricId() {
            return new class_2960(EMILoot.MOD_ID, "client_loot_resources");
        }

        public void method_14491(class_3300 manager) {
            MOB_OFFSETS.clear();
            MOB_SCALES.clear();
            MOB_ROTATIONS.clear();
            manager.method_14488("entity_fixers", path -> path.method_12832().endsWith(".json")).forEach(this::load);
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info(MOB_OFFSETS.toString());
            }
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info(MOB_ROTATIONS.toString());
            }
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info(MOB_SCALES.toString());
            }
        }

        private void load(class_2960 fileId, class_3298 resource) {
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info("Reading entity fixers from file: " + fileId.toString());
            }
            try {
                BufferedReader reader = resource.method_43039();
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                json.entrySet().forEach(entry -> {
                    JsonElement element = (JsonElement)entry.getValue();
                    class_2960 mobId = new class_2960((String)entry.getKey());
                    if (class_7923.field_41177.method_10250(mobId)) {
                        if (element.isJsonObject()) {
                            JsonElement zEl;
                            JsonElement yEl;
                            JsonElement scaling;
                            JsonObject object = element.getAsJsonObject();
                            JsonElement offset = object.get("offset");
                            if (offset != null && offset.isJsonPrimitive()) {
                                MOB_OFFSETS.put((Object)((class_1299)class_7923.field_41177.method_10223(mobId)), offset.getAsInt());
                            }
                            if ((scaling = object.get("scale")) != null && scaling.isJsonPrimitive()) {
                                MOB_SCALES.put((Object)((class_1299)class_7923.field_41177.method_10223(mobId)), scaling.getAsFloat());
                            }
                            float x = 0.0f;
                            float y = 0.0f;
                            float z = 0.0f;
                            JsonElement xEl = object.get("x");
                            if (xEl != null && xEl.isJsonPrimitive()) {
                                x = xEl.getAsFloat();
                            }
                            if ((yEl = object.get("y")) != null && yEl.isJsonPrimitive()) {
                                y = yEl.getAsFloat();
                            }
                            if ((zEl = object.get("z")) != null && zEl.isJsonPrimitive()) {
                                z = zEl.getAsFloat();
                            }
                            if (x != 0.0f || y != 0.0f || z != 0.0f) {
                                MOB_ROTATIONS.put((class_1299)class_7923.field_41177.method_10223(mobId), new Vector3f(x, y, z));
                            }
                        } else {
                            throw new IllegalArgumentException("Element in mobfixer " + String.valueOf(fileId) + "not properly formatted");
                        }
                    }
                });
            }
            catch (Exception e) {
                EMILoot.LOGGER.error("Failed to open or read Entity Offsets file: " + String.valueOf(fileId));
            }
        }
    }
}

