/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootClient;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.ClientGameplayLootTable;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.ConditionalStack;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.SymbolText;
import fzzyhmstrs.emi_loot.util.TrimmedTitle;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class GameplayLootRecipe
implements EmiRecipe {
    private final ClientGameplayLootTable loot;
    private final List<EmiStack> outputStacks;
    private final TrimmedTitle name;
    private final List<WidgetRowBuilder> rowBuilderList = new LinkedList<WidgetRowBuilder>();

    public GameplayLootRecipe(ClientGameplayLootTable loot) {
        class_5250 rawTitle;
        this.loot = loot;
        loot.build((class_1937)class_310.method_1551().field_1687, class_2246.field_10124);
        LinkedList<EmiStack> list = new LinkedList<EmiStack>();
        loot.builtItems.forEach(builtPool -> {
            builtPool.stacks().forEach(stack -> list.addAll(stack.ingredient()));
            this.addWidgetBuilders((ClientBuiltPool)builtPool, false);
        });
        this.outputStacks = list;
        String key = "emi_loot.gameplay." + loot.id.toString();
        class_5250 text = LText.translatable(key);
        if (!class_1074.method_4663((String)key)) {
            Optional modNameOpt = FabricLoader.getInstance().getModContainer(loot.id.method_12836());
            if (modNameOpt.isPresent()) {
                ModContainer modContainer = (ModContainer)modNameOpt.get();
                String modName = modContainer.getMetadata().getName();
                rawTitle = LText.translatable("emi_loot.gameplay.unknown_gameplay", modName);
            } else {
                class_5250 unknown = LText.translatable("emi_loot.gameplay.unknown");
                rawTitle = LText.translatable("emi_loot.gameplay.unknown_gameplay", unknown.getString());
            }
            if (EMILoot.config.isLogI18n(EMILoot.Type.GAMEPLAY)) {
                EMILoot.LOGGER.warn("Untranslated gameplay loot table \"" + String.valueOf(loot.id) + "\" (key: \"" + key + "\")");
            }
        } else {
            rawTitle = text;
        }
        this.name = TrimmedTitle.of((class_2561)rawTitle, EMILoot.config.isTooltipStyle() ? 138 : 148);
    }

    private void addWidgetBuilders(ClientBuiltPool newPool, boolean recursive) {
        if (recursive || this.rowBuilderList.isEmpty()) {
            this.rowBuilderList.add(new WidgetRowBuilder(154));
        }
        boolean added = false;
        for (WidgetRowBuilder builder : this.rowBuilderList) {
            if (!builder.canAddPool(newPool)) continue;
            builder.addAndTrim(newPool);
            added = true;
            break;
        }
        if (!added) {
            Optional<ClientBuiltPool> opt = this.rowBuilderList.get(this.rowBuilderList.size() - 1).addAndTrim(newPool);
            opt.ifPresent(clientMobBuiltPool -> this.addWidgetBuilders((ClientBuiltPool)clientMobBuiltPool, true));
        }
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.GAMEPLAY_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return new class_2960(EMILootClient.MOD_ID, "/" + this.getCategory().id.method_12832() + "/" + this.loot.id.method_12836() + "/" + this.loot.id.method_12832());
    }

    public List<EmiIngredient> getInputs() {
        return new LinkedList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks;
    }

    public int getDisplayWidth() {
        return EMILoot.config.isTooltipStyle() ? 144 : 154;
    }

    public int getDisplayHeight() {
        if (EMILoot.config.isTooltipStyle()) {
            int stacks = this.outputStacks.size();
            if (stacks <= 8) {
                return 29;
            }
            if (EMILoot.config.isCompact(EMILoot.Type.GAMEPLAY)) {
                int ingredients = 0;
                for (WidgetRowBuilder builder : this.rowBuilderList) {
                    ingredients += builder.ingredientCount();
                }
                if (ingredients <= 8) {
                    return 29;
                }
                return 11 + 18 * ((ingredients + 7) / 8);
            }
            return 11 + 18 * ((stacks + 7) / 8);
        }
        return this.rowBuilderList.size() * 29 + 11;
    }

    public void addWidgets(WidgetHolder widgets) {
        int x = 0;
        int y = 0;
        widgets.addText(this.name.title(), 0, 0, 0x404040, false);
        if (this.name.trimmed()) {
            widgets.addTooltipText(List.of(this.name.rawTitle()), 0, 0, EMILoot.config.isTooltipStyle() ? 144 : 154, 10);
        }
        if (EMILoot.config.isTooltipStyle()) {
            List stacks = this.outputStacks.size() <= 4 || !EMILoot.config.isCompact(EMILoot.Type.GAMEPLAY) ? (List)this.rowBuilderList.stream().map(WidgetRowBuilder::stacks).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll) : (List)this.rowBuilderList.stream().map(WidgetRowBuilder::ingredients).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
            int i = 0;
            int j = 0;
            for (ConditionalStack stack : stacks) {
                SlotWidget widget = widgets.addSlot(stack.getIngredient(), i * 18, 11 + 18 * j);
                String rounded = FloatTrimmer.trimFloatString(stack.weight());
                widget.appendTooltip((class_2561)FcText.INSTANCE.translatable("emi_loot.percent_chance", new Object[]{rounded}));
                if (EMILoot.config.isNotPlain()) {
                    for (class_3545<Integer, class_2561> pair : stack.conditions()) {
                        widget.appendTooltip((class_2561)SymbolText.of((Integer)pair.method_15442(), (class_2561)pair.method_15441()));
                    }
                }
                if (++i <= 7) continue;
                i = 0;
                ++j;
            }
        } else {
            y += 11;
            for (WidgetRowBuilder builder : this.rowBuilderList) {
                for (ClientBuiltPool pool : builder.getPoolList()) {
                    IconGroupEmiWidget widget = new IconGroupEmiWidget(x, y, pool);
                    widgets.add((Widget)widget);
                    x += widget.getWidth() + 6;
                }
                y += 29;
                x = 0;
            }
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

