/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.registry;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.condition.BlockStatePropertyConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.ConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.DamageSourceConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.EntityPropertiesConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.InvertedConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.LocationCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.MatchToolConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.MultiplesConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.RandomChanceConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.RandomChanceWithLootingConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.ReferenceConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.SimpleConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.SurvivesExplosionConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.TableBonusConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.TimeCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.ValueCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.WeatherCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.function.ApplyBonusFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.CopyNameFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.EnchantRandomlyFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.EnchantWithLevelsFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.ExplorationMapFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.ExplosionDecayFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.FunctionParser;
import fzzyhmstrs.emi_loot.parser.function.LimitCountFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.ReferenceFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetAnyDamageFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetAttributesFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetCountFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetDamageFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetEnchantmentsFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetInstrumentFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetLootTableFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetNameFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetPotionFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetStewFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SimpleFunctionParser;
import fzzyhmstrs.emi_loot.util.TextKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_117;
import net.minecraft.class_131;
import net.minecraft.class_1799;
import net.minecraft.class_217;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class LootParserRegistry {
    private static final Map<class_5342, ConditionParser> CONDITION_PARSERS = new HashMap<class_5342, ConditionParser>();
    private static final Map<class_5339, FunctionParser> FUNCTION_PARSERS = new HashMap<class_5339, FunctionParser>();

    public static void registerCondition(class_5342 type, ConditionParser parser, String registrationContext) {
        if (!CONDITION_PARSERS.containsKey(type)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("Registering condition for type: " + String.valueOf(type) + " from: " + registrationContext);
            }
            CONDITION_PARSERS.put(type, parser);
        } else {
            EMILoot.LOGGER.warn("Duplicate condition registration attempted with type: " + String.valueOf(type) + " during " + registrationContext);
        }
    }

    public static void registerFunction(class_5339 type, FunctionParser parser, String registrationContext) {
        if (!FUNCTION_PARSERS.containsKey(type)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("Registering function for type: " + String.valueOf(type) + " from: " + registrationContext);
            }
            FUNCTION_PARSERS.put(type, parser);
        } else {
            EMILoot.LOGGER.warn("Duplicate function registration attempted with type: " + String.valueOf(type) + " during " + registrationContext);
        }
    }

    public static List<LootTableParser.LootConditionResult> parseCondition(class_5341 condition, class_5342 type, class_1799 stack, boolean parentIsAlternative) {
        ConditionParser parser = CONDITION_PARSERS.getOrDefault(type, ConditionParser.EMPTY);
        return parser.parseCondition(condition, stack, parentIsAlternative);
    }

    public static LootTableParser.LootFunctionResult parseFunction(class_117 function, class_1799 stack, class_5339 type, boolean parentIsAlternative, List<TextKey> conditionTexts) {
        FunctionParser parser = FUNCTION_PARSERS.getOrDefault(type, FunctionParser.EMPTY);
        return parser.parseFunction(function, stack, parentIsAlternative, conditionTexts);
    }

    static {
        LootParserRegistry.registerFunction(class_131.field_25228, new ApplyBonusFunctionParser(), "Registering vanilla apply bonus function parser");
        LootParserRegistry.registerFunction(class_131.field_35079, new SetPotionFunctionParser(), "Registering vanilla set potion function parser");
        LootParserRegistry.registerFunction(class_131.field_25214, new SetCountFunctionParser(), "Registering vanilla set count function parser");
        LootParserRegistry.registerFunction(class_131.field_25215, new EnchantWithLevelsFunctionParser(), "Registering vanilla enchant with levels function parser");
        LootParserRegistry.registerFunction(class_131.field_25216, new EnchantRandomlyFunctionParser(), "Registering vanilla enchant randomly function parser");
        LootParserRegistry.registerFunction(class_131.field_27906, new SetEnchantmentsFunctionParser(), "Registering vanilla set enchantments function parser");
        LootParserRegistry.registerFunction(class_131.field_25218, new SimpleFunctionParser("emi_loot.function.smelt"), "Registering vanilla furnace smelt function parser");
        LootParserRegistry.registerFunction(class_131.field_25219, new SimpleFunctionParser("emi_loot.function.looting"), "Registering vanilla looting function parser");
        LootParserRegistry.registerFunction(class_131.field_25223, new ExplorationMapFunctionParser(), "Registering vanilla exploration map function parser");
        LootParserRegistry.registerFunction(class_131.field_25222, new SetNameFunctionParser(), "Registering vanilla set name function parser");
        LootParserRegistry.registerFunction(class_131.field_25226, new SimpleFunctionParser("emi_loot.function.set_contents"), "Registering vanilla set contents function parser");
        LootParserRegistry.registerFunction(class_131.field_25220, new SetDamageFunctionParser(), "Registering vanilla set damage function parser");
        LootParserRegistry.registerFunction(class_131.field_39060, new SetInstrumentFunctionParser(), "Registering vanilla set instrument function parser");
        LootParserRegistry.registerFunction(class_131.field_25234, new SimpleFunctionParser("emi_loot.function.copy_state"), "Registering vanilla copy state function parser");
        LootParserRegistry.registerFunction(class_131.field_25225, new CopyNameFunctionParser(), "Registering vanilla copy name function parser");
        LootParserRegistry.registerFunction(class_131.field_25233, new SimpleFunctionParser("emi_loot.function.copy_nbt"), "Registering vanilla copy nbt function parser");
        LootParserRegistry.registerFunction(class_131.field_25230, new ExplosionDecayFunctionParser(), "Registering vanilla explosion decay function parser");
        LootParserRegistry.registerFunction(class_131.field_25232, new SimpleFunctionParser("emi_loot.function.fill_player_head"), "Registering vanilla fill-player-head function parser");
        LootParserRegistry.registerFunction(class_131.field_25227, new LimitCountFunctionParser(), "Registering vanilla limit-count function parser");
        LootParserRegistry.registerFunction(class_131.field_25221, new SetAttributesFunctionParser(), "Registering vanilla set attributes function parser");
        LootParserRegistry.registerFunction(class_131.field_27342, new SimpleFunctionParser("emi_loot.function.banner"), "Registering vanilla set banner function parser");
        LootParserRegistry.registerFunction(class_131.field_25231, new SimpleFunctionParser("emi_loot.function.lore"), "Registering vanilla set lore function parser");
        LootParserRegistry.registerFunction(class_131.field_25224, new SetStewFunctionParser(), "Registering vanilla set stew effect function parser");
        LootParserRegistry.registerFunction(class_131.field_25217, new SimpleFunctionParser("emi_loot.function.set_nbt"), "Registering vanilla set nbt function parser");
        LootParserRegistry.registerFunction(class_131.field_25229, new SetLootTableFunctionParser(), "Registering vanilla set loot table function parser");
        LootParserRegistry.registerFunction(class_131.field_44508, new ReferenceFunctionParser(), "Registering vanilla reference function parser");
        LootParserRegistry.registerFunction(EMILoot.OMINOUS_BANNER, new SimpleFunctionParser("emi_loot.function.ominous_banner"), "Registering Lootify ominous banner function parser");
        LootParserRegistry.registerFunction(EMILoot.SET_ANY_DAMAGE, new SetAnyDamageFunctionParser(), "Registering Lootify set-any-damage function parser");
        LootParserRegistry.registerCondition(class_217.field_44789, new MultiplesConditionParser("emi_loot.condition.any_of"), "Registering vanilla any-of condition parser");
        LootParserRegistry.registerCondition(class_217.field_44790, new MultiplesConditionParser("emi_loot.condition.all_of"), "Registering vanilla all-of condition parser");
        LootParserRegistry.registerCondition(class_217.field_25245, new SurvivesExplosionConditionParser(), "Registering vanilla survives-explosion condition parser");
        LootParserRegistry.registerCondition(class_217.field_25242, new BlockStatePropertyConditionParser(), "Registering vanilla block state property condition parser");
        LootParserRegistry.registerCondition(class_217.field_25244, new TableBonusConditionParser(), "Registering vanilla table bonus condition parser");
        LootParserRegistry.registerCondition(class_217.field_25235, new InvertedConditionParser(), "Registering vanilla inverted condition parser");
        LootParserRegistry.registerCondition(class_217.field_25240, new SimpleConditionParser("emi_loot.condition.killed_player"), "Registering vanilla killed-by-player condition parser");
        LootParserRegistry.registerCondition(class_217.field_25237, new RandomChanceConditionParser(), "Registering vanilla random chance condition parser");
        LootParserRegistry.registerCondition(class_217.field_25238, new RandomChanceWithLootingConditionParser(), "Registering vanilla random chance with looting condition parser");
        LootParserRegistry.registerCondition(class_217.field_25246, new DamageSourceConditionParser(), "Registering vanilla damage source properties condition parser");
        LootParserRegistry.registerCondition(class_217.field_25247, new LocationCheckConditionParser(), "Registering vanilla location check condition parser");
        LootParserRegistry.registerCondition(class_217.field_25239, new EntityPropertiesConditionParser(), "Registering vanilla entity properties condition parser");
        LootParserRegistry.registerCondition(class_217.field_25243, new MatchToolConditionParser(), "Registering vanilla match-tool condition parser");
        LootParserRegistry.registerCondition(class_217.field_25241, new SimpleConditionParser("emi_loot.condition.entity_scores"), "Registering vanilla entity scores condition parser");
        LootParserRegistry.registerCondition(class_217.field_25249, new ReferenceConditionParser(), "Registering vanilla reference condition parser");
        LootParserRegistry.registerCondition(class_217.field_25250, new TimeCheckConditionParser(), "Registering vanilla time check condition parser");
        LootParserRegistry.registerCondition(class_217.field_27911, new ValueCheckConditionParser(), "Registering vanilla value check condition parser");
        LootParserRegistry.registerCondition(class_217.field_25248, new WeatherCheckConditionParser(), "Registering vanilla weather check condition parser");
        LootParserRegistry.registerCondition(EMILoot.SPAWNS_WITH, new SimpleConditionParser("emi_loot.condition.spawns_with"), "Registering lootify spawns with condition parser");
        LootParserRegistry.registerCondition(EMILoot.CREEPER, new SimpleConditionParser("emi_loot.condition.creeper"), "Registering lootify creeper condition parser");
        LootParserRegistry.registerCondition(EMILoot.WITHER_KILL, new SimpleConditionParser("emi_loot.condition.wither_kill"), "Registering lootify wither-killed condition parser");
    }
}

