/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.server.ChestLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.GameplayLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.util.TextKey;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class GameplayLootTableSender
implements LootSender<GameplayLootPoolBuilder> {
    private final String idToSend;
    final List<GameplayLootPoolBuilder> builderList = new LinkedList<GameplayLootPoolBuilder>();
    public static class_2960 GAMEPLAY_SENDER = new class_2960("e_l", "g_s");
    boolean isEmpty = true;

    public GameplayLootTableSender(class_2960 id) {
        this.idToSend = LootSender.getIdToSend(id);
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            if (!builder.isEmpty) {
                this.isEmpty = false;
            }
        });
    }

    @Override
    public void send(class_3222 player) {
        if (!ServerPlayNetworking.canSend((class_3222)player, (class_2960)GAMEPLAY_SENDER)) {
            return;
        }
        if (this.isEmpty) {
            if (EMILoot.config.isDebug(EMILoot.Type.GAMEPLAY)) {
                EMILoot.LOGGER.info("avoiding empty gameplay table: " + this.idToSend);
            }
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(this.idToSend);
        if (this.builderList.size() == 1 && this.builderList.get((int)0).isSimple) {
            if (EMILoot.config.isDebug(EMILoot.Type.GAMEPLAY)) {
                EMILoot.LOGGER.info("sending simple gameplay table: " + this.idToSend);
            }
            buf.writeShort(-1);
            buf.method_42065((class_2359)class_7923.field_41178, (Object)this.builderList.get((int)0).simpleStack.method_7909());
            ServerPlayNetworking.send((class_3222)player, (class_2960)GAMEPLAY_SENDER, (class_2540)buf);
            return;
        }
        if (this.builderList.isEmpty()) {
            return;
        }
        buf.writeShort(this.builderList.size());
        this.builderList.forEach(builder -> {
            ArrayList totalConditions = new ArrayList();
            builder.conditions.forEach(lootConditionResult -> totalConditions.add(lootConditionResult.text()));
            builder.functions.forEach(lootFunctionResult -> totalConditions.addAll(lootFunctionResult.conditions()));
            buf.writeShort(totalConditions.size());
            totalConditions.forEach(lootConditionResult -> lootConditionResult.toBuf(buf));
            buf.writeShort(builder.functions.size());
            builder.functions.forEach(lootFunctionResult -> lootFunctionResult.text().toBuf(buf));
            HashMap<List<TextKey>, ChestLootPoolBuilder> lootPoolBuilderMap = builder.builtMap;
            buf.writeShort(lootPoolBuilderMap.size());
            lootPoolBuilderMap.forEach((key, chestBuilder) -> {
                buf.writeShort(key.size());
                key.forEach(textKey -> textKey.toBuf(buf));
                Object2FloatMap<class_1799> keyPoolMap = lootPoolBuilderMap.getOrDefault((Object)key, new ChestLootPoolBuilder((float)1.0f)).builtMap;
                buf.writeShort(keyPoolMap.size());
                keyPoolMap.forEach((stack, weight) -> {
                    buf.method_10793(stack);
                    buf.writeFloat(weight.floatValue());
                });
            });
        });
        ServerPlayNetworking.send((class_3222)player, (class_2960)GAMEPLAY_SENDER, (class_2540)buf);
    }

    @Override
    public void addBuilder(GameplayLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<GameplayLootPoolBuilder> getBuilders() {
        return this.builderList;
    }
}

