/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fzzyhmstrs.emi_loot.EMILoot;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5270;

public class ServerResourceData {
    public static final Multimap<class_2960, class_52> DIRECT_DROPS = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
    public static final List<class_2960> SHEEP_TABLES;
    public static final List<class_2960> TABLE_EXCLUSIONS;
    private static final Gson GSON;
    private static final int DIRECT_DROPS_PATH_LENGTH;
    private static final int FILE_SUFFIX_LENGTH;

    public static void loadDirectTables(class_3300 resourceManager) {
        DIRECT_DROPS.clear();
        resourceManager.method_14488("direct_drops", path -> path.method_12832().endsWith(".json")).forEach(ServerResourceData::loadDirectTable);
        resourceManager.method_14488("emi_loot_data", path -> path.method_12832().endsWith(".json")).forEach(ServerResourceData::loadTableExclusion);
    }

    private static void loadDirectTable(class_2960 id, class_3298 resource) {
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("Reading direct drop table from file: " + id.toString());
        }
        String path = id.method_12832();
        class_2960 id2 = new class_2960(id.method_12836(), path.substring(DIRECT_DROPS_PATH_LENGTH, path.length() - FILE_SUFFIX_LENGTH));
        String path2 = id2.method_12832();
        if (!path2.startsWith("blocks/") && !path2.startsWith("entities/")) {
            EMILoot.LOGGER.error("File path for [" + String.valueOf(id) + "] not correct; needs a 'blocks' or 'entities' subfolder. Skipping.");
            EMILoot.LOGGER.error("Example: [./data/mod_id/direct_drops/blocks/cobblestone.json] is a valid block direct drop table path for a block added by [mod_id].");
            return;
        }
        try {
            BufferedReader reader = resource.method_43039();
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            class_52 lootTable = (class_52)GSON.fromJson((JsonElement)json, class_52.class);
            if (lootTable != null) {
                DIRECT_DROPS.put((Object)id2, (Object)lootTable);
            } else {
                EMILoot.LOGGER.error("Loot table in file [" + String.valueOf(id) + "] is empty!");
            }
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to open or read direct drops loot table file: " + String.valueOf(id));
        }
    }

    private static void loadTableExclusion(class_2960 id, class_3298 resource) {
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("Reading exclusion table from file: " + id.toString());
        }
        try {
            BufferedReader reader = resource.method_43039();
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonElement list = json.get("exclusions");
            if (list != null && list.isJsonArray()) {
                list.getAsJsonArray().forEach(element -> {
                    if (element.isJsonPrimitive()) {
                        class_2960 identifier = new class_2960(element.getAsString());
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Adding exclusion: " + String.valueOf(identifier));
                        }
                        TABLE_EXCLUSIONS.add(identifier);
                    } else {
                        EMILoot.LOGGER.error("Exclusion element not properly formatted: " + String.valueOf(element));
                    }
                });
            } else {
                EMILoot.LOGGER.error("Exclusions in file: " + String.valueOf(id) + " not readable.");
            }
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to open or read table exclusions file: " + String.valueOf(id));
        }
    }

    public static boolean skipTable(class_2960 id) {
        return TABLE_EXCLUSIONS.contains(id);
    }

    public static Multimap<class_2960, class_52> getMissedDirectDrops(List<class_2960> parsedList) {
        Multimap missedDrops = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        for (Map.Entry entry : DIRECT_DROPS.entries()) {
            if (parsedList.contains(entry.getKey())) continue;
            missedDrops.put((Object)((class_2960)entry.getKey()), (Object)((class_52)entry.getValue()));
        }
        return missedDrops;
    }

    static {
        TABLE_EXCLUSIONS = new LinkedList<class_2960>();
        GSON = class_5270.method_27862().create();
        DIRECT_DROPS_PATH_LENGTH = "direct_drops/".length();
        FILE_SUFFIX_LENGTH = ".json".length();
        class_2960[] ids = new class_2960[]{class_39.field_869, class_39.field_814, class_39.field_224, class_39.field_461, class_39.field_385, class_39.field_702, class_39.field_629, class_39.field_878, class_39.field_806, class_39.field_365, class_39.field_285, class_39.field_394, class_39.field_489, class_39.field_607, class_39.field_716, class_39.field_778};
        SHEEP_TABLES = Arrays.stream(ids).toList();
    }
}

