/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import traben.entity_model_features.EMF;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModelPartCustom;
import traben.entity_model_features.models.EMFModelPartVanilla;
import traben.entity_model_features.models.EMFModelPartWithState;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.features.property_reading.PropertiesRandomProvider;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.EntityIntLRU;

@Environment(value=EnvType.CLIENT)
public class EMFModelPartRoot
extends EMFModelPartVanilla {
    public final OptifineMobNameForFileAndEMFMapId modelName;
    public final class_630 vanillaRoot;
    @NotNull
    public final EntityIntLRU entitySuffixMap = new EntityIntLRU();
    private final Map<String, EMFModelPartVanilla> allVanillaParts;
    private final Int2ObjectOpenHashMap<class_630> vanillaFormatModelPartOfEachState = new Int2ObjectOpenHashMap();
    public EMFManager.CemDirectoryApplier variantDirectoryApplier;
    public ETFApi.ETFVariantSuffixProvider variantTester = null;
    public boolean containsCustomModel = false;
    private long lastMobCountAnimatedOn = 0L;
    private boolean hasRemovedTopLevelJemTextureFromChildren = false;

    public EMFModelPartRoot(OptifineMobNameForFileAndEMFMapId mobNameForFileAndMap, EMFManager.CemDirectoryApplier variantDirectoryApplier, class_630 vanillaRoot, Collection<String> optifinePartNames, Map<String, EMFModelPartVanilla> mapForCreatedParts) {
        super("root", vanillaRoot, optifinePartNames, mapForCreatedParts);
        this.allVanillaParts = mapForCreatedParts;
        this.allVanillaParts.putIfAbsent(this.name, this);
        this.modelName = mobNameForFileAndMap;
        this.variantDirectoryApplier = variantDirectoryApplier;
        this.vanillaRoot = vanillaRoot;
        this.receiveOneTimeRunnable(this::registerModelRunnableWithEntityTypeContext);
    }

    private void registerModelRunnableWithEntityTypeContext() {
        if (EMFAnimationEntityContext.getEMFEntity() != null) {
            String type;
            if (((EMFConfig)EMF.config().getConfig()).debugOnRightClick) {
                type = EMFAnimationEntityContext.getEMFEntity().emf$getTypeString();
                Set roots = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForDebug.get((Object)type);
                if (roots == null) {
                    ObjectLinkedOpenHashSet newRootSet = new ObjectLinkedOpenHashSet();
                    EMFManager.getInstance().rootPartsPerEntityTypeForDebug.put((Object)type, (Object)newRootSet);
                    newRootSet.add(this);
                } else {
                    roots.add(this);
                }
            }
            type = EMFAnimationEntityContext.getEMFEntity().emf$getTypeString();
            Set variators = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForVariation.computeIfAbsent((Object)type, k -> new HashSet());
            variators.add(this);
            if (this.variantTester != null && ((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                EMFUtils.log("Registered new variating model for: " + type);
            }
        }
        this.receiveOneTimeRunnable(null);
    }

    public void doVariantCheck() {
        int finalSuffix;
        if (this.variantTester == null) {
            this.setVariantStateTo(1);
            return;
        }
        UUID id = EMFAnimationEntityContext.getEMFEntity().etf$getUuid();
        int knownSuffix = this.entitySuffixMap.getInt((Object)id);
        if (knownSuffix != -1) {
            this.checkIfShouldExpireEntity(id);
            finalSuffix = knownSuffix;
        } else {
            int newSuffix = this.variantTester.getSuffixForETFEntity((ETFEntity)EMFAnimationEntityContext.getEMFEntity());
            if (newSuffix == 0) {
                this.entitySuffixMap.put(id, 1);
                finalSuffix = 1;
            } else {
                this.entitySuffixMap.put(id, newSuffix);
                finalSuffix = newSuffix;
            }
        }
        if (finalSuffix == 0) {
            EMFManager.getInstance().lastModelSuffixOfEntity.removeInt((Object)id);
        } else {
            EMFManager.getInstance().lastModelSuffixOfEntity.put(id, finalSuffix);
        }
        this.setVariantStateTo(finalSuffix);
    }

    public void checkIfShouldExpireEntity(UUID id) {
        if (this.variantTester.entityCanUpdate(id)) {
            switch (((EMFConfig)EMF.config().getConfig()).modelUpdateFrequency) {
                case Never: {
                    break;
                }
                case Instant: {
                    this.entitySuffixMap.removeInt((Object)id);
                    break;
                }
                default: {
                    int delay = ((EMFConfig)EMF.config().getConfig()).modelUpdateFrequency.getDelay();
                    int time = (int)(EMFAnimationEntityContext.getTime() % (float)delay);
                    if (time != Math.abs(id.hashCode()) % delay) break;
                    this.entitySuffixMap.removeInt((Object)id);
                }
            }
        }
    }

    public void addVariantOfJem(EMFJemData jemData, int variant) {
        if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
            EMFUtils.log(" > " + jemData.getMobModelIDInfo().getfileName() + ", constructing variant #" + variant);
        }
        HashMap<String, EMFModelPartCustom> newEmfParts = new HashMap<String, EMFModelPartCustom>();
        for (EMFPartData eMFPartData : jemData.models) {
            if (eMFPartData.part == null) continue;
            String idUnique = EMFUtils.getIdUnique(newEmfParts.keySet(), eMFPartData.id);
            newEmfParts.put(idUnique, new EMFModelPartCustom(eMFPartData, variant, eMFPartData.part, idUnique));
        }
        for (Map.Entry entry : this.allVanillaParts.entrySet()) {
            String thisPartName = (String)entry.getKey();
            EMFModelPartVanilla thisPart = (EMFModelPartVanilla)((Object)entry.getValue());
            EMFModelPartWithState.EMFModelState vanillaState = EMFModelPartWithState.EMFModelState.copy((EMFModelPartWithState.EMFModelState)thisPart.allKnownStateVariants.get(0));
            thisPart.setFromState(vanillaState);
            if (thisPart instanceof EMFModelPartRoot) {
                EMFModelPartRoot root = (EMFModelPartRoot)thisPart;
                if (!root.field_3663.isEmpty()) {
                    root.textureOverride = jemData.getCustomTexture();
                }
            }
            HashMap<String, EMFModelPartCustom> children = new HashMap<String, EMFModelPartCustom>();
            for (Map.Entry newPartEntry : newEmfParts.entrySet()) {
                EMFModelPartCustom newPart = (EMFModelPartCustom)((Object)newPartEntry.getValue());
                if (!thisPartName.equals(newPart.partToBeAttached)) continue;
                if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                    EMFUtils.log(" > > > EMF custom part attached: " + (String)newPartEntry.getKey());
                }
                if (!newPart.attach) {
                    thisPart.field_3663 = List.of();
                    thisPart.field_3661.values().forEach(part -> {
                        if (part instanceof EMFModelPartVanilla) {
                            EMFModelPartVanilla vanilla = (EMFModelPartVanilla)((Object)((Object)part));
                            if (!vanilla.isOptiFinePartSpecified) {
                                vanilla.setHideInTheseStates(variant);
                            }
                        }
                    });
                }
                children.put(EMFUtils.getIdUnique(thisPart.field_3661.keySet(), (String)newPartEntry.getKey()), newPart);
            }
            children.putAll(thisPart.vanillaChildren);
            thisPart.field_3661 = children;
            thisPart.allKnownStateVariants.put(variant, (Object)thisPart.getCurrentState());
        }
        if (!this.allKnownStateVariants.containsKey(variant)) {
            this.allKnownStateVariants.put(variant, (Object)EMFModelPartWithState.EMFModelState.copy((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(0)));
        }
    }

    public void discoverAndInitVariants() {
        String thisDirectoryFileName = this.variantDirectoryApplier.getThisDirectoryOfFilename(this.modelName.getNamespace(), this.modelName.getfileName());
        class_2960 propertyID = EMFUtils.res(thisDirectoryFileName + ".properties");
        if (class_310.method_1551().method_1478().method_14486(propertyID).isPresent()) {
            this.variantTester = ETFApi.getVariantSupplierOrNull((class_2960)propertyID, (class_2960)EMFUtils.res(thisDirectoryFileName + ".jem"), (String[])new String[]{"models"});
            ETFApi.ETFVariantSuffixProvider eTFVariantSuffixProvider = this.variantTester;
            if (eTFVariantSuffixProvider instanceof PropertiesRandomProvider) {
                PropertiesRandomProvider propertiesRandomProvider = (PropertiesRandomProvider)eTFVariantSuffixProvider;
                propertiesRandomProvider.setOnMeetsRuleHook((entity, rule) -> {
                    if (rule == null) {
                        EMFManager.getInstance().lastModelRuleOfEntity.removeInt((Object)entity.etf$getUuid());
                    } else {
                        EMFManager.getInstance().lastModelRuleOfEntity.put(entity.etf$getUuid(), rule.RULE_NUMBER);
                    }
                });
            }
            if (this.variantTester != null) {
                IntOpenHashSet allModelVariants = this.variantTester.getAllSuffixes();
                allModelVariants.remove(1);
                allModelVariants.remove(0);
                if (!allModelVariants.isEmpty()) {
                    eTFVariantSuffixProvider = allModelVariants.iterator();
                    while (eTFVariantSuffixProvider.hasNext()) {
                        EMFJemData jemDataVariant;
                        int variant = (Integer)eTFVariantSuffixProvider.next();
                        this.setVariantStateTo(1);
                        String jemNameVariant = this.variantDirectoryApplier.getThisDirectoryOfFilename(this.modelName.getNamespace(), this.modelName.getfileName() + variant + ".jem");
                        if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                            EMFUtils.log(" > incorporating variant jem file: " + jemNameVariant);
                        }
                        if ((jemDataVariant = EMFManager.getJemDataWithDirectory(jemNameVariant, this.modelName)) != null) {
                            this.addVariantOfJem(jemDataVariant, variant);
                            this.setVariantStateTo(variant);
                            EMFManager.getInstance().setupAnimationsFromJemToModel(jemDataVariant, this, variant);
                            this.containsCustomModel = true;
                            continue;
                        }
                        this.allKnownStateVariants.put(variant, (Object)((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(1)));
                        if (!((EMFConfig)EMF.config().getConfig()).logModelCreationData) continue;
                        EMFUtils.log(" > invalid jem variant file: " + jemNameVariant);
                    }
                } else if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                    EMFUtils.logWarn("properties with only 1 variant found: " + String.valueOf(propertyID) + ".");
                }
            } else {
                EMFUtils.logWarn("null properties found for: " + String.valueOf(propertyID));
                this.variantDirectoryApplier = null;
            }
        } else {
            EMFUtils.logWarn("no properties or variants found for found for: " + thisDirectoryFileName + ".jem");
            this.variantDirectoryApplier = null;
        }
    }

    public void setVariant1ToVanilla0() {
        this.allKnownStateVariants.put(1, (Object)((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(0)));
        this.allVanillaParts.forEach((k, child) -> child.allKnownStateVariants.put(1, (Object)((EMFModelPartWithState.EMFModelState)child.allKnownStateVariants.get(0))));
    }

    public void tryRenderVanillaRootNormally(class_4587 matrixStack, class_4588 vertexConsumer, int light, int overlay) {
        if (this.vanillaRoot != null) {
            matrixStack.method_22903();
            if (((EMFConfig)EMF.config().getConfig()).vanillaModelHologramRenderMode_2 == EMFConfig.VanillaModelRenderMode.OFFSET) {
                matrixStack.method_46416(1.0f, 0.0f, 0.0f);
            }
            this.vanillaRoot.method_22699(matrixStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.method_22909();
        }
    }

    public void tryRenderVanillaFormatRoot(class_4587 matrixStack, class_4588 vertexConsumer, int light, int overlay) {
        if (((EMFConfig)EMF.config().getConfig()).attemptPhysicsModPatch_2 == EMFConfig.PhysicsModCompatChoice.VANILLA) {
            if (this.vanillaRoot != null) {
                this.vanillaRoot.method_22699(matrixStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            class_630 vanillaFormat = this.getVanillaFormatRoot();
            if (vanillaFormat != null) {
                vanillaFormat.method_22699(matrixStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public class_630 getVanillaFormatRoot() {
        if (!this.vanillaFormatModelPartOfEachState.containsKey(this.currentModelVariant)) {
            this.vanillaFormatModelPartOfEachState.put(this.currentModelVariant, (Object)this.getVanillaModelPartsOfCurrentState());
        }
        return (class_630)this.vanillaFormatModelPartOfEachState.get(this.currentModelVariant);
    }

    public void receiveAnimations(int variant, Collection<EMFAnimation> animationList) {
        ArrayList<EMFAnimation> finalList = new ArrayList<EMFAnimation>(animationList);
        if (!finalList.isEmpty()) {
            Runnable run = () -> {
                if (this.lastMobCountAnimatedOn != EMFManager.getInstance().entityRenderCount) {
                    this.lastMobCountAnimatedOn = EMFManager.getInstance().entityRenderCount;
                    if (EMFAnimationEntityContext.isFirstPersonHand && ((EMFConfig)EMF.config().getConfig()).preventFirstPersonHandAnimating) {
                        return;
                    }
                    class_630[] pausedParts = EMFAnimationEntityContext.getEntityPartsAnimPaused();
                    for (EMFAnimation emfAnimation : finalList) {
                        try {
                            if (pausedParts != null) {
                                emfAnimation.calculateAndSetIfNotPaused(pausedParts);
                                continue;
                            }
                            emfAnimation.calculateAndSet();
                        }
                        catch (Exception e) {
                            EMFUtils.logError("Error in animation expression [" + emfAnimation.animKey + "] for model [" + this.modelName.getfileName() + "] with expression [" + emfAnimation.expressionString + "].");
                            EMFUtils.logError("Error was: " + e.getMessage());
                            EMFUtils.logError("Disabling all animations for model: [" + String.valueOf(this.modelName) + "]");
                            this.allVanillaParts.values().forEach(emf -> emf.receiveRootAnimationRunnable(variant, null));
                        }
                    }
                }
            };
            this.allVanillaParts.values().forEach(emf -> emf.receiveRootAnimationRunnable(variant, run));
        }
    }

    public class_2960 getTopLevelJemTexture() {
        if (this.hasRemovedTopLevelJemTextureFromChildren) {
            return this.textureOverride;
        }
        this.hasRemovedTopLevelJemTextureFromChildren = true;
        if (this.textureOverride != null) {
            this.allVanillaParts.values().forEach(emf -> {
                if (emf.textureOverride.equals((Object)this.textureOverride)) {
                    emf.textureOverride = null;
                }
            });
        }
        return this.textureOverride;
    }

    @Override
    public String toString() {
        return "[EMF root part of " + this.modelName.getfileName() + "]";
    }

    @Override
    public String toStringShort() {
        return "[EMF root part of " + this.modelName.getfileName() + "]";
    }
}

