/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptifineMobNameForFileAndEMFMapId
implements Comparable<OptifineMobNameForFileAndEMFMapId> {
    String namespace = "minecraft";
    private String fileName;
    private String mapId;
    private String secondaryFileName = null;
    private String secondaryNamespace = null;

    public OptifineMobNameForFileAndEMFMapId(String both) {
        this(both, null);
    }

    private OptifineMobNameForFileAndEMFMapId(String both, String mapId) {
        this.fileName = both;
        this.mapId = mapId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptifineMobNameForFileAndEMFMapId that = (OptifineMobNameForFileAndEMFMapId)o;
        return this.fileName.equals(that.fileName) && Objects.equals(this.mapId, that.mapId);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.mapId);
    }

    public String toString() {
        return this.fileName;
    }

    public void setBoth(String both) {
        this.fileName = both;
        this.mapId = null;
    }

    public boolean areBothSame() {
        return this.mapId == null || this.fileName.equals(this.mapId);
    }

    public void setBoth(String fileName, String mapId) {
        this.fileName = fileName;
        this.mapId = mapId;
    }

    public String getfileName() {
        return this.fileName;
    }

    @Nullable
    public OptifineMobNameForFileAndEMFMapId getSecondaryModel() {
        if (this.secondaryFileName != null) {
            OptifineMobNameForFileAndEMFMapId second = new OptifineMobNameForFileAndEMFMapId(this.secondaryFileName, this.getMapId());
            second.namespace = this.secondaryNamespace == null ? this.namespace : this.secondaryNamespace;
            return second;
        }
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void finishAndPrepSecondaries() {
        if (this.getfileName().contains(":")) {
            String[] split = this.fileName.split(":");
            if (split.length == 2) {
                this.assertNamespaceAndCreateDeprecatedModdedFileName(split[0], split[1]);
            }
        } else if (!"minecraft".equals(this.namespace)) {
            this.assertNamespaceAndCreateDeprecatedModdedFileName(this.namespace, this.fileName);
        } else if (this.fileName.endsWith("_inner_armor")) {
            this.secondaryFileName = "inner_armor";
        } else if (this.fileName.endsWith("_outer_armor")) {
            this.secondaryFileName = "outer_armor";
        }
    }

    private void assertNamespaceAndCreateDeprecatedModdedFileName(String namespace, String fileName) {
        this.namespace = namespace;
        this.fileName = fileName;
        this.secondaryNamespace = "minecraft";
        this.secondaryFileName = "modded/" + namespace + "/" + fileName;
    }

    public String getMapId() {
        String namespace = this.getNamespace().equals("minecraft") ? "" : this.getNamespace() + ":";
        return namespace + (this.mapId == null ? this.fileName : this.mapId);
    }

    @Override
    public int compareTo(@NotNull OptifineMobNameForFileAndEMFMapId o) {
        return this.getfileName().compareTo(o.getfileName());
    }

    public String getDisplayFileName() {
        if (this.fileName.startsWith("modded/")) {
            return this.fileName + ".jem";
        }
        return "assets/" + this.namespace + "/optifine/cem/" + this.fileName + ".jem";
    }
}

