/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.optifine_properties;

import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_7417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;

public class NameProperty
extends StringArrayOrRegexProperty {
    protected NameProperty(String data) throws RandomProperty.RandomPropertyException {
        super(data);
    }

    public static NameProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            String dataFromProperty = NameProperty.readPropertiesOrThrow(properties, propertyNum, "name", "names");
            ArrayList<String> names = new ArrayList<String>();
            if (dataFromProperty.isBlank()) {
                throw new RandomProperty.RandomPropertyException("Name failed");
            }
            if (dataFromProperty.startsWith("regex:") || dataFromProperty.startsWith("pattern:")) {
                names.add(dataFromProperty);
            } else {
                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(dataFromProperty);
                while (m.find()) {
                    names.add(m.group(1).replace("\"", "").trim());
                }
            }
            StringBuilder builder = new StringBuilder();
            for (String str : names) {
                builder.append(str).append(" ");
            }
            return new NameProperty(builder.toString().trim());
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return false;
    }

    @Override
    @Nullable
    public String getValueFromEntity(ETFEntity etfEntity) {
        class_2561 entityNameText;
        if (etfEntity instanceof class_1657) {
            class_1657 player = (class_1657)etfEntity;
            return player.method_5477().getString();
        }
        if (etfEntity.etf$hasCustomName() && (entityNameText = etfEntity.etf$getCustomName()) != null) {
            class_7417 content = entityNameText.method_10851();
            if (content instanceof class_2585) {
                class_2585 literal = (class_2585)content;
                return literal.comp_737();
            }
            return entityNameText.getString();
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"name", "names"};
    }
}

