/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.tconstruct.recipe.modifiers;

import com.kneelawk.extramodintegrations.tconstruct.TiCCategories;
import com.kneelawk.extramodintegrations.tconstruct.stack.ModifierEmiStack;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;

public class ModifierWorktableEmiRecipe
extends BasicEmiRecipe {
    private static final class_2960 BACKGROUND_LOC = TConstruct.getResource((String)"textures/gui/jei/tinker_station.png");
    private final class_2561 title;
    private final class_2561 description;
    private final EmiIngredient inputTools;
    private final int inputCount;
    private final List<EmiIngredient> displayItems;
    private final EmiIngredient modifier;
    private final boolean isModifierOutput;

    public ModifierWorktableEmiRecipe(IModifierWorktableRecipe recipe) {
        super(TiCCategories.MODIFIER_WORKTABLE, recipe.method_8114(), 121, 35);
        this.inputTools = EmiIngredient.of(recipe.getInputTools().stream().map(EmiStack::of).toList());
        this.inputCount = recipe.getInputCount();
        ArrayList<EmiIngredient> displayItems = new ArrayList<EmiIngredient>();
        for (int i = 0; i < 2; ++i) {
            displayItems.add(EmiIngredient.of(recipe.getDisplayItems(i).stream().map(EmiStack::of).toList()));
        }
        this.displayItems = displayItems;
        this.modifier = EmiIngredient.of(recipe.getModifierOptions(null).stream().map(ModifierEmiStack::of).toList());
        this.isModifierOutput = recipe.isModifierOutput();
        this.title = recipe.getTitle();
        this.description = recipe.getDescription(null);
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        inputs.add(this.inputTools);
        inputs.addAll(displayItems);
        if (!this.isModifierOutput) {
            inputs.add(this.modifier);
        }
        this.inputs = Collections.unmodifiableList(inputs);
        if (this.isModifierOutput) {
            this.outputs = this.modifier.getEmiStacks();
        }
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND_LOC, 0, 0, 121, 35, 0, 166);
        widgets.addText(this.title, 3, 2, 0x404040, false);
        widgets.addTooltip(List.of(class_5684.method_32662((class_5481)this.description.method_30937())), 0, 0, this.width, 12);
        widgets.addSlot(this.inputTools, 22, 15).drawBack(false);
        int max = Math.min(2, this.inputCount);
        for (int i = 0; i < max; ++i) {
            widgets.addSlot(this.displayItems.get(i), 42 + i * 18, 15).drawBack(false);
        }
        SlotWidget modifierSlot = widgets.addSlot(this.modifier, 81, 15).drawBack(false);
        if (this.isModifierOutput) {
            modifierSlot.recipeContext((EmiRecipe)this);
        }
        if (this.inputTools.isEmpty()) {
            widgets.addTexture(BACKGROUND_LOC, 23, 16, 16, 16, 128, 0);
        }
        for (int i = 0; i < 2; ++i) {
            if (!this.displayItems.get(i).isEmpty()) continue;
            widgets.addTexture(BACKGROUND_LOC, 43 + i * 18, 16, 16, 16, 176 + 32 * i, 0);
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }
}

