/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.resources;

import com.google.gson.JsonParser;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.CropConfig;
import io.github.lucaargolo.seasons.utils.ModIdentifier;
import io.github.lucaargolo.seasons.utils.Season;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class CropConfigs
implements SimpleSynchronousResourceReloadListener {
    private static final CropConfig DEFAULT;
    private static CropConfig defaultCropConfig;
    private static HashMap<class_2960, CropConfig> cropConfigMap;

    public static float getSeasonCropMultiplier(class_2960 cropIdentifier, Season season) {
        return cropConfigMap.getOrDefault(cropIdentifier, defaultCropConfig).getModifier(season);
    }

    public static void receiveConfig(CropConfig defaultConfig, HashMap<class_2960, CropConfig> configMap) {
        defaultCropConfig = defaultConfig;
        cropConfigMap = configMap;
    }

    public static void clear() {
        defaultCropConfig = DEFAULT;
        cropConfigMap.clear();
    }

    public static CropConfig getDefaultCropConfig() {
        return defaultCropConfig;
    }

    public static void toBuf(class_2540 buf) {
        buf.writeInt(cropConfigMap.size());
        cropConfigMap.forEach((id, config) -> {
            buf.method_10812(id);
            config.toBuf(buf);
        });
    }

    public static HashMap<class_2960, CropConfig> fromBuf(class_2540 buf) {
        HashMap<class_2960, CropConfig> cropConfigMap = new HashMap<class_2960, CropConfig>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            cropConfigMap.put(buf.method_10810(), CropConfig.fromBuf(buf));
        }
        return cropConfigMap;
    }

    public class_2960 getFabricId() {
        return new ModIdentifier("crop_configs");
    }

    public void method_14491(class_3300 manager) {
        try {
            class_3298 resource2 = (class_3298)manager.method_14486((class_2960)new ModIdentifier("hardcoded/crop/default.json")).orElseThrow();
            defaultCropConfig = new CropConfig(JsonParser.parseReader((Reader)new InputStreamReader(resource2.method_14482(), StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            FabricSeasons.LOGGER.error("[Fabric Seasons] Failed to load hardcoded grass colors", (Throwable)e);
        }
        cropConfigMap.clear();
        manager.method_14488("seasons/crop", id -> id.method_12832().endsWith(".json")).forEach((id, resource) -> {
            String[] split = id.method_12832().split("/");
            class_2960 cropIdentifier = new class_2960(id.method_12836(), split[split.length - 1].replace(".json", ""));
            try {
                CropConfig config = new CropConfig(JsonParser.parseReader((Reader)new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8)));
                cropConfigMap.put(cropIdentifier, config);
            }
            catch (Exception e) {
                FabricSeasons.LOGGER.error("[Fabric Seasons] Failed to load crop config for: " + cropIdentifier, (Throwable)e);
            }
        });
        if (!cropConfigMap.isEmpty()) {
            FabricSeasons.LOGGER.info("[Fabric Seasons] Successfully loaded " + cropConfigMap.size() + " custom crop configs.");
        }
    }

    static {
        defaultCropConfig = DEFAULT = new CropConfig(1.0f, 0.8f, 0.6f, 0.0f);
        cropConfigMap = new HashMap();
    }
}

