/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DynamicHolder<T>
implements Supplier<T> {
    public static final class_2960 EMPTY = new class_2960("empty", "empty");
    protected final DynamicRegistry<? super T> registry;
    protected final class_2960 id;
    @Nullable
    protected T value;

    DynamicHolder(DynamicRegistry<? super T> registry, class_2960 id) {
        this.id = id;
        this.registry = registry;
    }

    public boolean isBound() {
        this.bind();
        return this.value != null;
    }

    @Override
    public T get() {
        this.bind();
        Objects.requireNonNull(this.value, "Trying to access unbound value: " + this.id);
        return this.value;
    }

    public Optional<T> getOptional() {
        return this.isBound() ? Optional.of(this.value()) : Optional.empty();
    }

    public class_2960 getId() {
        return this.id;
    }

    public boolean is(class_2960 id) {
        return this.id.equals((Object)id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DynamicHolder)) return false;
        DynamicHolder dh = (DynamicHolder)obj;
        if (dh.registry != this.registry) return false;
        if (!dh.id.equals((Object)this.id)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.registry});
    }

    void bind() {
        if (this.value != null) {
            return;
        }
        this.value = this.registry.getValue(this.id);
    }

    void unbind() {
        this.value = null;
    }

    @Deprecated(forRemoval=true)
    public T value() {
        return this.get();
    }
}

