/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.blocks.statements;

import de.keksuccino.fancymenu.customization.action.Executable;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElseIfExecutableBlock
extends AbstractExecutableBlock {
    @NotNull
    public LoadingRequirementContainer condition = new LoadingRequirementContainer().forceRequirementsMet(true);
    @Nullable
    protected AbstractExecutableBlock child;

    public ElseIfExecutableBlock() {
    }

    public ElseIfExecutableBlock(@NotNull LoadingRequirementContainer condition) {
        this.condition = Objects.requireNonNull(condition);
    }

    @Override
    public String getBlockType() {
        return "else-if";
    }

    @Override
    public void execute() {
        if (this.check()) {
            super.execute();
        } else if (this.child != null) {
            this.child.execute();
        }
    }

    @Override
    public void setAppendedBlock(@Nullable AbstractExecutableBlock appended) {
        super.setAppendedBlock(appended);
        this.child = appended;
    }

    @Override
    @Nullable
    public AbstractExecutableBlock getAppendedBlock() {
        return this.child;
    }

    @Override
    public void addValuePlaceholder(@NotNull String placeholder, @NotNull Supplier<String> replaceWithSupplier) {
        super.addValuePlaceholder(placeholder, replaceWithSupplier);
        this.condition.addValuePlaceholder(placeholder, replaceWithSupplier);
    }

    @Override
    @NotNull
    public ElseIfExecutableBlock copy(boolean unique) {
        ElseIfExecutableBlock b = new ElseIfExecutableBlock();
        if (!unique) {
            b.identifier = this.identifier;
        }
        if (this.getAppendedBlock() != null) {
            b.setAppendedBlock((AbstractExecutableBlock)this.getAppendedBlock().copy(unique));
        }
        for (Executable e : this.executables) {
            b.addExecutable(e.copy(unique));
        }
        b.condition = this.condition.copy(unique);
        b.valuePlaceholders.putAll(this.valuePlaceholders);
        return b;
    }

    public boolean check() {
        return this.condition.requirementsMet();
    }

    @Override
    @NotNull
    public PropertyContainer serialize() {
        PropertyContainer container = super.serialize();
        String key = "[else_if_executable_block_body:" + this.getIdentifier() + "]";
        container.putProperty(key, this.condition.identifier);
        this.condition.serializeToExistingPropertyContainer(container);
        return container;
    }

    public static ElseIfExecutableBlock deserializeEmptyWithIdentifier(@NotNull PropertyContainer serialized, @NotNull String identifier) {
        ElseIfExecutableBlock b = new ElseIfExecutableBlock();
        b.identifier = identifier;
        for (Map.Entry<String, String> m : serialized.getProperties().entrySet()) {
            if (!m.getKey().equals("[else_if_executable_block_body:" + identifier + "]")) continue;
            LoadingRequirementContainer lrc = LoadingRequirementContainer.deserializeWithIdentifier(m.getValue(), serialized);
            if (lrc == null) break;
            b.condition = lrc;
            break;
        }
        return b;
    }
}

