/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.dragger;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.dragger.DraggerElementHandler;
import de.keksuccino.fancymenu.customization.element.elements.dragger.DraggerWidget;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DraggerElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DrawableColor ELEMENT_COLOR = DrawableColor.of(new Color(227, 14, 35));
    public final DraggerWidget widget = new DraggerWidget(0, 0, 0, 0, this::onDraggerElementDragged, this::onDraggerElementClickedOrReleased);
    public int userDragOffsetX = 0;
    public int userDragOffsetY = 0;
    public boolean saveDragOffset = true;
    protected boolean leftMouseDownOnElement = false;
    protected int mouseDownX = 0;
    protected int mouseDownY = 0;
    protected int mouseDownOffsetX = 0;
    protected int mouseDownOffsetY = 0;
    protected boolean firstTick = true;

    public DraggerElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    protected void onDraggerElementDragged(double mouseX, double mouseY, double dragX, double dragY) {
        if (!DraggerElement.isEditor() && this.leftMouseDownOnElement) {
            int draggingDiffX = (int)(mouseX - (double)this.mouseDownX);
            int draggingDiffY = (int)(mouseY - (double)this.mouseDownY);
            if (draggingDiffX != 0 || draggingDiffY != 0) {
                int xCached = this.userDragOffsetX;
                int yCached = this.userDragOffsetY;
                this.userDragOffsetX = this.mouseDownOffsetX + draggingDiffX;
                this.userDragOffsetY = this.mouseDownOffsetY + draggingDiffY;
                if (this.stayOnScreen) {
                    if (!this.checkIsValidStayOnScreenX(this._getAbsoluteX())) {
                        this.userDragOffsetX = xCached;
                    }
                    if (!this.checkIsValidStayOnScreenY(this._getAbsoluteY())) {
                        this.userDragOffsetY = yCached;
                    }
                }
            }
        }
    }

    protected void onDraggerElementClickedOrReleased(double mouseX, double mouseY, boolean released) {
        if (!DraggerElement.isEditor() && this.widget.method_49606()) {
            this.leftMouseDownOnElement = !released;
            this.mouseDownX = (int)mouseX;
            this.mouseDownY = (int)mouseY;
            this.mouseDownOffsetX = this.userDragOffsetX;
            this.mouseDownOffsetY = this.userDragOffsetY;
        } else {
            this.leftMouseDownOnElement = false;
        }
        if (released) {
            if (this.saveDragOffset) {
                DraggerElementHandler.putMeta(this.getInstanceIdentifier(), this.userDragOffsetX, this.userDragOffsetY);
            } else {
                DraggerElementHandler.putMeta(this.getInstanceIdentifier(), 0, 0);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.firstTick) {
            DraggerElementHandler.DraggerMeta meta;
            this.firstTick = false;
            if (this.saveDragOffset && (meta = DraggerElementHandler.getMeta(this.getInstanceIdentifier())) != null) {
                this.userDragOffsetX = meta.offsetX;
                this.userDragOffsetY = meta.offsetY;
            }
        }
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.widget.field_22764 = this.shouldRender();
        if (this.shouldRender()) {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            this.widget.method_46421(x);
            this.widget.method_46419(y);
            this.widget.method_25358(w);
            ((IMixinAbstractWidget)((Object)this.widget)).setHeightFancyMenu(h);
            this.widget.method_25394(graphics, mouseX, mouseY, partial);
            if (DraggerElement.isEditor()) {
                RenderSystem.enableBlend();
                graphics.method_25294(x, y, x + w, y + h, ELEMENT_COLOR.getColorInt());
                graphics.method_44379(x, y, x + w, y + h);
                class_327 class_3272 = class_310.method_1551().field_1772;
                class_2561 class_25612 = this.getDisplayName();
                int n = x + w / 2;
                int n2 = y + h / 2;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                graphics.method_27534(class_3272, class_25612, n, n2 - 9 / 2, -1);
                graphics.method_44380();
                RenderingUtils.resetShaderColor(graphics);
            }
        } else {
            this.leftMouseDownOnElement = false;
        }
    }

    @Override
    @Nullable
    public List<class_364> getWidgetsToRegister() {
        return List.of(this.widget);
    }

    @Override
    public int getAbsoluteX() {
        int i = this._getAbsoluteX();
        if (this.stayOnScreen) {
            if (i < 2) {
                i = 2;
            }
            if (i > DraggerElement.getScreenWidth() - 2 - this.getAbsoluteWidth()) {
                i = DraggerElement.getScreenWidth() - 2 - this.getAbsoluteWidth();
            }
        }
        return i;
    }

    protected int _getAbsoluteX() {
        return super.getAbsoluteX() + (!DraggerElement.isEditor() ? this.userDragOffsetX : 0);
    }

    @Override
    public int getAbsoluteY() {
        int i = this._getAbsoluteY();
        if (this.stayOnScreen) {
            if (i < 2) {
                i = 2;
            }
            if (i > DraggerElement.getScreenHeight() - 2 - this.getAbsoluteHeight()) {
                i = DraggerElement.getScreenHeight() - 2 - this.getAbsoluteHeight();
            }
        }
        return i;
    }

    protected int _getAbsoluteY() {
        return super.getAbsoluteY() + (!DraggerElement.isEditor() ? this.userDragOffsetY : 0);
    }

    public boolean checkIsValidStayOnScreenX(int x) {
        if (this.stayOnScreen) {
            if (x < 2) {
                return false;
            }
            if (x > DraggerElement.getScreenWidth() - 2 - this.getAbsoluteWidth()) {
                return false;
            }
        }
        return true;
    }

    public boolean checkIsValidStayOnScreenY(int y) {
        if (this.stayOnScreen) {
            if (y < 2) {
                return false;
            }
            if (y > DraggerElement.getScreenHeight() - 2 - this.getAbsoluteHeight()) {
                return false;
            }
        }
        return true;
    }
}

