/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.animation.animator;

import com.faboslav.friendsandfoes.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.client.render.entity.animation.animator.ModelPartAnimationType;
import com.faboslav.friendsandfoes.client.render.entity.animation.animator.ModelPartAnimator;
import com.faboslav.friendsandfoes.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.client.render.entity.animation.animator.context.KeyframeAnimationContext;
import com.faboslav.friendsandfoes.client.render.entity.animation.animator.context.ModelPartAnimationContext;
import com.faboslav.friendsandfoes.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.entity.animation.Animation;
import com.faboslav.friendsandfoes.entity.animation.Keyframe;
import com.faboslav.friendsandfoes.entity.animation.Transformation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_3532;
import net.minecraft.class_5597;
import net.minecraft.class_630;
import net.minecraft.class_7094;
import org.joml.Vector3f;

public final class ModelAnimator {
    private static final Vector3f TEMP = new Vector3f();

    public static void updateKeyframeAnimations(AnimatedEntity animatedEntity, AnimatedEntityModel animatedEntityModel, KeyframeAnimation keyframeAnimation, float animationProgress) {
        AnimationContextTracker animationContextTracker = animatedEntity.getAnimationContextTracker();
        Animation animation = keyframeAnimation.getAnimation();
        int currentTick = ((class_1297)animatedEntity).field_6012;
        KeyframeAnimationContext keyframeAnimationContext = animationContextTracker.get(keyframeAnimation);
        keyframeAnimationContext.setCurrentTick(currentTick);
        class_7094 animationState = keyframeAnimationContext.getAnimationState();
        animationState.method_43686(animationProgress, 1.0f);
        animationState.method_41323(state -> ModelAnimator.animateKeyframe(animatedEntityModel, animation, state.method_43687(), 1.0f, TEMP));
    }

    public static void updateMovementKeyframeAnimations(AnimatedEntity animatedEntity, AnimatedEntityModel animatedEntityModel, long runningTime, float f) {
        KeyframeAnimation keyframeAnimation = animatedEntity.getMovementAnimation();
        Animation animation = keyframeAnimation.getAnimation();
        ModelAnimator.animateKeyframe(animatedEntityModel, animation, runningTime, f, TEMP);
    }

    public static void animateKeyframe(class_5597<?> model, Animation animation, long runningTime, float scale, Vector3f vec3f) {
        float f = ModelAnimator.getRunningSeconds(animation, runningTime);
        for (Map.Entry<String, List<Transformation>> entry : animation.boneAnimations().entrySet()) {
            Optional optional = model.method_41909(entry.getKey());
            List<Transformation> list = entry.getValue();
            optional.ifPresent(part -> list.forEach(transformation -> {
                Keyframe[] keyframes = transformation.keyframes();
                int i = Math.max(0, class_3532.method_15360((int)0, (int)keyframes.length, index -> f <= keyframes[index].timestamp()) - 1);
                int j = Math.min(keyframes.length - 1, i + 1);
                Keyframe keyframe = keyframes[i];
                Keyframe keyframe2 = keyframes[j];
                float h = f - keyframe.timestamp();
                float k = j != i ? class_3532.method_15363((float)(h / (keyframe2.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe2.interpolation().apply(vec3f, k, keyframes, i, j, scale);
                Transformation.Type type = transformation.type();
                if (type == Transformation.Type.TRANSLATE) {
                    part.method_41920(vec3f);
                } else if (type == Transformation.Type.ROTATE) {
                    part.method_41922(vec3f);
                } else if (type == Transformation.Type.SCALE) {
                    part.method_41924(vec3f);
                }
            }));
        }
    }

    private static float getRunningSeconds(Animation animation, long runningTime) {
        float f = (float)runningTime / 1000.0f;
        return animation.looping() ? f % animation.lengthInSeconds() : f;
    }

    public static void animateModelPartXPositionWithProgress(AnimatedEntity animatedEntity, class_630 modelPart, float targetX, float progress) {
        ModelAnimator.animateModelPartPositionWithProgress(animatedEntity, modelPart, targetX, modelPart.field_3656, modelPart.field_3655, progress);
    }

    public static void animateModelPartYPositionWithProgress(AnimatedEntity animatedEntity, class_630 modelPart, float targetY, float progress) {
        ModelAnimator.animateModelPartPositionWithProgress(animatedEntity, modelPart, modelPart.field_3657, targetY, modelPart.field_3655, progress);
    }

    public static void animateModelPartZPositionWithProgress(AnimatedEntity animatedEntity, class_630 modelPart, float targetZ, float progress) {
        ModelAnimator.animateModelPartPositionWithProgress(animatedEntity, modelPart, modelPart.field_3657, modelPart.field_3656, targetZ, progress);
    }

    public static void animateModelPartPositionWithProgress(AnimatedEntity animatedEntity, class_630 modelPart, float targetX, float targetY, float targetZ, float progress) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelAnimator.animateWithProgress(animatedEntity, modelPart, ModelPartAnimationType.POSITION, targetVector, progress);
    }

    public static void animateModelPartXRotationBasedOnProgress(AnimatedEntity animatedEntity, class_630 modelPart, float targetX, float progress) {
        ModelAnimator.animateModelPartRotationBasedOnProgress(animatedEntity, modelPart, targetX, modelPart.field_3675, modelPart.field_3674, progress);
    }

    public static void animateModelPartYRotationBasedOnProgress(AnimatedEntity animatedEntity, class_630 modelPart, float targetY, float progress) {
        ModelAnimator.animateModelPartRotationBasedOnProgress(animatedEntity, modelPart, modelPart.field_3654, targetY, modelPart.field_3674, progress);
    }

    public static void animateZRotationBasedOnProgress(AnimatedEntity animatedEntity, class_630 modelPart, float targetZ, float progress) {
        ModelAnimator.animateModelPartRotationBasedOnProgress(animatedEntity, modelPart, targetZ, modelPart.field_3675, modelPart.field_3674, progress);
    }

    public static void animateModelPartRotationBasedOnProgress(AnimatedEntity animatedEntity, class_630 modelPart, float targetX, float targetY, float targetZ, float progress) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelAnimator.animateWithProgress(animatedEntity, modelPart, ModelPartAnimationType.ROTATION, targetVector, progress);
    }

    private static void animateWithProgress(AnimatedEntity animatedEntity, class_630 modelPart, ModelPartAnimationType animationType, Vector3f targetVector, float progress) {
        Vector3f animationCurrentVector;
        ModelPartAnimationContext animationContext;
        String modelPartName;
        AnimationContextTracker animationContextTracker = animatedEntity.getAnimationContextTracker();
        if (animationContextTracker.contains(modelPartName = modelPart.toString(), animationType)) {
            animationContext = animationContextTracker.get(modelPartName, animationType);
            animationCurrentVector = animationContext.getCurrentVector();
            Vector3f animationTargetVector = animationContext.getTargetVector();
            if (!animationTargetVector.equals((Object)targetVector)) {
                animationContextTracker.remove(modelPartName, animationType);
                animationContext = ModelPartAnimationContext.createWithProgress(progress, targetVector, animationCurrentVector);
                animationContextTracker.add(modelPartName, animationType, animationContext);
            }
        } else {
            animationCurrentVector = switch (animationType) {
                default -> throw new IncompatibleClassChangeError();
                case ModelPartAnimationType.POSITION -> new Vector3f(modelPart.field_3657, modelPart.field_3656, modelPart.field_3655);
                case ModelPartAnimationType.ROTATION -> new Vector3f(modelPart.field_3654, modelPart.field_3675, modelPart.field_3674);
            };
            animationContext = ModelPartAnimationContext.createWithProgress(progress, targetVector, animationCurrentVector);
            animationContextTracker.add(modelPartName, animationType, animationContext);
        }
        animationContext.setProgress(progress);
        animationContext.recalculateCurrentVector();
        animationCurrentVector = animationContext.getCurrentVector();
        switch (animationType) {
            case POSITION: {
                ModelPartAnimator.setPosition(modelPart, animationCurrentVector);
                break;
            }
            case ROTATION: {
                ModelPartAnimator.setRotation(modelPart, animationCurrentVector);
            }
        }
    }

    public static void animateModelPartXPositionBasedOnTicks(AnimatedEntity animatedEntity, class_630 modelPart, float targetX, int ticks) {
        ModelAnimator.animateModelPartModelPartPositionBasedOnTicks(animatedEntity, modelPart, targetX, modelPart.field_3656, modelPart.field_3655, ticks);
    }

    public static void animateModelPartYPositionBasedOnTicks(AnimatedEntity animatedEntity, class_630 modelPart, float targetY, int ticks) {
        ModelAnimator.animateModelPartModelPartPositionBasedOnTicks(animatedEntity, modelPart, modelPart.field_3657, targetY, modelPart.field_3655, ticks);
    }

    public static void animateZPositionBasedOnTicks(AnimatedEntity animatedEntity, class_630 modelPart, float targetX, int ticks) {
        ModelAnimator.animateModelPartModelPartPositionBasedOnTicks(animatedEntity, modelPart, targetX, modelPart.field_3656, modelPart.field_3655, ticks);
    }

    public static void animateModelPartModelPartPositionBasedOnTicks(AnimatedEntity animatedEntity, class_630 modelPart, float targetX, float targetY, float targetZ, int ticks) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelAnimator.animateModelPartBasedOnTicks(animatedEntity, modelPart, ModelPartAnimationType.POSITION, targetVector, ticks);
    }

    public static void animateModelPartXRotationBasedOnTicks(AnimatedEntity animatedEntity, class_630 modelPart, float targetX, int ticks) {
        ModelAnimator.animateModelPartRotationBasedOnTicks(animatedEntity, modelPart, targetX, modelPart.field_3675, modelPart.field_3674, ticks);
    }

    public static void animateModelPartYRotationBasedOnTicks(AnimatedEntity animatedEntity, class_630 modelPart, float targetY, int ticks) {
        ModelAnimator.animateModelPartRotationBasedOnTicks(animatedEntity, modelPart, modelPart.field_3654, targetY, modelPart.field_3674, ticks);
    }

    public static void animateModelPartZRotationBasedOnTicks(AnimatedEntity animatedEntity, class_630 modelPart, float targetZ, int ticks) {
        ModelAnimator.animateModelPartRotationBasedOnTicks(animatedEntity, modelPart, modelPart.field_3675, modelPart.field_3674, targetZ, ticks);
    }

    public static void animateModelPartRotationBasedOnTicks(AnimatedEntity animatedEntity, class_630 modelPart, float targetX, float targetY, float targetZ, int ticks) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelAnimator.animateModelPartBasedOnTicks(animatedEntity, modelPart, ModelPartAnimationType.ROTATION, targetVector, ticks);
    }

    private static void animateModelPartBasedOnTicks(AnimatedEntity animatedEntity, class_630 modelPart, ModelPartAnimationType animationType, Vector3f targetVector, int ticks) {
        Vector3f currentVector;
        ModelPartAnimationContext animationContext;
        AnimationContextTracker animationContextTracker = animatedEntity.getAnimationContextTracker();
        int currentEntityTick = ((class_1297)animatedEntity).field_6012;
        String modelPartName = modelPart.toString();
        if (animationContextTracker.contains(modelPartName, animationType)) {
            animationContext = animationContextTracker.get(modelPartName, animationType);
            currentVector = animationContext.getCurrentVector();
            if (currentVector.equals((Object)targetVector)) {
                switch (animationType) {
                    case POSITION: {
                        ModelPartAnimator.setPosition(modelPart, targetVector);
                        break;
                    }
                    case ROTATION: {
                        ModelPartAnimator.setRotation(modelPart, targetVector);
                    }
                }
                return;
            }
            Vector3f animationTargetVector = animationContext.getTargetVector();
            if (!animationTargetVector.equals((Object)targetVector)) {
                animationContextTracker.remove(modelPartName, animationType);
                animationContext = ModelPartAnimationContext.createWithTicks(currentEntityTick, ticks, targetVector, currentVector);
                animationContextTracker.add(modelPartName, animationType, animationContext);
            }
        } else {
            currentVector = switch (animationType) {
                default -> throw new IncompatibleClassChangeError();
                case ModelPartAnimationType.POSITION -> new Vector3f(modelPart.field_3657, modelPart.field_3656, modelPart.field_3655);
                case ModelPartAnimationType.ROTATION -> new Vector3f(modelPart.field_3654, modelPart.field_3675, modelPart.field_3674);
            };
            animationContext = ModelPartAnimationContext.createWithTicks(currentEntityTick, ticks, targetVector, currentVector);
            animationContextTracker.add(modelPartName, animationType, animationContext);
        }
        animationContext.setCurrentTick(currentEntityTick);
        animationContext.recalculateProgress();
        animationContext.recalculateCurrentVector();
        currentVector = animationContext.getCurrentVector();
        switch (animationType) {
            case POSITION: {
                ModelPartAnimator.setPosition(modelPart, currentVector);
                break;
            }
            case ROTATION: {
                ModelPartAnimator.setRotation(modelPart, currentVector);
            }
        }
    }
}

