/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.entity;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.block.FrozenTorchBlock;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.enchantment.EnervationEnchantment;
import com.github.thedeathlycow.frostiful.entity.BiterEntity;
import com.github.thedeathlycow.frostiful.entity.RootedEntity;
import com.github.thedeathlycow.frostiful.entity.ThrownIcicleEntity;
import com.github.thedeathlycow.frostiful.item.FrostWandItem;
import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import com.github.thedeathlycow.frostiful.registry.FItems;
import com.github.thedeathlycow.frostiful.sound.FSoundEvents;
import com.github.thedeathlycow.frostiful.tag.FBlockTags;
import com.github.thedeathlycow.frostiful.tag.FDamageTypeTags;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1371;
import net.minecraft.class_1379;
import net.minecraft.class_1381;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1617;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2527;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_3988;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class FrostologerEntity
extends class_1617
implements class_1603 {
    private static final class_2940<Boolean> IS_USING_FROST_WAND = class_2945.method_12791(FrostologerEntity.class, (class_2941)class_2943.field_13323);
    public static final float MAX_POWER_SCALE_START = -0.95f;
    private static final int NUM_POWER_PARTICLES = 2;
    private static final float START_PLACING_SNOW_TEMP = -0.8f;
    public float prevStrideDistance;
    public float strideDistance;
    public double prevCapeX;
    public double prevCapeY;
    public double prevCapeZ;
    public double capeX;
    public double capeY;
    public double capeZ;
    private boolean isChanneling = false;
    private final class_2338[] stepPositionsPool = new class_2338[2];

    public FrostologerEntity(class_1299<? extends FrostologerEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 20;
    }

    public static class_5132.class_5133 createFrostologerAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23716, 150.0).method_26868(ThermooAttributes.MIN_TEMPERATURE, 5.0);
    }

    public boolean isInHeatedArea() {
        return EnvironmentManager.INSTANCE.getController().isAreaHeated(this.method_37908(), this.method_24515());
    }

    public boolean isAtMaxPower() {
        return this.thermoo$getTemperatureScale() <= -0.95f;
    }

    public void destroyHeatSource(class_3218 world, class_2680 state, class_2338 blockPos) {
        class_2680 torch;
        class_2248 heatedBlock = state.method_26204();
        class_3610 fluidState = state.method_26227();
        class_2680 frozenState = state.method_26164(FBlockTags.FROSTOLOGER_CANNOT_FREEZE) ? state : (blockPos.equals((Object)this.method_24515()) ? (fluidState.method_15767(class_3486.field_15517) ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564()) : (state.method_26164(FBlockTags.HOT_FLOOR) ? class_2246.field_10445.method_9564() : (state.method_26234((class_1922)world, blockPos) ? class_2246.field_10295.method_9564() : (fluidState.method_39360((class_3611)class_3612.field_15908) && fluidState.method_15761() == 8 ? class_2246.field_10540.method_9564() : (heatedBlock instanceof class_2527 ? ((torch = FrozenTorchBlock.freezeTorch(state)) != null ? torch : class_2246.field_10124.method_9564()) : (state.method_28498((class_2769)class_2741.field_12508) && (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_2246.field_10295.method_9564() : class_2246.field_10124.method_9564()))))));
        world.method_8501(blockPos, frozenState);
        world.method_8396(null, blockPos, class_3417.field_15102, class_3419.field_15251, 0.5f, 1.0f + (this.field_5974.method_43057() % 0.2f - 0.1f));
        class_243 centeredPos = class_243.method_24953((class_2382)blockPos);
        world.method_14199((class_2394)class_2398.field_11251, centeredPos.field_1352, centeredPos.field_1351, centeredPos.field_1350, 12, 0.1, 1.0, 0.1, 0.1);
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource.method_48789(class_8103.field_42247) && this.isChanneling()) {
            return true;
        }
        return damageSource.method_48789(class_8103.field_42252) || damageSource.method_48789(FDamageTypeTags.IS_ICICLE) || super.method_5679(damageSource);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1617.class_1619((class_1617)this));
        this.field_6201.method_6277(2, (class_1352)new FrostWandCastGoal(this, 1.0, 40, 10.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1439.class, 8.0f, 1.2, 1.5));
        this.field_6201.method_6277(4, (class_1352)new FrostWandAttackGoal());
        this.field_6201.method_6277(4, (class_1352)new SummonMinionsGoal());
        this.field_6201.method_6277(4, (class_1352)new IcicleAttackGoal((class_6017)class_6019.method_35017((int)20, (int)30)));
        this.field_6201.method_6277(6, (class_1352)new DestroyHeatSourcesGoal(15));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 0.6));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{class_3763.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true).method_6330(300));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3988.class, false).method_6330(300));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, false));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.method_5964(world.method_8409(), difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_6122(class_1268.field_5808, new class_1799((class_1935)FItems.FROST_WAND));
        this.method_5673(class_1304.field_6174, new class_1799((class_1935)FItems.FROSTOLOGY_CLOAK));
        this.method_30759(random, difficulty.method_5458());
        this.method_5946(class_1304.field_6173, 0.0f);
        this.method_5946(class_1304.field_6174, 0.0f);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_USING_FROST_WAND, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        this.updateCapeAngles();
        if (this.method_37908().field_9236 && this.isAtMaxPower()) {
            this.spawnPowerParticles();
        }
        FrostifulConfig config = Frostiful.getConfig();
        if (this.isTargetPlayer() && this.thermoo$getTemperatureScale() > -config.combatConfig.getFrostologerMaxPassiveFreezing()) {
            this.thermoo$addTemperature(-config.combatConfig.getFrostologerPassiveFreezingPerTick(), (HeatingMode)HeatingModes.PASSIVE);
        }
    }

    public void method_5842() {
        super.method_5842();
        this.prevStrideDistance = this.strideDistance;
        this.strideDistance = 0.0f;
    }

    public void method_6007() {
        super.method_6007();
        this.prevStrideDistance = this.strideDistance;
        float walkSpeed = this.method_24828() && !this.method_29504() && !this.method_5681() ? Math.min(0.1f, (float)this.method_18798().method_37267()) : 0.0f;
        this.strideDistance += (walkSpeed - this.strideDistance) * 0.4f;
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            return;
        }
        if (!world.method_8450().method_8355(class_1928.field_19388)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2338 frostologerPos = this.method_24515();
        class_2680 snow = class_2246.field_10477.method_9564();
        this.stepPositionsPool[0] = frostologerPos;
        this.stepPositionsPool[1] = frostologerPos.method_10074();
        for (class_2338 blockPos : this.stepPositionsPool) {
            boolean canPlaceSnow;
            class_2680 blockState = world.method_8320(blockPos);
            if (EnvironmentManager.INSTANCE.getController().isHeatSource(blockState)) {
                this.destroyHeatSource(serverWorld, blockState, blockPos);
            }
            boolean bl = canPlaceSnow = blockState.method_26215() && this.thermoo$getTemperatureScale() <= -0.8f && snow.method_26184((class_4538)world, blockPos);
            if (!canPlaceSnow) continue;
            world.method_8501(blockPos, snow);
            world.method_43276(class_5712.field_28164, blockPos, class_5712.class_7397.method_43286((class_1297)this, (class_2680)blockState));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnPowerParticles() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        class_238 box = this.method_5829();
        for (int i = 0; i < 2; ++i) {
            double x = box.method_1001(class_2350.class_2351.field_11048) + random.nextDouble(box.method_17939());
            double y = box.method_1001(class_2350.class_2351.field_11052) + random.nextDouble(box.method_17940());
            double z = box.method_1001(class_2350.class_2351.field_11051) + random.nextDouble(box.method_17941());
            this.method_37908().method_8406((class_2394)class_2398.field_28013, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public class_1543.class_1544 method_6990() {
        if (this.method_7137()) {
            return class_1543.class_1544.field_7212;
        }
        return this.method_20034() ? class_1543.class_1544.field_19012 : class_1543.class_1544.field_21512;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        if (this.field_6277.method_31574(FItems.FROST_WAND)) {
            this.method_5988().method_35111((class_1297)target);
            FrostWandItem.fireFrostSpell(this.field_6277.method_7972(), this.method_37908(), (class_1309)this);
        }
    }

    public boolean hasTarget() {
        class_1309 target = this.method_5968();
        return target != null && target.method_5805();
    }

    public boolean isTargetPlayer() {
        class_1309 target = this.method_5968();
        return target != null && target.method_5805() && target.method_31747();
    }

    public boolean isTargetRooted() {
        class_1309 target = this.method_5968();
        return target != null && ((RootedEntity)target).frostiful$isRooted();
    }

    public boolean isUsingFrostWand() {
        return (Boolean)this.field_6011.method_12789(IS_USING_FROST_WAND);
    }

    private void startUsingFrostWand() {
        this.method_5783(FSoundEvents.ITEM_FROST_WAND_PREPARE_CAST, 1.0f, 1.0f);
        this.field_6011.method_12778(IS_USING_FROST_WAND, (Object)true);
    }

    private void stopUsingFrostWand() {
        this.field_6011.method_12778(IS_USING_FROST_WAND, (Object)false);
    }

    public void method_16484(int wave, boolean unused) {
    }

    private void updateCapeAngles() {
        this.prevCapeX = this.capeX;
        this.prevCapeY = this.capeY;
        this.prevCapeZ = this.capeZ;
        double dx = this.method_23317() - this.capeX;
        double dy = this.method_23318() - this.capeY;
        double dz = this.method_23321() - this.capeZ;
        double threshold = 10.0;
        if (dx > threshold) {
            this.prevCapeX = this.capeX = this.method_23317();
        }
        if (dz > threshold) {
            this.prevCapeZ = this.capeZ = this.method_23321();
        }
        if (dy > threshold) {
            this.prevCapeY = this.capeY = this.method_23318();
        }
        if (dx < -threshold) {
            this.prevCapeX = this.capeX = this.method_23317();
        }
        if (dz < -threshold) {
            this.prevCapeZ = this.capeZ = this.method_23321();
        }
        if (dy < -threshold) {
            this.prevCapeY = this.capeY = this.method_23318();
        }
        this.capeX += dx / 4.0;
        this.capeZ += dz / 4.0;
        this.capeY += dy / 4.0;
    }

    public boolean method_5722(@Nullable class_1297 other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.method_5722(other)) {
            return true;
        }
        if (other.method_5864() == FEntityTypes.BITER) {
            return this.method_5722((class_1297)((BiterEntity)other).getOwner());
        }
        if (other instanceof class_1309 && ((class_1309)other).method_6046() == class_1310.field_6291) {
            return this.method_5781() == null && other.method_5781() == null;
        }
        return false;
    }

    protected class_3414 method_5994() {
        return FSoundEvents.ENTITY_FROSTOLOGER_AMBIENT;
    }

    protected class_3414 method_6002() {
        return FSoundEvents.ENTITY_FROSTOLOGER_DEATH;
    }

    protected class_3414 method_6011(class_1282 source) {
        return FSoundEvents.ENTITY_FROSTOLOGER_HURT;
    }

    public class_3414 method_20033() {
        return FSoundEvents.ENTITY_CHILLAGER_CELEBRATE;
    }

    protected class_3414 method_7142() {
        return FSoundEvents.ENTITY_FROSTOLOGER_CAST_SPELL;
    }

    public boolean isChanneling() {
        return this.isChanneling;
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(IS_USING_FROST_WAND, (Object)nbt.method_10577("IsUsingFrostWand"));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("IsUsingFrostWand", ((Boolean)this.field_6011.method_12789(IS_USING_FROST_WAND)).booleanValue());
    }

    protected class FrostWandCastGoal
    extends class_1381 {
        public FrostWandCastGoal(class_1603 mob, double mobSpeed, int intervalTicks, float maxShootRange) {
            super(mob, mobSpeed, intervalTicks, maxShootRange);
        }

        public boolean method_6264() {
            return super.method_6264() && FrostologerEntity.this.hasTarget() && !FrostologerEntity.this.isTargetRooted() && FrostologerEntity.this.method_6047().method_31574(FItems.FROST_WAND);
        }

        public void method_6269() {
            super.method_6269();
            FrostologerEntity.this.method_19540(true);
            FrostologerEntity.this.method_6019(class_1268.field_5808);
            FrostologerEntity.this.startUsingFrostWand();
        }

        public void method_6270() {
            super.method_6270();
            FrostologerEntity.this.method_19540(false);
            FrostologerEntity.this.method_6021();
            FrostologerEntity.this.stopUsingFrostWand();
        }
    }

    protected class FrostWandAttackGoal
    extends class_1371 {
        public FrostWandAttackGoal() {
            super((class_1308)FrostologerEntity.this);
        }

        public boolean method_6264() {
            return FrostologerEntity.this.isTargetRooted() && super.method_6264();
        }
    }

    protected class SummonMinionsGoal
    extends class_1617.class_1620 {
        private static final class_4051 IS_MINION = class_4051.method_36626().method_18418(16.0).method_36627().method_18424();
        private static final int SUMMON_BITER_COOL_DOWN = 100;
        private int nextStartTime;

        protected SummonMinionsGoal() {
            super((class_1617)FrostologerEntity.this);
            this.nextStartTime = -1;
        }

        public void method_6269() {
            super.method_6269();
            if (FrostologerEntity.this.method_5809()) {
                FrostologerEntity.this.method_5646();
                FrostologerEntity.this.method_36975();
            }
        }

        public boolean method_6264() {
            if (FrostologerEntity.this.field_6012 <= this.nextStartTime) {
                return false;
            }
            if (FrostologerEntity.this.field_5974.method_43048(2) == 0) {
                return false;
            }
            if (!super.method_6264()) {
                return false;
            }
            if (!FrostologerEntity.this.isTargetRooted()) {
                return false;
            }
            int numNearbyMinions = FrostologerEntity.this.method_37908().method_18466(BiterEntity.class, IS_MINION, (class_1309)FrostologerEntity.this, FrostologerEntity.this.method_5829().method_1014(16.0)).size();
            return FrostologerEntity.this.field_5974.method_43048(8) + 1 > numNearbyMinions;
        }

        protected void method_7148() {
            class_3218 serverWorld = (class_3218)FrostologerEntity.this.method_37908();
            this.nextStartTime = FrostologerEntity.this.field_6012 + 100;
            for (int i = 0; i < 3; ++i) {
                class_2338 blockPos = FrostologerEntity.this.method_24515();
                BiterEntity minionEntity = (BiterEntity)FEntityTypes.BITER.method_5883((class_1937)serverWorld);
                if (minionEntity == null) {
                    return;
                }
                minionEntity.method_5725(blockPos, 0.0f, 0.0f);
                minionEntity.method_5943((class_5425)serverWorld, serverWorld.method_8404(blockPos), class_3730.field_16471, null, null);
                minionEntity.setOwner((class_1308)FrostologerEntity.this);
                serverWorld.method_30771((class_1297)minionEntity);
            }
        }

        protected int method_7149() {
            return 20;
        }

        protected int method_7151() {
            return 20;
        }

        @Nullable
        protected class_3414 method_7150() {
            return class_3417.field_15193;
        }

        protected class_1617.class_1618 method_7147() {
            return class_1617.class_1618.field_7379;
        }
    }

    protected class IcicleAttackGoal
    extends class_1617.class_1620 {
        private final class_6017 numIciclesProvider;
        private static final int ICICLE_ATTACK_COOL_DOWN = 20;
        private int nextStartTime;

        public IcicleAttackGoal(class_6017 numIciclesProvider) {
            super((class_1617)FrostologerEntity.this);
            this.nextStartTime = -1;
            this.numIciclesProvider = numIciclesProvider;
        }

        public void method_6269() {
            super.method_6269();
            if (FrostologerEntity.this.method_5809()) {
                FrostologerEntity.this.method_5646();
                FrostologerEntity.this.method_36975();
            }
        }

        public boolean method_6264() {
            if (FrostologerEntity.this.field_6012 <= this.nextStartTime) {
                return false;
            }
            if (FrostologerEntity.this.field_5974.method_43048(2) == 0) {
                return false;
            }
            if (!super.method_6264()) {
                return false;
            }
            return FrostologerEntity.this.isTargetRooted();
        }

        protected void method_7148() {
            class_3218 serverWorld = (class_3218)FrostologerEntity.this.method_37908();
            int numIcicles = this.numIciclesProvider.method_35008(FrostologerEntity.this.field_5974);
            this.nextStartTime = FrostologerEntity.this.field_6012 + 20;
            for (int i = 0; i < numIcicles; ++i) {
                class_2338 blockPos = FrostologerEntity.this.method_24515().method_10069(-2 + FrostologerEntity.this.field_5974.method_43048(5), 2, -2 + FrostologerEntity.this.field_5974.method_43048(5));
                ThrownIcicleEntity icicle = (ThrownIcicleEntity)FEntityTypes.THROWN_ICICLE.method_5883((class_1937)serverWorld);
                if (icicle == null) {
                    return;
                }
                icicle.method_5725(blockPos, 0.0f, 0.0f);
                icicle.method_7432((class_1297)FrostologerEntity.this);
                icicle.method_24919((class_1297)FrostologerEntity.this, FrostologerEntity.this.method_36455() + FrostologerEntity.this.field_5974.method_43057(), FrostologerEntity.this.method_5791() + FrostologerEntity.this.field_5974.method_43057(), 0.0f, 3.0f, 1.0f);
                serverWorld.method_30771((class_1297)icicle);
            }
        }

        protected int method_7149() {
            return 20;
        }

        protected int method_7151() {
            return 20;
        }

        @Nullable
        protected class_3414 method_7150() {
            return class_3417.field_15193;
        }

        protected class_1617.class_1618 method_7147() {
            return class_1617.class_1618.field_7379;
        }
    }

    protected class DestroyHeatSourcesGoal
    extends class_1617.class_1620 {
        private final int range;

        protected DestroyHeatSourcesGoal(int range) {
            super((class_1617)FrostologerEntity.this);
            this.range = range;
        }

        public void method_6269() {
            super.method_6269();
            if (FrostologerEntity.this.method_5809()) {
                FrostologerEntity.this.method_5646();
                FrostologerEntity.this.method_36975();
            }
            FrostologerEntity.this.isChanneling = true;
        }

        public boolean method_6264() {
            if (FrostologerEntity.this.method_7137()) {
                return false;
            }
            if (FrostologerEntity.this.field_6012 < this.field_7384) {
                return false;
            }
            if (!FrostologerEntity.this.hasTarget()) {
                return false;
            }
            return FrostologerEntity.this.method_5809() || FrostologerEntity.this.isInHeatedArea();
        }

        public boolean method_6266() {
            return this.field_7385 > 0;
        }

        public void method_6268() {
            class_238 box = FrostologerEntity.this.method_5829().method_1014((double)this.range);
            @Nullable class_3218 serverWorld = null;
            class_1937 world = FrostologerEntity.this.method_37908();
            if (!world.field_9236) {
                serverWorld = (class_3218)world;
            }
            if (FrostologerEntity.this.method_5809()) {
                FrostologerEntity.this.method_5646();
                FrostologerEntity.this.method_36975();
            }
            int heatDrain = Frostiful.getConfig().combatConfig.getFrostologerHeatDrainPerTick();
            for (class_1309 victim : world.method_8390(class_1309.class, box, entity -> true)) {
                victim.thermoo$addTemperature(-heatDrain, (HeatingMode)HeatingModes.ACTIVE);
                if (serverWorld == null) continue;
                EnervationEnchantment.addHeatDrainParticles(serverWorld, (class_1297)FrostologerEntity.this, (class_1297)victim, 5, 0.08);
            }
            super.method_6268();
        }

        protected void method_7148() {
            class_1937 world = FrostologerEntity.this.method_37908();
            if (!world.method_8450().method_8355(class_1928.field_19388)) {
                return;
            }
            class_2338 origin = FrostologerEntity.this.method_24515();
            class_2382 distance = new class_2382(this.range, this.range, this.range);
            for (class_2338 pos : class_2338.method_10097((class_2338)origin.method_10059(distance), (class_2338)origin.method_10081(distance))) {
                class_2680 state = world.method_8320(pos);
                if (!EnvironmentManager.INSTANCE.getController().isHeatSource(state) || !(world instanceof class_3218)) continue;
                class_3218 serverWorld = (class_3218)world;
                FrostologerEntity.this.destroyHeatSource(serverWorld, state, pos);
            }
            FrostologerEntity.this.isChanneling = false;
        }

        protected int method_7146() {
            return 60;
        }

        protected int method_7149() {
            return 60;
        }

        protected int method_7151() {
            return 140;
        }

        @Nullable
        protected class_3414 method_7150() {
            return FSoundEvents.ENTITY_FROSTOLOGER_PREPARE_CAST_BLIZZARD;
        }

        protected class_1617.class_1618 method_7147() {
            return class_1617.class_1618.field_7382;
        }
    }
}

