/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.NBTConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.ItemSearchMode;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.BlankPanel;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class SelectItemStackScreen
extends BaseScreen {
    public static final ExecutorService ITEM_SEARCH = Executors.newSingleThreadExecutor(task -> {
        Thread thread = new Thread(task, "FTBLibrary-ItemSearch");
        thread.setDaemon(true);
        return thread;
    });
    public static final List<ItemSearchMode> modes = new ArrayList<ItemSearchMode>();
    private static ItemSearchMode activeMode;
    private final ItemStackConfig config;
    private final ConfigCallback callback;
    private class_1799 current;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final Panel panelStacks;
    private final PanelScrollBar scrollBar;
    private final TextBox searchBox;
    private final Panel tabs;
    public long update = Long.MAX_VALUE;

    public List<Widget> getItems(String search, Panel panel) {
        Stopwatch timer = Stopwatch.createStarted();
        if (activeMode == null) {
            return Collections.emptyList();
        }
        Collection<class_1799> items = activeMode.getAllItems();
        ArrayList<Widget> widgets = new ArrayList<Widget>(search.isEmpty() ? items.size() + 1 : 64);
        String mod = "";
        if (search.startsWith("@")) {
            mod = search.substring(1);
        }
        ItemStackButton button = new ItemStackButton(panel, class_1799.field_8037);
        if (this.config.allowEmptyItem() && button.shouldAdd(search, mod)) {
            widgets.add(new ItemStackButton(panel, class_1799.field_8037));
        }
        for (class_1799 stack : items) {
            if (stack.method_7960() || !(button = new ItemStackButton(panel, stack)).shouldAdd(search, mod)) continue;
            widgets.add(button);
            int j = widgets.size() - 1;
            button.setPos(1 + j % 9 * 19, 1 + j / 9 * 19);
        }
        FTBLibrary.LOGGER.info("Done updating item list in {}\u03bcs!", (Object)timer.stop().elapsed(TimeUnit.MICROSECONDS));
        return widgets;
    }

    public SelectItemStackScreen(ItemStackConfig c, ConfigCallback cb) {
        this.setSize(211, 150);
        this.config = c;
        this.callback = cb;
        this.current = ((class_1799)this.config.getValue()).method_7960() ? class_1799.field_8037 : ((class_1799)this.config.getValue()).method_7972();
        int bsize = this.width / 2 - 10;
        this.buttonCancel = new SimpleTextButton(this, (class_2561)class_2561.method_43471((String)"gui.cancel"), Icon.empty()){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                SelectItemStackScreen.this.doCancel();
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buttonAccept = new SimpleTextButton(this, (class_2561)class_2561.method_43471((String)"gui.accept"), Icon.empty()){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                SelectItemStackScreen.this.doAccept();
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
        this.panelStacks = new BlankPanel(this){

            @Override
            public void addWidgets() {
                SelectItemStackScreen.this.update = System.currentTimeMillis() + 100L;
            }

            @Override
            public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                theme.drawPanelBackground(graphics, x, y, w, h);
            }
        };
        this.panelStacks.setPosAndSize(9, 24, 172, 96);
        this.scrollBar = new PanelScrollBar(this, this.panelStacks);
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setScrollStep(20.0);
        this.searchBox = new TextBox(this){

            @Override
            public void onTextChanged() {
                SelectItemStackScreen.this.panelStacks.refreshWidgets();
            }
        };
        this.searchBox.setPosAndSize(8, 7, this.width - 16, 12);
        this.searchBox.ghostText = class_1074.method_4662((String)"gui.search_box", (Object[])new Object[0]);
        this.searchBox.setFocused(true);
        this.tabs = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(new ButtonSwitchMode(this));
                this.add(new ButtonEditData(this));
                if (!SelectItemStackScreen.this.config.isSingleItemOnly()) {
                    this.add(new ButtonCount(this));
                }
                this.add(new ButtonNBT(this));
                this.add(new ButtonCaps(this));
            }

            @Override
            public void alignWidgets() {
                for (Widget widget : this.widgets) {
                    widget.setSize(20, 20);
                }
                this.setHeight(this.align(WidgetLayout.VERTICAL));
            }
        };
        this.tabs.setPosAndSize(-19, 8, 20, 0);
        this.updateItemWidgets(Collections.emptyList());
    }

    private void doCancel() {
        this.callback.save(false);
    }

    private void doAccept() {
        this.config.setCurrentValue(this.current);
        this.callback.save(true);
    }

    private void updateItemWidgets(List<Widget> items) {
        this.panelStacks.getWidgets().clear();
        this.panelStacks.addAll(items);
        this.scrollBar.setPosAndSize(this.panelStacks.posX + this.panelStacks.width + 6, this.panelStacks.posY - 1, 16, this.panelStacks.height + 2);
        this.scrollBar.setValue(0.0);
    }

    @Override
    public void addWidgets() {
        this.add(this.tabs);
        this.add(this.panelStacks);
        this.add(this.scrollBar);
        this.add(this.searchBox);
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
    }

    @Override
    public void onClosed() {
        super.onClosed();
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return true;
        }
        return false;
    }

    @Override
    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(graphics, theme, x, y, w, h);
        long now = System.currentTimeMillis();
        if (now >= this.update) {
            this.update = Long.MAX_VALUE;
            CompletableFuture.supplyAsync(() -> this.getItems(this.searchBox.getText().toLowerCase(), this.panelStacks), ITEM_SEARCH).thenAcceptAsync(this::updateItemWidgets, (Executor)class_310.method_1551());
        }
    }

    @Override
    public boolean doesGuiPauseGame() {
        class_437 screen = this.getPrevScreen();
        return screen != null && screen.method_25421();
    }

    static {
        modes.add(ItemSearchMode.ALL_ITEMS);
        modes.add(ItemSearchMode.INVENTORY);
        activeMode = null;
    }

    private class ItemStackButton
    extends Button {
        private final class_1799 stack;

        private ItemStackButton(Panel panel, class_1799 is) {
            super(panel, (class_2561)class_2561.method_43473(), Icons.BARRIER);
            this.setSize(18, 18);
            this.stack = is;
            this.title = null;
            this.icon = ItemIcon.getItemIcon(is);
        }

        public boolean shouldAdd(String search, String mod) {
            if (search.isEmpty()) {
                return true;
            }
            if (!mod.isEmpty()) {
                return RegistrarManager.getId((Object)this.stack.method_7909(), (class_5321)class_7924.field_41197).method_12836().contains(mod);
            }
            return this.stack.method_7964().getString().toLowerCase().contains(search);
        }

        @Override
        public class_2561 getTitle() {
            if (this.title == null) {
                this.title = this.stack.method_7964();
            }
            return this.title;
        }

        @Override
        public void addMouseOverText(TooltipList list) {
        }

        @Override
        public WidgetType getWidgetType() {
            return this.stack.method_7909() == SelectItemStackScreen.this.current.method_7909() && Objects.equals(this.stack.method_7969(), SelectItemStackScreen.this.current.method_7969()) ? WidgetType.MOUSE_OVER : super.getWidgetType();
        }

        @Override
        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            (this.getWidgetType() == WidgetType.MOUSE_OVER ? Color4I.LIGHT_GREEN.withAlpha(70) : Color4I.BLACK.withAlpha(50)).draw(graphics, x, y, w, h);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            SelectItemStackScreen.this.current = this.stack.method_7972();
        }
    }

    private class ButtonCaps
    extends ButtonStackConfig {
        public ButtonCaps(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"ftblibrary.select_item.caps"), ItemIcon.getItemIcon(class_1802.field_8782));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            class_2487 nbt = SelectItemStackScreen.this.current.method_7953(new class_2487());
            NBTConfig c = new NBTConfig();
            EditConfigFromStringScreen.open(c, (class_2487)nbt.method_10580("ForgeCaps"), (class_2487)((class_1799)SelectItemStackScreen.this.config.getDefaultValue()).method_7953(new class_2487()).method_10580("ForgeCaps"), this.getTitle(), accepted -> {
                if (accepted) {
                    if (c.getValue() == null || ((class_2487)c.getValue()).method_33133()) {
                        nbt.method_10551("ForgeCaps");
                    } else {
                        nbt.method_10566("ForgeCaps", (class_2520)c.getValue());
                    }
                    SelectItemStackScreen.this.current = class_1799.method_7915((class_2487)nbt);
                }
                SelectItemStackScreen.this.run();
            });
        }
    }

    private class ButtonNBT
    extends ButtonStackConfig {
        public ButtonNBT(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"ftblibrary.select_item.nbt"), ItemIcon.getItemIcon(class_1802.field_8448));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            NBTConfig c = new NBTConfig();
            EditConfigFromStringScreen.open(c, SelectItemStackScreen.this.current.method_7969(), ((class_1799)SelectItemStackScreen.this.config.getDefaultValue()).method_7969(), this.getTitle(), accepted -> {
                if (accepted) {
                    SelectItemStackScreen.this.current.method_7980((class_2487)c.getValue());
                }
                this.run();
            });
        }
    }

    private class ButtonCount
    extends ButtonStackConfig {
        public ButtonCount(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"ftblibrary.select_item.count"), ItemIcon.getItemIcon(class_1802.field_8407));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            IntConfig c = new IntConfig(0, SelectItemStackScreen.this.current.method_7914());
            EditConfigFromStringScreen.open(c, SelectItemStackScreen.this.current.method_7947(), ((class_1799)SelectItemStackScreen.this.config.getDefaultValue()).method_7947(), this.getTitle(), accepted -> {
                if (accepted) {
                    SelectItemStackScreen.this.current.method_7939(((Integer)c.getValue()).intValue());
                }
                this.run();
            });
        }
    }

    private class ButtonEditData
    extends Button {
        public ButtonEditData(Panel panel) {
            super(panel, (class_2561)class_2561.method_43473(), Icons.BUG);
        }

        @Override
        public void drawIcon(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_22903();
            poseStack.method_22904((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
            if (w != 16 || h != 16) {
                int s = Math.min(w, h);
                poseStack.method_22905((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
            }
            GuiHelper.drawItem(graphics, SelectItemStackScreen.this.current, 0, true, null);
            poseStack.method_22909();
        }

        @Override
        public class_2561 getTitle() {
            return SelectItemStackScreen.this.current.method_7964();
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            NBTConfig c = new NBTConfig();
            EditConfigFromStringScreen.open(c, SelectItemStackScreen.this.current.method_7953(new class_2487()), ((class_1799)SelectItemStackScreen.this.config.getDefaultValue()).method_7953(new class_2487()), this.getTitle(), accepted -> {
                if (accepted) {
                    SelectItemStackScreen.this.current = class_1799.method_7915((class_2487)((class_2487)c.getValue()));
                }
                this.run();
            });
        }
    }

    private abstract class ButtonStackConfig
    extends Button {
        public ButtonStackConfig(Panel panel, class_2561 title, Icon icon) {
            super(panel, title, icon);
        }

        @Override
        public WidgetType getWidgetType() {
            return SelectItemStackScreen.this.current.method_7960() ? WidgetType.DISABLED : super.getWidgetType();
        }
    }

    private class ButtonSwitchMode
    extends Button {
        private final Iterator<ItemSearchMode> modeIterator;

        public ButtonSwitchMode(Panel panel) {
            super(panel);
            this.modeIterator = Iterators.cycle(modes);
            if (activeMode == null) {
                activeMode = this.modeIterator.next();
            }
        }

        @Override
        public void drawIcon(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            activeMode.getIcon().draw(graphics, x, y, w, h);
        }

        @Override
        public class_2561 getTitle() {
            return class_2561.method_43471((String)"ftblibrary.select_item.list_mode");
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            list.add((class_2561)activeMode.getDisplayName().method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)(" [" + SelectItemStackScreen.this.panelStacks.getWidgets().size() + "]")).method_27692(class_124.field_1063)));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            activeMode = this.modeIterator.next();
            SelectItemStackScreen.this.panelStacks.refreshWidgets();
        }
    }
}

