/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconProperties;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

public class HollowRectangleIcon
extends Icon {
    public Color4I color;
    public boolean roundEdges;

    public HollowRectangleIcon(Color4I c, boolean r) {
        this.color = c;
        this.roundEdges = r;
    }

    @Override
    public HollowRectangleIcon copy() {
        return new HollowRectangleIcon(this.color, this.roundEdges);
    }

    @Override
    public HollowRectangleIcon withColor(Color4I color) {
        return new HollowRectangleIcon(color, this.roundEdges);
    }

    @Override
    public HollowRectangleIcon withTint(Color4I c) {
        return this.withColor(this.color.withTint(c));
    }

    @Override
    protected void setProperties(IconProperties properties) {
        super.setProperties(properties);
        this.roundEdges = properties.getBoolean("round_edges", this.roundEdges);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw(class_332 graphics, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect(graphics, x, y, w, h, this.color, this.roundEdges);
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.addProperty("id", "hollow_rectangle");
        o.add("color", this.color.getJson());
        if (this.roundEdges) {
            o.addProperty("round_edges", Boolean.valueOf(true));
        }
        return o;
    }
}

