/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.misc;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;

public class SelectImageScreen
extends ButtonListBaseScreen {
    private final ImageConfig imageConfig;
    private final ConfigCallback callback;
    private final SimpleTextButton refreshButton;
    private static List<ImageDetails> cachedImages = null;

    public SelectImageScreen(ImageConfig i, ConfigCallback c) {
        this.imageConfig = i;
        this.callback = c;
        this.setTitle((class_2561)class_2561.method_43470((String)"Select Image"));
        this.setHasSearchBox(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.refreshButton = new SimpleTextButton(this, (class_2561)class_2561.method_43471((String)"ftblibrary.select_image.rescan"), Icons.REFRESH){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                SelectImageScreen.clearCachedImages();
                SelectImageScreen.this.refreshWidgets();
            }
        };
        this.refreshButton.setSize(20, 20);
    }

    @Override
    public boolean onInit() {
        return this.setSizeProportional(0.5f, 0.8f);
    }

    private List<ImageDetails> getImageList() {
        if (cachedImages == null) {
            ArrayList images = new ArrayList();
            StringUtils.ignoreResourceLocationErrors = true;
            Map textures = Collections.emptyMap();
            try {
                textures = class_310.method_1551().method_1478().method_14488("textures", t -> t.method_12832().endsWith(".png"));
            }
            catch (Exception ex) {
                FTBLibrary.LOGGER.error("A mod has broken resource preventing this list from loading: " + ex);
            }
            StringUtils.ignoreResourceLocationErrors = false;
            textures.keySet().forEach(rl -> {
                if (!class_2960.method_20207((String)rl.toString())) {
                    FTBLibrary.LOGGER.warn("Image " + rl + " has invalid path! Report this to author of '" + rl.method_12836() + "'!");
                } else if (this.isValidImage((class_2960)rl)) {
                    images.add(rl);
                }
            });
            cachedImages = images.stream().sorted().map(res -> {
                class_2960 res1 = new class_2960(res.method_12836(), res.method_12832().substring(9, res.method_12832().length() - 4));
                class_1058 sprite = class_310.method_1551().method_1554().method_24153(class_1723.field_21668).method_4608(res1);
                if (sprite.method_45851().method_45816().equals((Object)class_1047.method_4539())) {
                    res1 = res;
                }
                return new ImageDetails((class_2561)class_2561.method_43470((String)res1.method_12836()).method_27692(class_124.field_1065).method_27693(":").method_10852((class_2561)class_2561.method_43470((String)res1.method_12832()).method_27692(class_124.field_1054)), Icon.getIcon(res1));
            }).toList();
        }
        return cachedImages;
    }

    @Override
    public void alignWidgets() {
        super.alignWidgets();
        this.refreshButton.setPos(this.width + 2, 0);
    }

    @Override
    public void addWidgets() {
        super.addWidgets();
        this.add(this.refreshButton);
    }

    public static void clearCachedImages() {
        cachedImages = null;
    }

    public boolean allowNone() {
        return true;
    }

    public boolean isValidImage(class_2960 id) {
        return !id.method_12832().startsWith("textures/font/");
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.allowNone()) {
            panel.add(new SimpleTextButton(panel, (class_2561)class_2561.method_43470((String)"None"), Icon.empty()){

                @Override
                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    SelectImageScreen.this.imageConfig.setCurrentValue("");
                    SelectImageScreen.this.callback.save(true);
                }
            });
        }
        for (final ImageDetails res : this.getImageList()) {
            panel.add(new SimpleTextButton(panel, res.label, res.icon){

                @Override
                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    SelectImageScreen.this.imageConfig.setCurrentValue(res.icon.toString());
                    SelectImageScreen.this.callback.save(true);
                }
            });
        }
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return true;
        }
        return false;
    }

    private record ImageDetails(class_2561 label, Icon icon) {
    }

    public static enum ResourceListener implements class_4013
    {
        INSTANCE;


        public void method_14491(class_3300 resourceManager) {
            SelectImageScreen.clearCachedImages();
        }
    }
}

