/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.fabric;

import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.EnergyTask;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import team.reborn.energy.api.EnergyStorage;

public class FabricTaskScreenBlockEntity
extends TaskScreenBlockEntity {
    private final Storage<ItemVariant> itemStorage = new ItemStorageHandler();
    private final Storage<FluidVariant> fluidStorage = new FluidStorageHandler();
    private final EnergyStorage energyStorage = new RebornEnergyStorageHandler();

    public FabricTaskScreenBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(blockPos, blockState);
    }

    public Storage<ItemVariant> getItemStorage() {
        return this.itemStorage;
    }

    public Storage<FluidVariant> getFluidStorage() {
        return this.fluidStorage;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private class ItemStorageHandler
    extends SingleVariantStorage<ItemVariant> {
        private ItemStorageHandler() {
        }

        protected ItemVariant getBlankVariant() {
            return ItemVariant.blank();
        }

        protected long getCapacity(ItemVariant variant) {
            long l;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                ItemTask t = (ItemTask)task;
                l = t.getMaxProgress();
            } else {
                l = 0L;
            }
            return l;
        }

        public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            ItemTask task;
            TeamData data = FabricTaskScreenBlockEntity.this.getCachedTeamData();
            class_1799 stack = insertedVariant.toStack();
            Task task2 = FabricTaskScreenBlockEntity.this.getTask();
            if (task2 instanceof ItemTask && data.canStartTasks((task = (ItemTask)task2).getQuest())) {
                class_1799 res = task.insert(data, stack, true);
                int nAdded = stack.method_7947() - res.method_7947();
                if (nAdded > 0) {
                    transaction.addCloseCallback((transaction1, result) -> {
                        if (result.wasCommitted()) {
                            data.addProgress(task, nAdded);
                        }
                    });
                }
                return nAdded;
            }
            return 0L;
        }

        public long extract(ItemVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            TeamData data;
            ItemTask task;
            Task task2;
            if (!FabricTaskScreenBlockEntity.this.isInputOnly() && (task2 = FabricTaskScreenBlockEntity.this.getTask()) instanceof ItemTask && !ItemFiltersAPI.isFilter((class_1799)(task = (ItemTask)task2).getItemStack()) && (data = FabricTaskScreenBlockEntity.this.getCachedTeamData()) != null && data.canStartTasks(task.getQuest()) && !data.isCompleted(task)) {
                int itemsRemoved = (int)Math.min(data.getProgress(task), maxAmount);
                this.updateSnapshots(transaction);
                transaction.addCloseCallback((transaction1, result) -> {
                    if (result.wasCommitted()) {
                        data.addProgress(task, -itemsRemoved);
                    }
                });
                return itemsRemoved;
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public ItemVariant getResource() {
            ItemVariant itemVariant;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                ItemTask t = (ItemTask)task;
                itemVariant = ItemVariant.of((class_1799)t.getItemStack());
            } else {
                itemVariant = this.getBlankVariant();
            }
            return itemVariant;
        }
    }

    private class FluidStorageHandler
    extends SingleVariantStorage<FluidVariant> {
        private FluidStorageHandler() {
        }

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            long l;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask t = (FluidTask)task;
                l = t.getMaxProgress();
            } else {
                l = 0L;
            }
            return l;
        }

        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask task2 = (FluidTask)task;
                TeamData data = FabricTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(task2.getQuest()) && !data.isCompleted(task2)) {
                    this.updateSnapshots(transaction);
                    long space = task2.getMaxProgress() - data.getProgress(task2);
                    long toAdd = Math.min(maxAmount, space);
                    transaction.addCloseCallback((transaction1, result) -> {
                        if (result.wasCommitted()) {
                            data.addProgress(task2, toAdd);
                        }
                    });
                    return (int)toAdd;
                }
            }
            return 0L;
        }

        public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask task2 = (FluidTask)task;
                TeamData data = FabricTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(task2.getQuest()) && !data.isCompleted(task2)) {
                    long toTake = Math.min(maxAmount, data.getProgress(task2));
                    this.updateSnapshots(transaction);
                    transaction.addCloseCallback((transaction1, result) -> {
                        if (result.wasCommitted()) {
                            data.addProgress(task2, -toTake);
                        }
                    });
                    return toTake;
                }
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public FluidVariant getResource() {
            FluidVariant fluidVariant;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask t = (FluidTask)task;
                fluidVariant = FluidVariant.of((class_3611)t.getFluid(), (class_2487)t.getFluidNBT());
            } else {
                fluidVariant = this.getBlankVariant();
            }
            return fluidVariant;
        }
    }

    private class RebornEnergyStorageHandler
    implements EnergyStorage {
        private RebornEnergyStorageHandler() {
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof EnergyTask) {
                EnergyTask task2 = (EnergyTask)task;
                TeamData data = FabricTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(task2.getQuest()) && !data.isCompleted(task2)) {
                    long space = task2.getMaxProgress() - data.getProgress(task2);
                    long toAdd = Math.min(task2.getMaxInput(), Math.min(maxAmount, space));
                    transaction.addCloseCallback((transaction1, result) -> {
                        if (result.wasCommitted()) {
                            data.addProgress(task2, toAdd);
                        }
                    });
                    return toAdd;
                }
            }
            return 0L;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public boolean supportsExtraction() {
            return false;
        }

        public long getAmount() {
            long l;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof EnergyTask) {
                EnergyTask task2 = (EnergyTask)task;
                l = (int)FabricTaskScreenBlockEntity.this.getCachedTeamData().getProgress(task2);
            } else {
                l = 0L;
            }
            return l;
        }

        public long getCapacity() {
            long l;
            Task task = FabricTaskScreenBlockEntity.this.getTask();
            if (task instanceof EnergyTask) {
                EnergyTask t = (EnergyTask)task;
                l = t.getValue();
            } else {
                l = 0L;
            }
            return l;
        }
    }
}

