/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.ClaimChoiceRewardMessage;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ChoiceReward;
import java.util.Optional;
import net.minecraft.class_2561;

public class SelectChoiceRewardScreen
extends ButtonListBaseScreen {
    private final ChoiceReward choiceReward;

    public SelectChoiceRewardScreen(ChoiceReward choiceReward) {
        this.choiceReward = choiceReward;
        this.setTitle((class_2561)class_2561.method_43471((String)"ftbquests.reward.ftbquests.choice"));
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        if (this.choiceReward.getTable() != null) {
            this.choiceReward.getTable().getWeightedRewards().forEach(wr -> panel.add((Widget)new ChoiceRewardButton(panel, (WeightedReward)wr)));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class ChoiceRewardButton
    extends SimpleTextButton {
        private final WeightedReward weightedReward;

        private ChoiceRewardButton(Panel panel, WeightedReward wr) {
            super(panel, wr.getReward().getTitle(), wr.getReward().getIcon());
            this.weightedReward = wr;
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            this.weightedReward.getReward().addMouseOverText(list);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.closeGui();
            if (SelectChoiceRewardScreen.this.choiceReward.getTable() != null) {
                new ClaimChoiceRewardMessage(SelectChoiceRewardScreen.this.choiceReward.id, SelectChoiceRewardScreen.this.choiceReward.getTable().getWeightedRewards().indexOf(this.weightedReward)).sendToServer();
            }
        }

        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of(this.weightedReward.getReward().getIngredient((Widget)this), (Widget)this);
        }
    }
}

