/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.ChangeChapterGroupResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.class_2540;

public class ChangeChapterGroupMessage
extends BaseC2SMessage {
    private final long chapterId;
    private final long groupId;

    public ChangeChapterGroupMessage(class_2540 buffer) {
        this.chapterId = buffer.readLong();
        this.groupId = buffer.readLong();
    }

    public ChangeChapterGroupMessage(long chapterId, long groupId) {
        this.chapterId = chapterId;
        this.groupId = groupId;
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CHANGE_CHAPTER_GROUP;
    }

    public void write(class_2540 buffer) {
        buffer.writeLong(this.chapterId);
        buffer.writeLong(this.groupId);
    }

    public void handle(NetworkManager.PacketContext context) {
        Chapter chapter;
        if (NetUtils.canEdit(context) && (chapter = ServerQuestFile.INSTANCE.getChapter(this.chapterId)) != null) {
            ChapterGroup group = ServerQuestFile.INSTANCE.getChapterGroup(this.groupId);
            if (chapter.getGroup() != group) {
                chapter.getGroup().removeChapter(chapter);
                group.addChapter(chapter);
                chapter.file.clearCachedData();
                chapter.file.markDirty();
                new ChangeChapterGroupResponseMessage(this.chapterId, this.groupId).sendToAll(context.getPlayer().method_5682());
            }
        }
    }
}

