/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.MoveMovableMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public class QuestLink
extends QuestObject
implements Movable {
    private Chapter chapter;
    private long linkId;
    private double x;
    private double y;
    private String shape;
    private double size;

    public QuestLink(long id, Chapter chapter, long linkId) {
        super(id);
        this.chapter = chapter;
        this.linkId = linkId;
        this.shape = "";
        this.size = 1.0;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST_LINK;
    }

    @Override
    public BaseQuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public class_2561 getAltTitle() {
        return this.getQuest().map(Quest::getAltTitle).orElse((class_2561)class_2561.method_43473());
    }

    @Override
    public Icon getAltIcon() {
        return this.getQuest().map(Quest::getAltIcon).orElse(null);
    }

    @Override
    public boolean isVisible(TeamData data) {
        return this.getQuest().map(q -> q.isVisible(data)).orElse(false);
    }

    @Override
    public int getRelativeProgressFromChildren(TeamData data) {
        return 0;
    }

    public Optional<Quest> getQuest() {
        Optional<Quest> optional;
        QuestObject questObject = this.chapter.file.get(this.linkId);
        if (questObject instanceof Quest) {
            Quest q = (Quest)questObject;
            optional = Optional.of(q);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public long getParentID() {
        return this.chapter.id;
    }

    @Override
    public void onCreated() {
        this.chapter.addQuestLink(this);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.removeQuestLink(this);
    }

    @Override
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("shape", (Object)(this.shape.isEmpty() ? "default" : this.shape), v -> {
            this.shape = v.equals("default") ? "" : v;
        }, QuestShape.idMapWithDefault);
        config.addDouble("size", this.size, v -> {
            this.size = v;
        }, 1.0, 0.0625, 8.0);
        config.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.refreshQuestPanel();
            gui.refreshViewQuestPanel();
        }
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("linked_quest", QuestLink.getCodeString(this.linkId));
        nbt.method_10549("x", this.x);
        nbt.method_10549("y", this.y);
        if (!this.shape.isEmpty()) {
            nbt.method_10582("shape", this.shape);
        }
        if (this.size != 1.0) {
            nbt.method_10549("size", this.size);
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.linkId = Long.parseLong(nbt.method_10558("linked_quest"), 16);
        this.x = nbt.method_10574("x");
        this.y = nbt.method_10574("y");
        this.shape = nbt.method_10558("shape");
        if (this.shape.equals("default")) {
            this.shape = "";
        }
        this.size = nbt.method_10545("size") ? nbt.method_10574("size") : 1.0;
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.writeLong(this.linkId);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.size);
        buffer.method_10814(this.shape);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.linkId = buffer.readLong();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.size = buffer.readDouble();
        this.shape = buffer.method_10800(64);
    }

    public void setPosition(double qx, double qy) {
        this.x = qx;
        this.y = qy;
    }

    @Override
    public long getMovableID() {
        return this.id;
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.size;
    }

    @Override
    public double getHeight() {
        return this.size;
    }

    @Override
    public String getShape() {
        return this.shape.isEmpty() ? this.chapter.getDefaultQuestShape() : this.shape;
    }

    @Override
    public void move(Chapter to, double x, double y) {
        new MoveMovableMessage(this, to.id, x, y).sendToServer();
    }

    @Override
    public void onMoved(double newX, double newY, long newChapterId) {
        BaseQuestFile f;
        Chapter newChapter;
        this.x = newX;
        this.y = newY;
        if (newChapterId != this.chapter.id && (newChapter = (f = this.getQuestFile()).getChapter(newChapterId)) != null) {
            this.chapter.removeQuestLink(this);
            newChapter.addQuestLink(this);
            this.chapter = newChapter;
        }
    }

    public boolean linksTo(Quest quest) {
        return this.linkId == quest.id;
    }
}

