/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import com.google.common.collect.Sets;
import dev.ftb.mods.ftbquests.item.MissingItem;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class NBTUtils {
    public static class_1799 read(class_2487 nbt, String key) {
        class_2520 nbt1 = nbt.method_10580(key);
        if (nbt1 instanceof class_2487) {
            return MissingItem.readItem((class_2487)nbt1);
        }
        if (nbt1 instanceof class_2519) {
            class_2487 nbt2 = new class_2487();
            nbt2.method_10582("id", nbt1.method_10714());
            nbt2.method_10567("Count", (byte)1);
            return MissingItem.readItem(nbt2);
        }
        return class_1799.field_8037;
    }

    public static void write(class_2487 nbt, String key, class_1799 stack) {
        if (!stack.method_7960()) {
            class_2487 nbt1 = MissingItem.writeItem(stack);
            if (nbt1.method_10546() == 2 && nbt1.method_10550("Count") == 1) {
                nbt.method_10582(key, nbt1.method_10558("id"));
            } else {
                nbt.method_10566(key, (class_2520)nbt1);
            }
        }
    }

    public static boolean compareNbt(@Nullable class_2520 tagA, @Nullable class_2520 tagB, boolean fuzzy, boolean compareLists) {
        if (tagA == tagB) {
            return true;
        }
        if (tagA == null) {
            return true;
        }
        if (tagB == null) {
            return false;
        }
        if (!tagA.method_23258().equals(tagB.method_23258())) {
            return false;
        }
        if (tagA instanceof class_2487) {
            class_2487 compoundA = (class_2487)tagA;
            if (tagB instanceof class_2487) {
                class_2487 compoundB = (class_2487)tagB;
                Set keysA = compoundA.method_10541();
                Set keysB = compoundB.method_10541();
                if (!(fuzzy || keysA.size() == keysB.size() && Sets.intersection((Set)keysA, (Set)keysB).size() == keysA.size())) {
                    return false;
                }
                return keysA.stream().allMatch(key -> NBTUtils.compareNbt(compoundA.method_10580(key), compoundB.method_10580(key), fuzzy, compareLists));
            }
        }
        if (compareLists && tagA instanceof class_2499) {
            class_2499 listA = (class_2499)tagA;
            if (tagB instanceof class_2499) {
                class_2499 listB = (class_2499)tagB;
                if (listA.isEmpty()) {
                    return listB.isEmpty();
                }
                if (listA.size() != listB.size()) {
                    return false;
                }
                return IntStream.range(0, listA.size()).allMatch(i -> NBTUtils.compareNbt(listA.method_10534(i), listB.method_10534(i), fuzzy, true));
            }
        }
        return tagA.equals(tagB);
    }
}

