/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class EnumProperty
extends TeamProperty<String> {
    private final List<String> values;
    private final Map<String, class_2561> names;

    public EnumProperty(class_2960 id, String def, List<String> v, Map<String, class_2561> n) {
        super(id, def);
        this.values = v;
        this.names = n;
    }

    public <T> EnumProperty(class_2960 id, NameMap<T> nameMap) {
        super(id, nameMap.getName(nameMap.defaultValue));
        this.values = nameMap.keys;
        this.names = new HashMap<String, class_2561>();
        for (Object val : nameMap) {
            this.names.put(nameMap.getName(val), nameMap.getDisplayName(val));
        }
    }

    public EnumProperty(class_2960 id, class_2540 buf) {
        super(id, buf.method_10800(Short.MAX_VALUE));
        int sv = buf.method_10816();
        this.values = new ArrayList<String>(sv);
        for (int i = 0; i < sv; ++i) {
            this.values.add(buf.method_10800(Short.MAX_VALUE));
        }
        int sn = buf.method_10816();
        this.names = new HashMap<String, class_2561>(sn);
        for (int i = 0; i < sn; ++i) {
            this.names.put(buf.method_10800(Short.MAX_VALUE), buf.method_10808());
        }
    }

    @Override
    public TeamPropertyType<String> getType() {
        return TeamPropertyType.ENUM;
    }

    @Override
    public Optional<String> fromString(String string) {
        return Optional.of(string);
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10788((String)this.defaultValue, Short.MAX_VALUE);
        buf.method_10804(this.values.size());
        for (String string : this.values) {
            buf.method_10788(string, Short.MAX_VALUE);
        }
        buf.method_10804(this.names.size());
        for (Map.Entry entry : this.names.entrySet()) {
            buf.method_10788((String)entry.getKey(), Short.MAX_VALUE);
            buf.method_10805((class_2561)entry.getValue());
        }
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<String> value) {
        config.addEnum(this.id.method_12832(), (Object)((String)value.value), value.consumer, NameMap.of((Object)((String)this.defaultValue), this.values).name(s -> this.names.getOrDefault(s, (class_2561)class_2561.method_43470((String)s))).create());
    }

    @Override
    public class_2520 toNBT(String value) {
        return class_2519.method_23256((String)value);
    }

    @Override
    public Optional<String> fromNBT(class_2520 tag) {
        if (tag instanceof class_2519) {
            return Optional.of(tag.method_10714());
        }
        return Optional.empty();
    }
}

