/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.TeamMessage;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import dev.ftb.mods.ftbteams.client.gui.MyTeamScreen;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import dev.ftb.mods.ftbteams.data.PlayerPermissions;
import dev.ftb.mods.ftbteams.net.OpenGUIMessage;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class FTBTeamsClient {
    public static final class_2960 OPEN_GUI_ID = new class_2960("ftbteams", "open_gui");
    public static class_304 openTeamsKey;

    public static void init() {
        FTBTeamsClient.registerKeys();
        CustomClickEvent.EVENT.register(event -> {
            if (event.id().equals((Object)OPEN_GUI_ID)) {
                new OpenGUIMessage().sendToServer();
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        ClientRawInputEvent.KEY_PRESSED.register(FTBTeamsClient::keyPressed);
    }

    private static void registerKeys() {
        openTeamsKey = new class_304("key.ftbteams.open_gui", class_3675.class_307.field_1668, -1, "key.categories.ftbteams");
        KeyMappingRegistry.register((class_304)openTeamsKey);
    }

    private static EventResult keyPressed(class_310 client, int keyCode, int scanCode, int action, int modifiers) {
        if (openTeamsKey.method_1434()) {
            new OpenGUIMessage().sendToServer();
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public static void openMyTeamGui(TeamPropertyCollection properties, PlayerPermissions permissions) {
        new MyTeamScreen(properties, permissions).openGui();
    }

    public static void updateSettings(UUID id, TeamPropertyCollection properties) {
        if (ClientTeamManagerImpl.getInstance() == null) {
            return;
        }
        ClientTeamManagerImpl.getInstance().getTeam(id).ifPresent(team -> team.updateProperties(properties));
    }

    public static void sendMessage(UUID from, class_2561 text) {
        if (ClientTeamManagerImpl.getInstance() == null) {
            return;
        }
        TeamMessage msg = FTBTeamsAPI.api().createMessage(from, text);
        ClientTeamManagerImpl.getInstance().selfTeam().addMessage(msg);
        MyTeamScreen screen = (MyTeamScreen)((Object)ClientUtils.getCurrentGuiAs(MyTeamScreen.class));
        if (screen != null) {
            screen.refreshChat();
        }
    }

    public static void updatePresence(KnownClientPlayer update) {
        if (ClientTeamManagerImpl.getInstance() != null) {
            ClientTeamManagerImpl.getInstance().updatePresence(update);
        }
    }
}

