/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamMessage;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.TeamPropertyCollectionImpl;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class AbstractTeamBase
implements Team {
    protected final UUID id;
    protected final TeamPropertyCollectionImpl properties;
    protected final Map<UUID, TeamRank> ranks;
    protected class_2487 extraData;
    protected final List<TeamMessage> messageHistory;
    private boolean valid;

    public AbstractTeamBase(UUID id) {
        this.id = id;
        this.ranks = new HashMap<UUID, TeamRank>();
        this.properties = new TeamPropertyCollectionImpl();
        this.extraData = new class_2487();
        this.messageHistory = new LinkedList<TeamMessage>();
        this.valid = true;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public UUID getTeamId() {
        return this.id;
    }

    @Override
    public TeamPropertyCollection getProperties() {
        return this.properties;
    }

    public abstract TeamType getType();

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractTeam) {
            return this.id.equals(((AbstractTeam)o).getId());
        }
        return false;
    }

    public String toString() {
        return this.getShortName();
    }

    @Override
    public class_2487 getExtraData() {
        return this.extraData;
    }

    @Override
    public <T> T getProperty(TeamProperty<T> property) {
        return this.properties.get(property);
    }

    @Override
    public <T> void setProperty(TeamProperty<T> property, T value) {
        this.properties.set(property, value);
        this.markDirty();
    }

    public String getDisplayName() {
        return this.getProperty(TeamProperties.DISPLAY_NAME);
    }

    public String getDescription() {
        return this.getProperty(TeamProperties.DESCRIPTION);
    }

    public int getColor() {
        return this.getProperty(TeamProperties.COLOR).rgb();
    }

    public boolean isFreeToJoin() {
        return this.getProperty(TeamProperties.FREE_TO_JOIN);
    }

    public int getMaxMessageHistorySize() {
        return this.getProperty(TeamProperties.MAX_MSG_HISTORY_SIZE);
    }

    @Override
    public String getShortName() {
        String s = this.getDisplayName().replaceAll("\\W", "_");
        return (s.length() > 50 ? s.substring(0, 50) : s) + "#" + this.getId().toString().substring(0, 8);
    }

    @Override
    public class_2561 getName() {
        class_5250 text = class_2561.method_43470((String)this.getDisplayName());
        if (this.getType().isPlayer()) {
            text.method_27692(class_124.field_1080);
        } else if (this.getType().isServer()) {
            text.method_27692(class_124.field_1061);
        } else {
            text.method_27692(class_124.field_1075);
        }
        text.method_10862(text.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, "/ftbteams info " + this.getShortName())));
        return text;
    }

    @Override
    public class_2561 getColoredName() {
        class_5250 text = class_2561.method_43470((String)this.getDisplayName());
        text.method_27696(this.getProperty(TeamProperties.COLOR).toStyle().method_10958(new class_2558(class_2558.class_2559.field_11750, "/ftbteams info " + this.getShortName())));
        return text;
    }

    @Override
    public void markDirty() {
    }

    @Override
    public TeamRank getRankForPlayer(UUID playerId) {
        TeamRank rank = this.ranks.get(playerId);
        if (rank != null) {
            return rank;
        }
        return this.isFreeToJoin() ? TeamRank.INVITED : TeamRank.NONE;
    }

    public boolean isMember(UUID uuid) {
        return this.getRankForPlayer(uuid).isMemberOrBetter();
    }

    @Override
    public Map<UUID, TeamRank> getPlayersByRank(TeamRank minRank) {
        if (minRank == TeamRank.NONE) {
            return Collections.unmodifiableMap(this.ranks);
        }
        HashMap map = new HashMap();
        this.ranks.forEach((id, rank) -> {
            if (rank.isAtLeast(minRank)) {
                map.put(id, rank);
            }
        });
        return Collections.unmodifiableMap(map);
    }

    @Override
    public String getTypeTranslationKey() {
        return "ftbteams.team_type." + this.getType().method_15434();
    }

    @Override
    public Set<UUID> getMembers() {
        return this.getPlayersByRank(TeamRank.MEMBER).keySet();
    }

    public boolean isAllyOrBetter(UUID profile) {
        return this.getRankForPlayer(profile).isAllyOrBetter();
    }

    public boolean isOfficerOrBetter(UUID profile) {
        return this.getRankForPlayer(profile).isOfficerOrBetter();
    }

    public boolean isInvited(UUID profile) {
        return this.getRankForPlayer(profile).isInvitedOrBetter();
    }

    public void addMessage(TeamMessage message) {
        this.addMessages(List.of(message));
    }

    public void addMessages(Collection<TeamMessage> messages) {
        this.messageHistory.addAll(messages);
        while (this.messageHistory.size() > this.getMaxMessageHistorySize()) {
            this.messageHistory.remove(0);
        }
        this.markDirty();
    }

    @Override
    public List<TeamMessage> getMessageHistory() {
        return Collections.unmodifiableList(this.messageHistory);
    }

    public void addMember(UUID id, TeamRank rank) {
        this.ranks.put(id, rank);
    }

    public void removeMember(UUID id) {
        this.ranks.remove(id);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void invalidateTeam() {
        this.valid = false;
    }
}

