/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armor_effects;

import immersive_armors.armor_effects.ArmorEffect;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class DivineArmorEffect
extends ArmorEffect {
    private static final String LAST_DIVINE = "last_divine";
    private final long cooldown;

    public DivineArmorEffect(long cooldown) {
        this.cooldown = cooldown;
    }

    private boolean isCharged(long time, class_1799 armor) {
        class_2487 tag = armor.method_7948();
        return (!tag.method_10545(LAST_DIVINE) || tag.method_10537(LAST_DIVINE) + this.cooldown < time) && this.getSetCount(armor) == 4;
    }

    @Override
    public void appendTooltip(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.appendTooltip(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.immersive_armors.divine.description").method_27692(class_124.field_1080));
        int count = this.getSetCount(stack);
        if (count == 4) {
            if (world != null && this.isCharged(world.method_8510(), stack)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"armorEffect.charged").method_27692(class_124.field_1075));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"immersive_armors.incomplete", (Object[])new Object[]{count, 4}));
        }
    }

    @Override
    public float applyArmorToDamage(class_1309 entity, class_1282 source, float amount, class_1799 armor) {
        if (this.isPrimaryArmor(armor, entity)) {
            long time = entity.method_37908().method_8510();
            boolean charged = this.getMatchingEquippedArmor(entity, armor).anyMatch(a -> this.isCharged(time, (class_1799)a));
            if (charged) {
                entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14833, entity.method_5634(), 0.5f, 1.25f);
                this.getMatchingEquippedArmor(entity, armor).forEach(a -> a.method_7948().method_10544(LAST_DIVINE, time));
                return 0.0f;
            }
        }
        return amount;
    }
}

